/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.soul;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.soul.BasicSoulBinderRecipe;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class SoulBinderRecipeManager {
    @Nonnull
    private static final SoulBinderRecipeManager instance = new SoulBinderRecipeManager();
    @Nonnull
    public static final String KEY_RECIPE_UID = "recipeUID";
    @Nonnull
    public static final String KEY_INPUT_STACK = "inputStack";
    @Nonnull
    public static final String KEY_OUTPUT_STACK = "outputStack";
    @Nonnull
    public static final String KEY_REQUIRED_ENERGY = "requiredEnergyRF";
    @Nonnull
    public static final String KEY_REQUIRED_XP = "requiredXP";
    @Nonnull
    public static final String KEY_SOUL_TYPES = "entityTypes";

    public static SoulBinderRecipeManager getInstance() {
        return instance;
    }

    public boolean addRecipeFromNBT(@Nonnull NBTTagCompound root) {
        try {
            String recipeUid = root.func_74779_i(KEY_RECIPE_UID);
            if (recipeUid.trim().length() == 0) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as recipe UID not set: " + root);
                return false;
            }
            ItemStack inputStack = this.getStackFromRoot(root, KEY_INPUT_STACK);
            if (Prep.isInvalid(inputStack)) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as no input stack defined: " + root);
                return false;
            }
            ItemStack outputStack = this.getStackFromRoot(root, KEY_OUTPUT_STACK);
            if (Prep.isInvalid(outputStack)) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as no output stack defined: " + root);
                return false;
            }
            int energyRequired = root.func_74762_e(KEY_REQUIRED_ENERGY);
            if (energyRequired <= 0) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as energy required was <= 0: " + root);
                return false;
            }
            int xpLevelsRequired = root.func_74762_e(KEY_REQUIRED_XP);
            if (xpLevelsRequired <= 0) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as XP required was <= 0: " + root);
                return false;
            }
            String str = root.func_74779_i(KEY_SOUL_TYPES);
            if (str.trim().length() == 0) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as no soul types defined: " + root);
                return false;
            }
            String[] entityNames = str.split("\\|");
            NNList entityRLs = new NNList();
            for (String string : entityNames) {
                if (string == null || string.trim().isEmpty()) {
                    Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as no soul types contains emtpty entry: " + root);
                    return false;
                }
                entityRLs.add((Object)new ResourceLocation(string));
            }
            if (entityRLs.isEmpty()) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as no soul types defined: " + root);
                return false;
            }
            BasicSoulBinderRecipe recipe = new BasicSoulBinderRecipe(inputStack, outputStack, energyRequired, xpLevelsRequired, recipeUid, (ResourceLocation[])entityRLs.toArray((Object[])new ResourceLocation[0]));
            MachineRecipeRegistry.instance.registerRecipe("soulbinder", recipe);
            return true;
        }
        catch (Exception e) {
            Log.error("SoulBinderRecipeManager: Could not add custom soul binder exception thrown when parsing message: " + e);
            return false;
        }
    }

    @Nonnull
    private ItemStack getStackFromRoot(@Nonnull NBTTagCompound root, @Nonnull String string) {
        return new ItemStack(root.func_74775_l(string));
    }
}

