/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.niard;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.google.common.collect.Lists;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.machine.gui.GuiCapMachineBase;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.niard.ContainerNiard;
import crazypants.enderio.machines.machine.niard.TileNiard;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class GuiNiard
extends GuiCapMachineBase<TileNiard> {
    private static final int POWERX = 12;
    private static final int POWERY = 14;
    private static final int POWER_HEIGHT = 42;
    @Nonnull
    private static final Rectangle RECTANGLE_TANK = new Rectangle(80, 21, 16, 47);
    @Nonnull
    private final ToggleButton showRangeB;

    public GuiNiard(@Nonnull InventoryPlayer playerInv, @Nonnull TileNiard te) {
        super(te, new ContainerNiard<TileNiard>(playerInv, te), "niard");
        this.addDrawingElement(new PowerBar(te.getEnergy(), this, 16, 14, 42));
        this.addToolTip(new GuiToolTip(RECTANGLE_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(Lang.GUI_TANK_TANK_TANK_TANK.get());
                this.text.add(LangFluid.MB((IFluidTank)((TileNiard)((GuiNiard)GuiNiard.this).getTileEntity()).inputTank));
            }
        });
        this.showRangeB = new ToggleButton((IGuiScreen)this, -1, 155, 43, (IWidgetIcon)IconEIO.SHOW_RANGE, (IWidgetIcon)IconEIO.HIDE_RANGE);
        this.showRangeB.setSize(16, 16);
        this.addToolTip(new GuiToolTip(this.showRangeB.getBounds(), new String[]{"null"}){

            @Nonnull
            public List<String> getToolTipText() {
                return Lists.newArrayList((Object[])new String[]{(GuiNiard.this.showRangeB.isSelected() ? Lang.GUI_HIDE_RANGE : Lang.GUI_SHOW_RANGE).get()});
            }
        });
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        NNList ghostSlots = this.getGhostSlotHandler().getGhostSlots();
        ghostSlots.clear();
        ((ContainerNiard)this.field_147002_h).createGhostSlots((List<GhostSlot>)ghostSlots);
        this.showRangeB.onGuiInit();
        this.showRangeB.setSelected(((TileNiard)this.getTileEntity()).isShowingRange());
    }

    protected void func_146284_a(@Nonnull GuiButton b) throws IOException {
        if (b == this.showRangeB) {
            ((TileNiard)this.getTileEntity()).setShowRange(this.showRangeB.isSelected());
            return;
        }
        super.func_146284_a(b);
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_TANK.contains(mouseX, mouseY)) {
            return ((TileNiard)this.getTileEntity()).inputTank.getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderUtil.renderGuiTank((FluidTank)((TileNiard)this.getTileEntity()).inputTank, (double)(this.field_147003_i + GuiNiard.RECTANGLE_TANK.x), (double)(this.field_147009_r + GuiNiard.RECTANGLE_TANK.y), (double)this.field_73735_i, (double)GuiNiard.RECTANGLE_TANK.width, (double)GuiNiard.RECTANGLE_TANK.height);
        GuiNiard.renderFlowingFluid(((TileNiard)this.getTileEntity()).inputTank.getFluid(), this.field_147003_i + 112, this.field_147009_r + 28, 39.0, 56.0);
        this.bindGuiTexture();
        GlStateManager.func_179147_l();
        this.func_73729_b(this.field_147003_i + 112, this.field_147009_r + 28, 200, 0, 39, 56);
        GlStateManager.func_179084_k();
        super.func_146976_a(par1, par2, par3);
    }

    @Nonnull
    public static TextureAtlasSprite getFlowingTexture(@Nonnull Fluid fluid) {
        ResourceLocation iconKey = fluid.getStill();
        TextureAtlasSprite textureExtry = Minecraft.func_71410_x().func_147117_R().getTextureExtry(iconKey.toString());
        return textureExtry != null ? textureExtry : RenderUtil.getStillTexture((Fluid)fluid);
    }

    public static void renderFlowingFluid(FluidStack fluid, double x, double y, double width, double height) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = GuiNiard.getFlowingTexture(fluid.getFluid());
        RenderUtil.bindBlockTexture();
        int color = fluid.getFluid().getColor(fluid);
        GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        GlStateManager.func_179147_l();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < (int)height; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min((int)height - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = (int)y + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                buffer.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                buffer.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV).func_181675_d();
                buffer.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

