/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.spawner;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.google.common.collect.Lists;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.machine.gui.GuiInventoryMachineBase;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.spawner.ContainerPoweredSpawner;
import crazypants.enderio.machines.machine.spawner.IPoweredSpawnerRemoteExec;
import crazypants.enderio.machines.machine.spawner.TilePoweredSpawner;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiPoweredSpawner
extends GuiInventoryMachineBase<TilePoweredSpawner>
implements IPoweredSpawnerRemoteExec.GUI {
    @Nonnull
    private final MultiIconButton modeB = MultiIconButton.createRightArrowButton((IGuiScreen)this, (int)8888, (int)115, (int)10);
    @Nonnull
    private final Rectangle progressTooltipRect;
    private boolean wasSpawnMode;
    @Nonnull
    private String header = "";
    @Nonnull
    private final ToggleButton showRangeB;

    public GuiPoweredSpawner(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull TilePoweredSpawner te) {
        super(te, (Container)new ContainerPoweredSpawner(par1InventoryPlayer, te), new String[]{"powered_spawner_spawn", "powered_spawner_capture"});
        this.modeB.setSize(10, 16);
        this.addProgressTooltip(80, 34, 14, 14);
        this.progressTooltipRect = ((GuiToolTip)this.progressTooltips.get(0)).getBounds();
        this.updateSpawnMode(te.isSpawnMode());
        int x = this.getXSize() - 5 - 16;
        this.showRangeB = new ToggleButton((IGuiScreen)this, -1, x, 44, (IWidgetIcon)IconEIO.SHOW_RANGE, (IWidgetIcon)IconEIO.HIDE_RANGE);
        this.showRangeB.setSize(16, 16);
        this.addToolTip(new GuiToolTip(this.showRangeB.getBounds(), new String[]{"null"}){

            @Nonnull
            public List<String> getToolTipText() {
                return Lists.newArrayList((Object[])new String[]{(GuiPoweredSpawner.this.showRangeB.isSelected() ? Lang.GUI_HIDE_RANGE : Lang.GUI_SHOW_RANGE).get()});
            }
        });
        this.addDrawingElement(new PowerBar(te, this));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.modeB.onGuiInit();
        this.showRangeB.onGuiInit();
        this.showRangeB.setSelected(((TilePoweredSpawner)this.getTileEntity()).isShowingRange());
    }

    protected void func_146284_a(@Nonnull GuiButton par1GuiButton) throws IOException {
        if (par1GuiButton == this.modeB) {
            ((TilePoweredSpawner)this.getTileEntity()).setSpawnMode(!((TilePoweredSpawner)this.getTileEntity()).isSpawnMode());
            this.doSetSpawnMode(((TilePoweredSpawner)this.getTileEntity()).isSpawnMode());
        } else if (par1GuiButton == this.showRangeB) {
            ((TilePoweredSpawner)this.getTileEntity()).setShowRange(this.showRangeB.isSelected());
        } else {
            super.func_146284_a(par1GuiButton);
        }
    }

    private void updateSpawnMode(boolean spawnMode) {
        this.wasSpawnMode = spawnMode;
        ((ContainerPoweredSpawner)this.field_147002_h).setSlotVisibility(!spawnMode);
        if (spawnMode) {
            this.getGhostSlotHandler().getGhostSlots().clear();
            this.header = Lang.GUI_SPAWNER_SPAWN.get();
            this.progressTooltipRect.x = 80;
            this.progressTooltipRect.y = 34;
            this.progressTooltipRect.width = 14;
            this.progressTooltipRect.height = 14;
        } else {
            ((ContainerPoweredSpawner)this.field_147002_h).createGhostSlots((List<GhostSlot>)this.getGhostSlotHandler().getGhostSlots());
            this.header = Lang.GUI_SPAWNER_CAPTURE.get();
            this.progressTooltipRect.x = 52;
            this.progressTooltipRect.y = 40;
            this.progressTooltipRect.width = 72;
            this.progressTooltipRect.height = 21;
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        boolean spawnMode = ((TilePoweredSpawner)this.getTileEntity()).isSpawnMode();
        if (spawnMode != this.wasSpawnMode) {
            this.updateSpawnMode(spawnMode);
        }
        this.bindGuiTexture(spawnMode ? 0 : 1);
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.shouldRenderProgress()) {
            int scaled;
            if (spawnMode) {
                scaled = this.getProgressScaled(14) + 1;
                this.func_73729_b(sx + 81, sy + 34 + 14 - scaled + 3, 176, 14 - scaled, 14, scaled);
            } else {
                scaled = this.getProgressScaled(24);
                this.func_73729_b(sx + 76, sy + 43, 176, 14, scaled + 1, 16);
            }
        }
        FontRenderer fr = this.getFontRenderer();
        int x = sx + this.field_146999_f / 2 - fr.func_78256_a(this.header) / 2;
        int y = sy + fr.field_78288_b + 6;
        fr.func_175063_a(this.header, (float)x, (float)y, ColorUtil.getRGB((Color)Color.WHITE));
        String name = TextFormatting.ITALIC + (((TilePoweredSpawner)this.getTileEntity()).getEntity() != null ? ((TilePoweredSpawner)this.getTileEntity()).getEntity().getDisplayName() : "");
        x = sx + this.field_146999_f / 2 - fr.func_78256_a(name) / 2;
        y = sy + 43 + 16 + 2;
        fr.func_175063_a(name, (float)x, (float)y, ColorUtil.getRGB((Color)Color.WHITE));
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture(spawnMode ? 0 : 1);
        super.func_146976_a(par1, par2, par3);
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    @Nonnull
    protected ResourceLocation getGuiTexture() {
        return super.getGuiTexture(((TilePoweredSpawner)this.getTileEntity()).isSpawnMode() ? 0 : 1);
    }
}

