/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.handler.ConfigurationHandler;
import subaraki.telepads.handler.CoordinateHandler;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.tileentity.TileEntityTelepad;
import subaraki.telepads.utility.TelepadEntry;

public class BlockTelepad
extends Block {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockTelepad() {
        super(Material.field_151592_s);
        this.func_149715_a(0.2f);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149663_c("telepads.telepad");
        this.setRegistryName("telepad");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTelepad();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            Item item = heldItem.func_77973_b();
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityTelepad) {
                TelepadEntry entry;
                TileEntityTelepad tet = (TileEntityTelepad)te;
                if (item.equals(Telepads.items.transmitter) && !tet.hasDimensionUpgrade() && !world.field_72995_K) {
                    tet.addDimensionUpgrade(true);
                    world.func_184138_a(pos, world.func_180495_p(pos), this.func_176223_P(), 3);
                    entry = WorldDataHandler.get(world).getEntryForLocation(pos, world.field_73011_w.getDimension());
                    entry.hasTransmitter = true;
                    WorldDataHandler.get(world).updateEntry(entry);
                    heldItem.func_190918_g(1);
                }
                if (item.equals(Telepads.items.toggler) && !world.field_72995_K && !tet.hasRedstoneUpgrade()) {
                    tet.addRedstoneUpgrade();
                    world.func_184138_a(pos, world.func_180495_p(pos), this.func_176223_P(), 3);
                    this.func_189540_a(state, world, pos, state.func_177230_c(), null);
                    heldItem.func_190918_g(1);
                }
                if (item.equals(Telepads.items.tp_mod_upgrade_public) && !world.field_72995_K) {
                    tet.toggleAcces();
                    world.func_184138_a(pos, world.func_180495_p(pos), this.func_176223_P(), 3);
                    entry = WorldDataHandler.get(world).getEntryForLocation(pos, world.field_73011_w.getDimension());
                    entry.setPublic(tet.isPublic());
                    WorldDataHandler.get(world).updateEntry(entry);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("Telepad is now " + (tet.isPublic() ? "public" : "private"), new Object[0]));
                }
                if (item.equals(Telepads.items.tp_mod_upgrade) && !world.field_72995_K) {
                    tet.rotateCoordinateHandlerIndex();
                    int index = tet.getCoordinateHandlerIndex();
                    if (index > -1) {
                        String[] tpl = ConfigurationHandler.instance.tp_locations;
                        CoordinateHandler ch = new CoordinateHandler(tpl[index]);
                        String name = ch.getName();
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("Telepad now teleports to : " + name, new Object[0]));
                        world.func_184138_a(pos, world.func_180495_p(pos), this.func_176223_P(), 3);
                        this.func_189540_a(state, world, pos, state.func_177230_c(), null);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("Telepad is now normal", new Object[0]));
                    }
                }
                if (item.equals(Items.field_151100_aR) && !world.field_72995_K) {
                    EnumDyeColor edc = EnumDyeColor.func_176766_a((int)heldItem.func_77952_i());
                    float red = edc.func_193349_f()[0];
                    float green = edc.func_193349_f()[1];
                    float blue = edc.func_193349_f()[2];
                    int color = (int)(red * 255.0f);
                    color = (color << 8) + (int)(green * 255.0f);
                    color = (color << 8) + (int)(blue * 255.0f);
                    if (tet.getColorFeet() == TileEntityTelepad.COLOR_FEET_BASE) {
                        tet.setFeetColor(color);
                    } else if (tet.getColorArrow() == TileEntityTelepad.COLOR_ARROW_BASE) {
                        tet.setArrowColor(color);
                    }
                    tet.func_70296_d();
                    world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                }
                if (item.equals(Items.field_151131_as)) {
                    boolean hasWashed = false;
                    if (tet.getColorFeet() != TileEntityTelepad.COLOR_FEET_BASE) {
                        this.wash(tet.getColorFeet(), world, pos);
                        tet.setFeetColor(TileEntityTelepad.COLOR_FEET_BASE);
                        hasWashed = true;
                    }
                    if (tet.getColorArrow() != TileEntityTelepad.COLOR_ARROW_BASE) {
                        this.wash(tet.getColorArrow(), world, pos);
                        tet.setArrowColor(TileEntityTelepad.COLOR_ARROW_BASE);
                        hasWashed = true;
                    }
                    if (!player.func_184812_l_() && hasWashed) {
                        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
                        player.func_184611_a(hand, new ItemStack(Items.field_151131_as.func_77668_q(), heldItem.func_190916_E(), heldItem.func_77960_j()));
                    }
                    return true;
                }
            }
        } else if (player.func_70093_af() && world.func_175625_s(pos) instanceof TileEntityTelepad) {
            TelepadData td = (TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null);
            TileEntityTelepad tet = (TileEntityTelepad)world.func_175625_s(pos);
            TelepadEntry lookingForEntry = null;
            for (TelepadEntry tpe : td.getEntries()) {
                if (!tpe.position.equals((Object)pos)) continue;
                lookingForEntry = tpe;
            }
            if (lookingForEntry == null) {
                TelepadEntry entry = WorldDataHandler.get(world).getEntryForLocation(pos, world.field_73011_w.getDimension());
                if (entry != null) {
                    if (entry.isPublic) {
                        if (!world.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Cannot Register Public Pads !"));
                        }
                    } else {
                        td.addEntry(entry);
                        if (!world.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Added " + entry.entryName));
                        }
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "The Telepad you try to register does not exist in the world save. Cannot add Telepad to your registry."));
                }
            } else if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + lookingForEntry.entryName + " has already been registered"));
            }
        }
        return true;
    }

    private void wash(int color, World world, BlockPos pos) {
        EnumDyeColor edc = EnumDyeColor.WHITE;
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            if (dye.func_193349_f()[0] != (float)((color & 0xFF0000) >> 16) / 255.0f || dye.func_193349_f()[1] != (float)((color & 0xFF00) >> 8) / 255.0f || dye.func_193349_f()[2] != (float)((color & 0xFF) >> 0) / 255.0f) continue;
            edc = dye;
        }
        ItemStack stack = new ItemStack(Items.field_151100_aR, 1, edc.func_176767_b());
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity te = world.func_175625_s(pos);
        TileEntityTelepad tet = null;
        if (te == null || !(te instanceof TileEntityTelepad)) {
            return;
        }
        tet = (TileEntityTelepad)te;
        if (!tet.hasRedstoneUpgrade()) {
            return;
        }
        EnumFacing[] facesThatCanPower = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.DOWN};
        boolean isPowered = false;
        for (EnumFacing face : facesThatCanPower) {
            if (!world.func_180495_p(pos.func_177972_a(face)).func_185897_m()) continue;
            int power = world.func_180495_p(pos.func_177972_a(face)).func_185893_b((IBlockAccess)world, pos, face);
            int weakPower = world.func_180495_p(pos.func_177972_a(face)).func_185911_a((IBlockAccess)world, pos, face);
            if (power <= 0 && weakPower <= 0) continue;
            isPowered = true;
            break;
        }
        tet.setPowered(isPowered);
        tet.func_70296_d();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        WorldDataHandler wdh = WorldDataHandler.get(world);
        TelepadEntry entry = wdh.getEntryForLocation(pos, world.field_73011_w.getDimension());
        entry.isPowered = isPowered;
        wdh.updateEntry(entry);
        wdh.func_76185_a();
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        TileEntityTelepad tet = null;
        if (te == null || !(te instanceof TileEntityTelepad)) {
            return;
        }
        tet = (TileEntityTelepad)te;
        if (placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            tet.setDimension(world.field_73011_w.getDimension());
            if (stack.func_77942_o()) {
                if (stack.func_77978_p().func_74764_b("colorFrame")) {
                    tet.setFeetColor(stack.func_77978_p().func_74762_e("colorFrame"));
                }
                if (stack.func_77978_p().func_74764_b("colorBase")) {
                    tet.setArrowColor(stack.func_77978_p().func_74762_e("colorBase"));
                }
            }
            te.func_70296_d();
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
            world.func_175690_a(pos, te);
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Telepads.instance, (int)1, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity te = world.func_175625_s(pos);
        TileEntityTelepad tet = null;
        if (te == null || !(te instanceof TileEntityTelepad)) {
            return false;
        }
        tet = (TileEntityTelepad)te;
        WorldDataHandler wdh = WorldDataHandler.get(world);
        TelepadEntry entry = wdh.getEntryForLocation(pos, world.field_73011_w.getDimension());
        if (entry != null && wdh.contains(entry) && !world.field_72995_K) {
            wdh.removeEntry(entry);
            this.dropPad(world, tet, pos);
            if (tet.hasDimensionUpgrade()) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(Telepads.items.transmitter, 1)));
            }
            if (tet.hasRedstoneUpgrade()) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(Telepads.items.toggler, 1)));
            }
            return world.func_175698_g(pos);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    private void dropPad(World world, TileEntityTelepad telepad, BlockPos pos) {
        EntityItem ei = new EntityItem(world);
        ei.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        ItemStack stack = new ItemStack(Telepads.blocks.blockTelepad);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("colorBase", telepad.getColorArrow());
        nbt.func_74768_a("colorFrame", telepad.getColorFeet());
        stack.func_77982_d(nbt);
        ei.func_92058_a(stack);
        world.func_72838_d((Entity)ei);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return entity instanceof EntityPlayer;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public int func_149679_a(int fortune, Random random) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityTelepad)) {
            return;
        }
        if (((TileEntityTelepad)te).isPowered()) {
            return;
        }
        int maxParticleCount = ((TileEntityTelepad)te).isStandingOnPlatform() ? 15 : 1;
        for (int particleCount = 0; particleCount < maxParticleCount; ++particleCount) {
            if (((TileEntityTelepad)te).getCoordinateHandlerIndex() > -1) {
                for (int i = -2; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        if (i > -2 && i < 2 && j == -1) {
                            j = 2;
                        }
                        if (rand.nextInt(4) != 0) continue;
                        for (int k = 0; k <= 2; ++k) {
                            BlockPos blockpos = pos.func_177982_a(i, k, j);
                            world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat() - 0.0f), (double)((float)j + rand.nextFloat()) - 0.5, new int[0]);
                        }
                    }
                }
                continue;
            }
            double posX = (float)pos.func_177958_n() + 0.5f;
            double posY = (float)pos.func_177956_o() + rand.nextFloat() * 1.5f;
            double posZ = (float)pos.func_177952_p() + 0.5f;
            double velocityX = 0.0;
            double velocityY = 0.0;
            double velocityZ = 0.0;
            int velocityXOffset = rand.nextInt(2) * 2 - 1;
            int velocityZOffset = rand.nextInt(2) * 2 - 1;
            velocityX = ((double)rand.nextFloat() - 0.5) * 0.125;
            velocityY = ((double)rand.nextFloat() - 0.5) * 0.125;
            velocityZ = ((double)rand.nextFloat() - 0.5) * 0.125;
            velocityX = rand.nextFloat() * 1.0f * (float)velocityXOffset;
            velocityZ = rand.nextFloat() * 1.0f * (float)velocityZOffset;
            world.func_175688_a(EnumParticleTypes.PORTAL, posX, posY, posZ, velocityX, velocityY, velocityZ, new int[0]);
        }
    }
}

