/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.capability;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import subaraki.telepads.handler.ConfigurationHandler;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.PacketSyncTelepadData;
import subaraki.telepads.utility.TelepadEntry;

public class TelepadData {
    private EntityPlayer player;
    private List<TelepadEntry> entries = new ArrayList<TelepadEntry>();
    private List<String> whitelist = new ArrayList<String>();
    private boolean isInTeleportGui;
    private static final int MAX_TIME = ConfigurationHandler.instance.teleport_seconds * 20;
    public int counter = MAX_TIME;

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(EntityPlayer newPlayer) {
        this.player = newPlayer;
    }

    public NBTBase writeData() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList entryList = new NBTTagList();
        if (this.entries != null && !this.entries.isEmpty()) {
            for (TelepadEntry entry : this.entries) {
                if (entry == null) continue;
                entryList.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
            }
        }
        tag.func_74782_a("entries", (NBTBase)entryList);
        NBTTagList friends = new NBTTagList();
        for (String S : this.whitelist) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("friend", S);
            friends.func_74742_a((NBTBase)nbt);
        }
        tag.func_74782_a("list", (NBTBase)friends);
        return tag;
    }

    public void readData(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        ArrayList<TelepadEntry> entryList = new ArrayList<TelepadEntry>();
        NBTTagList entryTagList = tag.func_150295_c("entries", 10);
        for (int tagPos = 0; tagPos < entryTagList.func_74745_c(); ++tagPos) {
            entryList.add(new TelepadEntry(entryTagList.func_150305_b(tagPos)));
        }
        this.entries = entryList;
        NBTTagList friendList = tag.func_150295_c("list", 10);
        for (int i = 0; i < friendList.func_74745_c(); ++i) {
            NBTTagCompound compound = friendList.func_150305_b(i);
            String s = compound.func_74779_i("friend");
            this.whitelist.add(s);
        }
    }

    public List<TelepadEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<TelepadEntry>();
        }
        return this.entries;
    }

    public void addEntry(TelepadEntry entry) {
        this.getEntries().add(entry);
        this.sync();
    }

    public void removeEntry(TelepadEntry entry) {
        for (TelepadEntry tpe : this.getEntries()) {
            if (!tpe.position.equals((Object)entry.position) || tpe.dimensionID != entry.dimensionID) continue;
            this.getEntries().remove(tpe);
            break;
        }
        this.sync();
    }

    public void removeEventualQueuedForRemovalEntries() {
        for (TelepadEntry tpe : this.getEntries()) {
            if (!tpe.entryName.equals("QUEUEDFORREMOVAL")) continue;
            this.getEntries().remove(tpe);
            break;
        }
        this.sync();
    }

    public void sync() {
        if (this.player instanceof EntityPlayerMP) {
            NetworkHandler.NETWORK.sendTo((IMessage)new PacketSyncTelepadData(this.player.func_110124_au(), this.entries, this.whitelist), (EntityPlayerMP)this.player);
        }
    }

    public void syncPoweredWithWorldData(WorldDataHandler wdh) {
        for (TelepadEntry entry : wdh.getEntries()) {
            for (TelepadEntry tpe : this.getEntries()) {
                if (!entry.position.equals((Object)tpe.position) || entry.dimensionID != tpe.dimensionID) continue;
                tpe.setPowered(entry.isPowered);
            }
        }
        this.sync();
    }

    public void syncPublicPadsToPlayer(WorldDataHandler wdh) {
        ArrayList<TelepadEntry> remove = new ArrayList<TelepadEntry>();
        for (TelepadEntry owned : this.getEntries()) {
            if (owned.isPublic && wdh.contains(owned) && !wdh.getEntryForLocation((BlockPos)owned.position, (int)owned.dimensionID).isPublic) {
                remove.add(owned);
            }
            if (!owned.isPublic || wdh.contains(owned)) continue;
            remove.add(owned);
        }
        if (!remove.isEmpty()) {
            for (TelepadEntry entry : remove) {
                this.removeEntry(entry);
            }
        }
        for (TelepadEntry entry : wdh.getEntries()) {
            if (!entry.isPublic || this.getEntries().contains(entry)) continue;
            this.addEntry((TelepadEntry)entry.clone());
        }
    }

    public boolean isInTeleportGui() {
        return this.isInTeleportGui;
    }

    public void setInTeleportGui(boolean isInTeleportGui) {
        this.isInTeleportGui = isInTeleportGui;
    }

    public void overrideEntries(List<TelepadEntry> entries) {
        this.entries = entries;
        this.sync();
    }

    public int getCounter() {
        return this.counter;
    }

    public void countDown() {
        --this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public static int getMaxTime() {
        return MAX_TIME;
    }

    public boolean addToWiteList(String player) {
        if (!this.isWhiteListFull()) {
            if (!this.whitelist.contains(player)) {
                this.whitelist.add(player);
            } else {
                return false;
            }
        }
        return true;
    }

    public void clearList() {
        this.whitelist.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commandWhitelist(String s) throws Exception {
        if (!s.startsWith("/")) return;
        String[] text = (s = s.substring(1)).split(" ");
        if (text.length == 1) {
            if (!text[0].toLowerCase().equals("clear")) throw new Exception("no such command " + text[0]);
            this.clearList();
        } else {
            if (text.length != 2) throw new Exception("too much arguments ! ");
            if (text[0].toLowerCase().equals("remove")) {
                if (this.whitelist.contains(text[1])) {
                    this.whitelist.remove(text[1]);
                }
            } else {
                if (!text[0].toLowerCase().equals("add")) throw new Exception("no such command " + text[0]);
                if (this.player.field_70170_p.func_72924_a(text[1]) != null) {
                    this.addToWiteList(text[1]);
                }
            }
        }
        this.sync();
    }

    public List<String> getWhitelist() {
        return this.whitelist;
    }

    public boolean isWhiteListFull() {
        return this.whitelist.size() >= 9;
    }
}

