/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.utility.TelepadEntry;

public class PacketSyncTelepadData
implements IMessage {
    private UUID playerUUID;
    private List<TelepadEntry> entries;
    private List<String> whiteList;

    public PacketSyncTelepadData(UUID playerUUID, List<TelepadEntry> entries, List<String> whiteList) {
        this.playerUUID = playerUUID;
        this.entries = entries;
        this.whiteList = whiteList;
    }

    public void fromBytes(ByteBuf buf) {
        ArrayList<TelepadEntry> entryList = new ArrayList<TelepadEntry>();
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        int size = buf.readInt();
        if (size <= 0) {
            return;
        }
        for (int index = 0; index < size; ++index) {
            entryList.add(new TelepadEntry(buf));
        }
        this.entries = entryList;
        size = buf.readInt();
        ArrayList<String> whiteList = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            whiteList.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        this.whiteList = whiteList;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        buf.writeInt(this.entries.size());
        for (TelepadEntry entry : this.entries) {
            entry.writeToByteBuf(buf);
        }
        buf.writeInt(this.whiteList.size());
        for (String s : this.whiteList) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
        }
    }

    public PacketSyncTelepadData() {
    }

    public static class PacketSyncTelepadEntriesHandler
    implements IMessageHandler<PacketSyncTelepadData, IMessage> {
        public IMessage onMessage(PacketSyncTelepadData packet, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayer player = Telepads.proxy.getClientPlayer();
                TelepadData td = (TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null);
                td.overrideEntries(packet.entries);
                if (packet.whiteList != null && !packet.whiteList.isEmpty()) {
                    for (String s : packet.whiteList) {
                        td.addToWiteList(s);
                    }
                }
                td.setCounter(td.getMaxTime());
                td.setInTeleportGui(false);
            });
            return null;
        }
    }
}

