/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.handler.ConfigurationHandler;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.utility.TelepadEntry;
import subaraki.telepads.utility.masa.Teleport;

public class PacketTeleport
implements IMessage {
    public TelepadEntry goTo;
    public BlockPos oldPos;
    public boolean force;

    public PacketTeleport(BlockPos playerFrom, TelepadEntry goTo, boolean forceTeleport) {
        this.oldPos = playerFrom;
        this.goTo = goTo;
        this.force = forceTeleport;
    }

    public PacketTeleport() {
    }

    public void fromBytes(ByteBuf buf) {
        this.oldPos = BlockPos.func_177969_a((long)buf.readLong());
        this.goTo = new TelepadEntry(buf);
        this.force = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.oldPos.func_177986_g());
        this.goTo.writeToByteBuf(buf);
        buf.writeBoolean(this.force);
    }

    public static class PacketTeleportHandler
    implements IMessageHandler<PacketTeleport, IMessage> {
        public IMessage onMessage(PacketTeleport packet, MessageContext ctx) {
            ((WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p).func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                WorldDataHandler wdh = WorldDataHandler.get(player.field_70170_p);
                TelepadData td = (TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null);
                td.setInTeleportGui(false);
                BlockPos goTo = packet.goTo.position.func_177984_a();
                int goToDimensionid = packet.goTo.dimensionID;
                int penalty = ConfigurationHandler.instance.expConsume;
                if (penalty > 0 && player.field_71068_ca == 0 && player.field_71106_cc * (float)player.func_71050_bK() <= (float)penalty) {
                    player.func_146105_b(new TextComponentTranslation("no.exp", new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.DARK_RED)), true);
                    return;
                }
                if (packet.goTo.dimensionID == player.field_71093_bK) {
                    if (packet.force) {
                        Teleport.teleportEntityInsideSameDimension((Entity)player, goTo);
                        PacketTeleportHandler.teleportPenalty((EntityPlayer)player);
                        return;
                    }
                    if (wdh.contains(packet.goTo)) {
                        if (!packet.goTo.isPowered) {
                            if (goToDimensionid == player.field_71093_bK) {
                                Teleport.teleportEntityInsideSameDimension((Entity)player, goTo);
                                PacketTeleportHandler.teleportPenalty((EntityPlayer)player);
                            }
                        } else {
                            player.func_146105_b(new TextComponentTranslation("no.power", new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.DARK_RED)), true);
                        }
                    } else {
                        td.setInTeleportGui(true);
                        PacketTeleportHandler.removePad((EntityPlayer)player, packet.goTo);
                    }
                } else {
                    if (packet.force) {
                        Teleport.teleportEntityToDimension((Entity)player, goTo, goToDimensionid);
                        PacketTeleportHandler.teleportPenalty((EntityPlayer)player);
                        return;
                    }
                    if (wdh.contains(packet.goTo)) {
                        if (!packet.goTo.isPowered) {
                            Teleport.teleportEntityToDimension((Entity)player, goTo, goToDimensionid);
                            PacketTeleportHandler.teleportPenalty((EntityPlayer)player);
                        } else {
                            player.func_146105_b(new TextComponentTranslation("no.power", new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.DARK_RED)), true);
                        }
                    } else {
                        PacketTeleportHandler.removePad((EntityPlayer)player, packet.goTo);
                    }
                }
            });
            return null;
        }

        private static void removePad(EntityPlayer player, TelepadEntry entry) {
            TelepadData td = (TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null);
            td.addEntry(new TelepadEntry("QUEUEDFORREMOVAL", entry.dimensionID, entry.position, false, false, false));
            td.sync();
            td.setInTeleportGui(true);
            player.openGui((Object)Telepads.instance, 2, player.field_70170_p, 0, 0, 0);
        }

        private static void teleportPenalty(EntityPlayer player) {
            int expConsuming = ConfigurationHandler.instance.expConsume;
            int lvlConsuming = ConfigurationHandler.instance.lvlConsume;
            if (expConsuming == 0 && lvlConsuming == 0) {
                return;
            }
            if (ConfigurationHandler.instance.consumeLvl) {
                player.func_82242_a(-lvlConsuming);
            } else {
                float actualExpInBar = player.field_71106_cc * (float)player.func_71050_bK();
                if (actualExpInBar < (float)expConsuming) {
                    expConsuming = (int)((float)expConsuming - actualExpInBar);
                    player.func_82242_a(-1);
                    actualExpInBar = player.func_71050_bK();
                    float total = actualExpInBar - (float)expConsuming;
                    player.field_71106_cc = 0.0f;
                    if (total < 0.0f) {
                        total = 0.0f;
                    }
                    player.func_71023_q((int)total);
                } else {
                    float total = actualExpInBar - (float)expConsuming;
                    player.field_71106_cc = 0.0f;
                    player.func_71023_q((int)total);
                }
            }
        }
    }
}

