/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.utility;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class TelepadEntry {
    public String entryName;
    public int dimensionID;
    public BlockPos position;
    public boolean isPowered;
    public boolean hasTransmitter;
    public boolean isPublic;

    public TelepadEntry(ByteBuf buf) {
        this(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readInt(), new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    public TelepadEntry(NBTTagCompound tag) {
        this(tag.func_74779_i("entryName"), tag.func_74762_e("dimensionID"), new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")), tag.func_74767_n("power"), tag.func_74767_n("transmitter"), tag.func_74767_n("public"));
    }

    public TelepadEntry(String name, int dimension, BlockPos pos, boolean isPowered, boolean hasTransmitter, boolean isPublic) {
        this.entryName = name;
        this.dimensionID = dimension;
        this.position = pos;
        this.isPowered = isPowered;
        this.hasTransmitter = hasTransmitter;
        this.isPublic = isPublic;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("entryName", this.entryName);
        tag.func_74768_a("dimensionID", this.dimensionID);
        tag.func_74757_a("power", this.isPowered);
        tag.func_74757_a("transmitter", this.hasTransmitter);
        tag.func_74757_a("public", this.isPublic);
        tag.func_74768_a("x", this.position.func_177958_n());
        tag.func_74768_a("y", this.position.func_177956_o());
        tag.func_74768_a("z", this.position.func_177952_p());
        return tag;
    }

    public void writeToByteBuf(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entryName);
        buf.writeInt(this.dimensionID);
        buf.writeInt(this.position.func_177958_n());
        buf.writeInt(this.position.func_177956_o());
        buf.writeInt(this.position.func_177952_p());
        buf.writeBoolean(this.isPowered);
        buf.writeBoolean(this.hasTransmitter);
        buf.writeBoolean(this.isPublic);
    }

    public String toString() {
        return "Entry Name: " + this.entryName + " DimensionID: " + this.dimensionID + " " + this.position.toString() + " Public Pad:" + this.isPublic;
    }

    public Object clone() {
        return new TelepadEntry(this.entryName, this.dimensionID, this.position, this.isPowered, this.hasTransmitter, this.isPublic);
    }

    public boolean equals(Object compared) {
        if (!(compared instanceof TelepadEntry)) {
            return false;
        }
        TelepadEntry entry = (TelepadEntry)compared;
        return this.entryName.equals(entry.entryName) && this.dimensionID == entry.dimensionID && this.position.equals((Object)entry.position);
    }

    public void setPowered(boolean flag) {
        this.isPowered = flag;
    }

    public void setTransmitter(boolean flag) {
        this.hasTransmitter = flag;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }
}

