/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.utility;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.end.DragonFightManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TeleportUtilityOld {
    public static void teleportEntityTo(Entity entity, BlockPos pos, float yaw, float pitch) {
        TeleportUtilityOld.teleportEntityTo(entity, new Vec3d((Vec3i)pos), yaw, pitch);
    }

    private static void teleportEntityTo(Entity entity, Vec3d pos, float yaw, float pitch) {
        pos = TeleportUtilityOld.getClampedDestinationPosition(pos, entity.func_130014_f_());
        entity.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, yaw, pitch);
        entity.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    private static Vec3d getClampedDestinationPosition(Vec3d posIn, World worldDst) {
        WorldBorder border = worldDst.func_175723_af();
        double x = MathHelper.func_151237_a((double)posIn.field_72450_a, (double)(border.func_177726_b() + 2.0), (double)(border.func_177728_d() - 2.0));
        double y = MathHelper.func_151237_a((double)posIn.field_72448_b, (double)-4096.0, (double)4096.0);
        double z = MathHelper.func_151237_a((double)posIn.field_72449_c, (double)(border.func_177736_c() + 2.0), (double)(border.func_177733_e() - 2.0));
        return new Vec3d(x, y, z);
    }

    public static Entity changeToDimension(Entity entity, BlockPos destination, int dimension, MinecraftServer server) {
        WorldServer worldDst = server.func_71218_a(dimension);
        if (worldDst == null) {
            return entity;
        }
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        float yaw = entity.field_70177_z;
        float pitch = entity.field_70125_A;
        x = destination.func_177958_n();
        y = destination.func_177956_o();
        z = destination.func_177952_p();
        Vec3d pos = TeleportUtilityOld.getClampedDestinationPosition(new Vec3d(x, y, z), (World)worldDst);
        x = pos.field_72450_a;
        y = pos.field_72448_b;
        z = pos.field_72449_c;
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            World worldOld = player.func_130014_f_();
            entity.func_70012_b(x, y, z, yaw, pitch);
            server.func_184103_al().transferPlayerToDimension(player, dimension, (Teleporter)new DummyTeleporter(worldDst));
            player.func_70634_a(x, y, z);
            if (worldOld.field_73011_w instanceof WorldProviderEnd) {
                player.func_70634_a(x, y, z);
                worldDst.func_72838_d((Entity)player);
                worldDst.func_72866_a((Entity)player, false);
                TeleportUtilityOld.removeDragonBossBarHack(player, (WorldServer)worldOld);
            }
        }
        return entity;
    }

    private static void removeDragonBossBarHack(EntityPlayerMP player, WorldServer worldSrc) {
        DragonFightManager manager;
        if (worldSrc.field_73011_w instanceof WorldProviderEnd && (manager = ((WorldProviderEnd)worldSrc.field_73011_w).func_186063_s()) != null) {
            try {
                BossInfoServer bossInfo = (BossInfoServer)ReflectionHelper.getPrivateValue(DragonFightManager.class, (Object)manager, (String[])new String[]{"field_186109_c", "bossInfo"});
                if (bossInfo != null) {
                    bossInfo.func_186761_b(player);
                }
            }
            catch (ReflectionHelper.UnableToAccessFieldException e) {
                player.func_145747_a((ITextComponent)new TextComponentString("Failed to get DragonFightManager#bossInfo"));
            }
        }
    }

    private static class DummyTeleporter
    extends Teleporter {
        public DummyTeleporter(WorldServer worldIn) {
            super(worldIn);
        }

        public boolean func_85188_a(Entity entityIn) {
            return true;
        }

        public boolean func_180620_b(Entity entityIn, float rotationYaw) {
            return true;
        }

        public void func_180266_a(Entity entityIn, float rotationYaw) {
        }
    }
}

