/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bittank;

import javax.annotation.Nonnull;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityBitTank
extends TileEntity
implements IItemHandler,
IFluidHandler {
    public static final int MAX_CONTENTS = 4096;
    public static final int MB_PER_BIT_CONVERSION = 125;
    public static final int BITS_PER_MB_CONVERSION = 512;
    private Fluid myFluid = null;
    private int bits = 0;
    private int oldLV = -1;

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.deserializeFromNBT(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound t = new NBTTagCompound();
        this.serializeToNBT(t);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, t);
    }

    public void deserializeFromNBT(NBTTagCompound compound) {
        String fluid = compound.func_74779_i("fluid");
        this.myFluid = fluid == null || fluid.equals("") ? null : FluidRegistry.getFluid((String)fluid);
        this.bits = compound.func_74762_e("bits");
    }

    public void serializeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("fluid", this.myFluid == null ? "" : this.myFluid.getName());
        compound.func_74768_a("bits", this.bits);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.deserializeFromNBT(compound);
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.serializeToNBT(compound);
        super.func_189515_b(compound);
        return compound;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.bits > 0 && slot == 0) {
            return this.getFluidBitStack(this.myFluid, this.bits);
        }
        return ModUtil.getEmptyStack();
    }

    @Nonnull
    public ItemStack getFluidBitStack(Fluid liquid, int amount) {
        if (liquid == null || liquid.getBlock() == null) {
            return ModUtil.getEmptyStack();
        }
        return ItemChiseledBit.createStack(ModUtil.getStateId(liquid.getBlock().func_176223_P()), amount, false);
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!ModUtil.isEmpty(stack) && stack.func_77973_b() instanceof ItemChiseledBit) {
            boolean canInsert;
            int state = ItemChiseledBit.getStackState(stack);
            IBlockState blk = ModUtil.getStateById(state);
            Fluid f = null;
            for (Fluid fl : FluidRegistry.getRegisteredFluids().values()) {
                if (fl.getBlock() != blk.func_177230_c()) continue;
                f = fl;
                break;
            }
            if (f == null) {
                return stack;
            }
            ItemStack bitItem = this.getFluidBitStack(this.myFluid, this.bits);
            boolean bl = canInsert = ModUtil.isEmpty(bitItem) || ItemStack.func_77970_a((ItemStack)bitItem, (ItemStack)stack) && bitItem.func_77973_b() == stack.func_77973_b();
            if (canInsert) {
                int merged = this.bits + ModUtil.getStackSize(stack);
                int amount = Math.min(merged, 4096);
                if (!simulate) {
                    Fluid oldFluid = this.myFluid;
                    int oldBits = this.bits;
                    this.myFluid = f;
                    this.bits = amount;
                    if (this.bits != oldBits || this.myFluid != oldFluid) {
                        this.saveAndUpdate();
                    }
                }
                if (amount < merged) {
                    ItemStack out = ModUtil.copy(stack);
                    ModUtil.setStackSize(out, merged - amount);
                    return out;
                }
                return ModUtil.getEmptyStack();
            }
        }
        return stack;
    }

    private void saveAndUpdate() {
        this.func_70296_d();
        ModUtil.sendUpdate(this.field_145850_b, this.func_174877_v());
        int lv = this.getLightValue();
        if (this.oldLV != lv) {
            this.func_145831_w().func_175664_x(this.func_174877_v());
            this.oldLV = lv;
        }
    }

    @Nonnull
    public ItemStack extractBits(int slot, int amount, boolean simulate) {
        ItemStack contents = this.getStackInSlot(slot);
        if (contents != null && amount > 0) {
            ModUtil.setStackSize(contents, Math.min(amount, ModUtil.getStackSize(contents)));
            if (!simulate) {
                int oldBits = this.bits;
                this.bits -= ModUtil.getStackSize(contents);
                if (this.bits == 0) {
                    this.myFluid = null;
                }
                if (this.bits != oldBits) {
                    this.saveAndUpdate();
                }
            }
            return contents;
        }
        return ModUtil.getEmptyStack();
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractBits(slot, Math.min(amount, ChiselsAndBits.getItems().itemBlockBit.func_77639_j()), simulate);
    }

    public FluidStack getAccessableFluid() {
        int mb = (this.bits - this.bits % 512) / 512;
        if ((mb *= 125) > 0 && this.myFluid != null) {
            return new FluidStack(this.myFluid, mb);
        }
        return null;
    }

    public boolean hasFastRenderer() {
        return false;
    }

    FluidStack getBitsAsFluidStack() {
        if (this.bits > 0 && this.myFluid != null) {
            return new FluidStack(this.myFluid, this.bits);
        }
        return null;
    }

    public int getLightValue() {
        if (this.myFluid == null || this.myFluid.getBlock() == null) {
            return 0;
        }
        int lv = DeprecationHelper.getLightValue(this.myFluid.getBlock().func_176223_P());
        return lv;
    }

    boolean extractBits(EntityPlayer playerIn, float hitX, float hitY, float hitZ, BlockPos pos) {
        if (!playerIn.func_70093_af()) {
            ItemStack is = this.extractItem(0, 64, false);
            if (is != null) {
                ChiselsAndBits.getApi().giveBitToPlayer(playerIn, is, new Vec3d((double)hitX + (double)pos.func_177958_n(), (double)hitY + (double)pos.func_177956_o(), (double)hitZ + (double)pos.func_177952_p()));
            }
            return true;
        }
        return false;
    }

    boolean addAllPossibleBits(EntityPlayer playerIn) {
        if (playerIn.func_70093_af()) {
            boolean change = false;
            for (int x = 0; x < playerIn.field_71071_by.func_70302_i_(); ++x) {
                IBitBag bag;
                ItemStack stackInSlot = ModUtil.nonNull(playerIn.field_71071_by.func_70301_a(x));
                if (ChiselsAndBits.getApi().getItemType(stackInSlot) == ItemType.CHISLED_BIT) {
                    playerIn.field_71071_by.func_70299_a(x, this.insertItem(0, stackInSlot, false));
                    change = true;
                }
                if (ChiselsAndBits.getApi().getItemType(stackInSlot) != ItemType.BIT_BAG || (bag = ChiselsAndBits.getApi().getBitbag(stackInSlot)) == null) continue;
                for (int y = 0; y < bag.getSlots(); ++y) {
                    bag.insertItem(y, this.insertItem(0, bag.extractItem(y, bag.getSlotLimit(y), false), false), false);
                    change = true;
                }
            }
            if (change) {
                playerIn.field_71071_by.func_70296_d();
            }
            return change;
        }
        return false;
    }

    boolean addHeldBits(@Nonnull ItemStack current, EntityPlayer playerIn) {
        if (playerIn.func_70093_af() && ChiselsAndBits.getApi().getItemType(current) == ItemType.CHISLED_BIT) {
            playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, this.insertItem(0, current, false));
            playerIn.field_71071_by.func_70296_d();
            return true;
        }
        return false;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getAccessableFluid(), 1000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        int possibleAmount = resource.amount - resource.amount % 125;
        if (possibleAmount > 0) {
            int bitCount = possibleAmount * 512 / 125;
            ItemStack bitItems = this.getFluidBitStack(resource.getFluid(), bitCount);
            ItemStack leftOver = this.insertItem(0, bitItems, !doFill);
            if (ModUtil.isEmpty(leftOver)) {
                return possibleAmount;
            }
            int mbUsedUp = ModUtil.getStackSize(leftOver);
            mbUsedUp *= 125;
            mbUsedUp += 511;
            return resource.amount - (mbUsedUp /= 512);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        int aboutHowMuch;
        int mbThatCanBeRemoved;
        if (resource == null) {
            return null;
        }
        FluidStack a = this.getAccessableFluid();
        if (a != null && resource.containsFluid(a) && (mbThatCanBeRemoved = Math.min(a.amount, (aboutHowMuch = resource.amount) - aboutHowMuch % 125)) > 0) {
            a.amount = mbThatCanBeRemoved;
            if (doDrain) {
                int bitCount = mbThatCanBeRemoved * 512 / 125;
                this.extractBits(0, bitCount, false);
            }
            return a;
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack a = this.getAccessableFluid();
        int mbThatCanBeRemoved = Math.min(a == null ? 0 : a.amount, maxDrain - maxDrain % 125);
        if (mbThatCanBeRemoved > 0 && a != null) {
            a.amount = mbThatCanBeRemoved;
            if (doDrain) {
                int bitCount = mbThatCanBeRemoved * 512 / 125;
                this.extractBits(0, bitCount, false);
            }
            return a;
        }
        return null;
    }

    public int getSlotLimit(int slot) {
        return 512;
    }
}

