/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.charset.api.CharsetAPI;
import pl.asie.charset.lib.CharsetIMC;
import pl.asie.charset.lib.CharsetImplAPI;
import pl.asie.charset.lib.CreativeTabCharset;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.inventory.GuiHandlerCharset;
import pl.asie.charset.lib.loader.ModuleLoader;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.misc.FixCharsetUnifyModId;
import pl.asie.charset.lib.misc.IconCharset;
import pl.asie.charset.lib.utils.RegistryUtils;

@Mod(modid="charset", name="Charset", version="0.5.6.3", updateJSON="http://charset.asie.pl/update.json", dependencies="after:forge@[14.23.5.2838,);before:jei@[4.7.8,);before:betterwithmods;before:mcmultipart", guiFactory="pl.asie.charset.lib.config.ConfigGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class ModCharset {
    public static final String UPDATE_URL = "http://charset.asie.pl/update.json";
    public static final String MODID = "charset";
    public static final String NAME = "Charset";
    public static final String VERSION = "0.5.6.3";
    public static final String DEP_LIB = "after:forge@[14.23.5.2838,);before:jei@[4.7.8,);before:betterwithmods;before:mcmultipart";
    public static final int DATA_FIXER_VER = 5;
    public static final boolean INDEV = "@version@".equals("0.5.6.3".toLowerCase(Locale.ROOT));
    @Mod.Instance(value="charset")
    public static ModCharset instance;
    private static Item charsetIconItem;
    private static ItemStack charsetIconStack;
    public static ModuleProfile profile;
    public static final CreativeTabs CREATIVE_TAB;
    public static Logger logger;
    public static Configuration configModules;
    public static Configuration configIds;
    public static Configuration configGeneral;
    public static Map<String, String> defaultOptions;
    private static File configurationDirectory;
    public static ModFixs dataFixes;
    private static final Set<String> oldPrefixes;

    public static File getConfigDir() {
        return configurationDirectory;
    }

    public static File getConfigFile(String filename) {
        return new File(configurationDirectory, filename);
    }

    public static File getModuleConfigFile(String id) {
        return new File(new File(configurationDirectory, "module"), id + ".cfg");
    }

    public ModCharset() {
        CharsetAPI.INSTANCE = new CharsetImplAPI();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        try {
            InputStream stream = this.getClass().getResourceAsStream("assets/charset/default.options");
            if (stream != null) {
                for (String s : IOUtils.toString((InputStream)stream, (Charset)Charsets.UTF_8).split("\n")) {
                    String[] parts = s.split("=", 2);
                    parts[0] = parts[0].trim();
                    parts[1] = parts[1].trim();
                    defaultOptions.put(parts[0].toLowerCase(Locale.ROOT), parts[1].toLowerCase(Locale.ROOT));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        configurationDirectory = new File(event.getModConfigurationDirectory(), MODID);
        if (!configurationDirectory.exists()) {
            configurationDirectory.mkdir();
        }
        configModules = new Configuration(ModCharset.getConfigFile("modules.cfg"));
        configIds = new Configuration(ModCharset.getConfigFile("ids.cfg"));
        configGeneral = new Configuration(ModCharset.getConfigFile("charset.cfg"));
        RegistryUtils.loadConfigIds(configIds);
        logger = LogManager.getLogger();
        ModuleLoader.INSTANCE.preInit(event.getAsmData());
        dataFixes = FMLCommonHandler.instance().getDataFixer().init(MODID, 5);
        dataFixes.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new FixCharsetUnifyModId.Entity(oldPrefixes));
        charsetIconItem = new IconCharset();
        charsetIconStack = new ItemStack(charsetIconItem);
        ModuleLoader.INSTANCE.passEventWithProgress((FMLEvent)event);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel(charsetIconItem, 0, "charset:icon");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register(event.getRegistry(), charsetIconItem, "icon");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)GuiHandlerCharset.INSTANCE);
        ModuleLoader.INSTANCE.init();
        ModuleLoader.INSTANCE.passEventWithProgress((FMLEvent)event);
        if (configIds.hasChanged()) {
            configIds.save();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModuleLoader.INSTANCE.postInit();
        ModuleLoader.INSTANCE.passEventWithProgress((FMLEvent)event);
    }

    @Mod.EventHandler
    public void passThrough(FMLServerAboutToStartEvent event) {
        ModuleLoader.INSTANCE.passEvent((FMLEvent)event);
    }

    @Mod.EventHandler
    public void passThrough(FMLServerStartingEvent event) {
        ModuleLoader.INSTANCE.passEvent((FMLEvent)event);
    }

    @Mod.EventHandler
    public void passThrough(FMLServerStartedEvent event) {
        ModuleLoader.INSTANCE.passEvent((FMLEvent)event);
        CharsetIMC.INSTANCE.freezeRegistries();
    }

    @Mod.EventHandler
    public void passThrough(FMLServerStoppingEvent event) {
        CharsetIMC.INSTANCE.unfreezeRegistries();
        ModuleLoader.INSTANCE.passEvent((FMLEvent)event);
    }

    @Mod.EventHandler
    public void passThrough(FMLServerStoppedEvent event) {
        ModuleLoader.INSTANCE.passEvent((FMLEvent)event);
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            CharsetIMC.INSTANCE.receiveMessage(message);
        }
    }

    @SubscribeEvent
    public void onMissingMappingsBlock(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!oldPrefixes.contains(mapping.key.func_110624_b())) continue;
            ResourceLocation newName = new ResourceLocation(MODID, mapping.key.func_110623_a());
            Block b = Block.func_149684_b((String)newName.toString());
            if (b != null && b != Blocks.field_150350_a) {
                mapping.remap((IForgeRegistryEntry)b);
                continue;
            }
            mapping.warn();
        }
    }

    @SubscribeEvent
    public void onMissingMappingsItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (mapping.key.toString().equals("charset:wire")) {
                mapping.ignore();
                continue;
            }
            if (!oldPrefixes.contains(mapping.key.func_110624_b())) continue;
            ResourceLocation newName = new ResourceLocation(MODID, mapping.key.func_110623_a());
            Item i = Item.func_111206_d((String)newName.toString());
            if (i != null && i != Items.field_190931_a) {
                mapping.remap((IForgeRegistryEntry)i);
                continue;
            }
            mapping.warn();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (MODID.equals(event.getModID())) {
            if (configGeneral.hasChanged()) {
                configGeneral.save();
            }
            if (configIds.hasChanged()) {
                configIds.save();
            }
            if (configModules.hasChanged()) {
                configModules.save();
            }
            for (Configuration c : ModuleLoader.moduleConfigs.values()) {
                if (!c.hasChanged()) continue;
                c.save();
            }
            ModuleLoader.INSTANCE.passEvent(new CharsetLoadConfigEvent(false));
        }
    }

    public static boolean isModuleLoaded(String s) {
        return ModuleLoader.INSTANCE.getLoadedModules().contains(s);
    }

    static {
        CREATIVE_TAB = new CreativeTabCharset(MODID){

            public ItemStack func_78016_d() {
                return charsetIconStack;
            }
        };
        defaultOptions = new HashMap<String, String>();
        oldPrefixes = ImmutableSet.of((Object)"charsetlib", (Object)"charsetpipes", (Object)"charsetstorage", (Object)"charsetdecoration", (Object)"charsetdrama", (Object)"charsetcarts", (Object[])new String[]{"charsettweaks", "charsetaudio", "charsetcrafting", "charsetwrench"});
    }
}

