/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.lib.misc.IModelConnectable;
import pl.asie.charset.lib.render.CharsetFaceBakery;
import pl.asie.charset.lib.render.model.BaseBakedModel;
import pl.asie.charset.lib.render.model.ModelFactory;

public abstract class ModelPipeShaped<T extends IModelConnectable>
extends BaseBakedModel {
    private static final boolean RENDER_INNER_FACES = true;
    private static final boolean RENDER_OUTER_FACES = true;
    private static final EnumFacing[][] CONNECTION_DIRS = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}};
    private static final ModelRotation[] ROTATIONS = new ModelRotation[]{ModelRotation.X0_Y0, ModelRotation.X180_Y0, ModelRotation.X270_Y0, ModelRotation.X270_Y180, ModelRotation.X270_Y270, ModelRotation.X270_Y90};
    private final List<BakedQuad>[] lists = new List[257];
    private final IUnlistedProperty<T> property;
    private final Block block;

    public ModelPipeShaped(IUnlistedProperty<T> property, Block block) {
        this.property = property;
        this.block = block;
        this.addDefaultBlockTransforms();
    }

    private List<BakedQuad> getPipeQuads(int i, BlockRenderLayer layer) {
        if (layer == null) {
            if (ModelFactory.DISABLE_CACHE || this.lists[256] == null) {
                boolean[] connections = new boolean[6];
                this.lists[256] = new ArrayList<BakedQuad>();
                for (BlockRenderLayer layer1 : BlockRenderLayer.values()) {
                    if (!this.block.canRenderInLayer(this.block.func_176223_P(), layer1)) continue;
                    this.lists[256].addAll(this.generateQuads(connections, layer1));
                }
            }
            return this.lists[256];
        }
        if (ModelFactory.DISABLE_CACHE || this.lists[i += 64 * layer.ordinal()] == null) {
            if (this.block.canRenderInLayer(this.block.func_176223_P(), layer)) {
                boolean[] connections = new boolean[6];
                for (int j = 0; j < 6; ++j) {
                    if ((i & 1 << j) == 0) continue;
                    connections[5 - j] = true;
                }
                this.lists[i] = ImmutableList.copyOf(this.generateQuads(connections, layer));
            } else {
                this.lists[i] = ImmutableList.of();
            }
        }
        return this.lists[i];
    }

    public int getOutsideColor(EnumFacing facing, BlockRenderLayer layer) {
        return -1;
    }

    public int getInsideColor(EnumFacing facing, BlockRenderLayer layer) {
        return -1;
    }

    public boolean shouldRender(T target, BlockRenderLayer layer) {
        return true;
    }

    public abstract float getThickness(BlockRenderLayer var1);

    public abstract boolean isOpaque();

    public abstract TextureAtlasSprite getTexture(EnumFacing var1, BlockRenderLayer var2, int var3);

    protected List<BakedQuad> generateQuads(boolean[] connections, BlockRenderLayer layer) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Vector3f to;
            Vector3f from;
            EnumFacing[] neighbors = CONNECTION_DIRS[facing.ordinal()];
            int connectionMatrix = (connections[neighbors[0].ordinal()] ? 8 : 0) | (connections[neighbors[1].ordinal()] ? 4 : 0) | (connections[neighbors[2].ordinal()] ? 2 : 0) | (connections[neighbors[3].ordinal()] ? 1 : 0);
            TextureAtlasSprite sprite = this.getTexture(facing, layer, connectionMatrix);
            float min = 8.0f - this.getThickness(layer) / 2.0f;
            float max = 8.0f + this.getThickness(layer) / 2.0f;
            int outsideColor = this.getOutsideColor(facing, layer);
            int insideColor = this.getInsideColor(facing, layer);
            if (!this.isOpaque() && connections[facing.ordinal()]) {
                if (connections[neighbors[2].ordinal()]) {
                    from = new Vector3f(0.0f, min, min);
                    to = new Vector3f(min, min, max);
                    quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, outsideColor, sprite, EnumFacing.DOWN, (ITransformation)ROTATIONS[facing.ordinal()], true));
                    quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, insideColor, sprite, EnumFacing.UP, (ITransformation)ROTATIONS[facing.ordinal()], true));
                }
                if (connections[neighbors[0].ordinal()]) {
                    from = new Vector3f(min, min, 0.0f);
                    to = new Vector3f(max, min, min);
                    quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, outsideColor, sprite, EnumFacing.DOWN, (ITransformation)ROTATIONS[facing.ordinal()], true));
                    quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, insideColor, sprite, EnumFacing.UP, (ITransformation)ROTATIONS[facing.ordinal()], true));
                }
                if (connections[neighbors[3].ordinal()]) {
                    from = new Vector3f(max, min, min);
                    to = new Vector3f(16.0f, min, max);
                    quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, outsideColor, sprite, EnumFacing.DOWN, (ITransformation)ROTATIONS[facing.ordinal()], true));
                    quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, insideColor, sprite, EnumFacing.UP, (ITransformation)ROTATIONS[facing.ordinal()], true));
                }
                if (!connections[neighbors[1].ordinal()]) continue;
                from = new Vector3f(min, min, max);
                to = new Vector3f(max, min, 16.0f);
                quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, outsideColor, sprite, EnumFacing.DOWN, (ITransformation)ROTATIONS[facing.ordinal()], true));
                quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, insideColor, sprite, EnumFacing.UP, (ITransformation)ROTATIONS[facing.ordinal()], true));
                continue;
            }
            from = new Vector3f(connections[neighbors[2].ordinal()] ? 0.0f : min, min, connections[neighbors[0].ordinal()] ? 0.0f : min);
            to = new Vector3f(connections[neighbors[3].ordinal()] ? 16.0f : max, min, connections[neighbors[1].ordinal()] ? 16.0f : max);
            quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, outsideColor, sprite, EnumFacing.DOWN, (ITransformation)ROTATIONS[facing.ordinal()], true));
            if (this.isOpaque()) continue;
            quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, insideColor, sprite, EnumFacing.UP, (ITransformation)ROTATIONS[facing.ordinal()], true));
        }
        return quads;
    }

    protected boolean connects(T target, BlockRenderLayer layer, EnumFacing facing) {
        return target.connects(facing);
    }

    public List<BakedQuad> getQuads(T target) {
        if (!this.shouldRender(target, MinecraftForgeClient.getRenderLayer())) {
            return Collections.emptyList();
        }
        if (target == null) {
            return this.getPipeQuads(0, MinecraftForgeClient.getRenderLayer());
        }
        int pointer = 0;
        for (EnumFacing f : EnumFacing.field_82609_l) {
            pointer = pointer << 1 | (this.connects(target, MinecraftForgeClient.getRenderLayer(), f) ? 1 : 0);
        }
        return this.getPipeQuads(pointer, MinecraftForgeClient.getRenderLayer());
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return Collections.emptyList();
        }
        IModelConnectable target = null;
        if (state instanceof IExtendedBlockState) {
            target = (IModelConnectable)((IExtendedBlockState)state).getValue(this.property);
        }
        return this.getQuads(target);
    }
}

