/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.resources;

import com.google.gson.Gson;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.IOUtils;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.resources.ColorPaletteUpdateEvent;

public final class ColorPaletteParser {
    public static final ColorPaletteParser INSTANCE = new ColorPaletteParser();
    private final Gson gson = new Gson();
    private final ResourceLocation COLOR_PALETTE_LOC = new ResourceLocation("charset", "color_palette.json");
    private Data data;

    private ColorPaletteParser() {
    }

    public boolean hasColor(String namespace, String color) {
        return this.data.palettes.containsKey(namespace) && this.data.palettes.get(namespace).containsKey(color);
    }

    public double[] getColor(String namespace, String color) {
        if (this.hasColor(namespace, color)) {
            return this.data.palettes.get(namespace).get(color);
        }
        return new double[]{0.0, 0.0, 0.0, 0.0};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        this.data = null;
        try {
            for (IResource resource : Minecraft.func_71410_x().func_110442_L().func_135056_b(this.COLOR_PALETTE_LOC)) {
                Data data;
                String resourcePackName = resource.func_177240_d();
                try (InputStream stream = resource.func_110527_b();
                     InputStreamReader reader = new InputStreamReader(stream);){
                    data = (Data)this.gson.fromJson((Reader)reader, Data.class);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)resource);
                }
                if (data == null) {
                    ModCharset.logger.warn("Could not parse color_palette.json found in " + resourcePackName + " - not loaded.");
                    continue;
                }
                if (data.version != 1) {
                    ModCharset.logger.warn("Unsupported version of color_palette.json found in " + resourcePackName + " - not loaded.");
                    continue;
                }
                if (this.data == null) {
                    this.data = data;
                    continue;
                }
                this.data.add(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MinecraftForge.EVENT_BUS.post((Event)new ColorPaletteUpdateEvent(this));
    }

    private static class Data {
        public int version;
        public Map<String, Map<String, double[]>> palettes;

        private Data() {
        }

        public void add(Data other) {
            for (String s : other.palettes.keySet()) {
                if (!this.palettes.containsKey(s)) {
                    this.palettes.put(s, other.palettes.get(s));
                    continue;
                }
                Map<String, double[]> parent = this.palettes.get(s);
                for (Map.Entry<String, double[]> entry : other.palettes.get(s).entrySet()) {
                    parent.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

