/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.block.ProgramCompilerGui;
import logisticspipes.network.packets.block.CompilerStatusPacket;
import logisticspipes.pipes.PipeItemsBasicLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.SimpleStackInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class LogisticsProgramCompilerTileEntity
extends LogisticsSolidTileEntity
implements IGuiTileEntity,
IGuiOpenControler {
    public static final Map<ResourceLocation, Set<ResourceLocation>> programByCategory = new LinkedHashMap<ResourceLocation, Set<ResourceLocation>>();
    private final PlayerCollectionList playerList = new PlayerCollectionList();
    private String taskType = "";
    private ResourceLocation currentTask = null;
    private double taskProgress = 0.0;
    private boolean wasAbleToConsumePower = false;
    private SimpleStackInventory inventory = new SimpleStackInventory(2, "programcompilerinv", 64);

    @Override
    public CoordinatesGuiProvider getGuiProvider() {
        return NewGuiHandler.getGui(ProgramCompilerGui.class);
    }

    public NBTTagList getNBTTagListForKey(String key) {
        NBTTagCompound nbt = this.getInventory().func_70301_a(0).func_77978_p();
        if (nbt == null) {
            this.getInventory().func_70301_a(0).func_77982_d(new NBTTagCompound());
            nbt = this.getInventory().func_70301_a(0).func_77978_p();
        }
        if (!nbt.func_74764_b(key)) {
            NBTTagList list = new NBTTagList();
            nbt.func_74782_a(key, (NBTBase)list);
        }
        return nbt.func_150295_c(key, 8);
    }

    public void triggerNewTask(ResourceLocation category, String taskType) {
        if (this.currentTask != null) {
            return;
        }
        this.taskType = taskType;
        this.currentTask = category;
        this.taskProgress = 0.0;
        this.wasAbleToConsumePower = true;
        this.updateClient();
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.playerList.add(player);
        MainProxy.sendPacketToPlayer(this.getClientUpdatePacket(), player);
    }

    private CoordinatesPacket getClientUpdatePacket() {
        return PacketHandler.getPacket(CompilerStatusPacket.class).setCategory(this.currentTask).setProgress(this.taskProgress).setWasAbleToConsumePower(this.wasAbleToConsumePower).setDisk(this.getInventory().func_70301_a(0)).setProgrammer(this.getInventory().func_70301_a(1)).setTilePos(this);
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.playerList.remove(player);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (MainProxy.isServer((IBlockAccess)this.field_145850_b) && this.currentTask != null) {
            this.wasAbleToConsumePower = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                CoreRoutedPipe pipe;
                DoubleCoordinates pos;
                TileEntity tile;
                if (dir == EnumFacing.UP || !((tile = (pos = CoordinateUtils.add(new DoubleCoordinates(this), dir)).getTileEntity((IBlockAccess)this.func_145831_w())) instanceof LogisticsTileGenericPipe)) continue;
                LogisticsTileGenericPipe tPipe = (LogisticsTileGenericPipe)tile;
                if (tPipe.pipe.getClass() != PipeItemsBasicLogistics.class || !(pipe = (CoreRoutedPipe)tPipe.pipe).useEnergy(10)) continue;
                this.taskProgress = this.taskType.equals("category") ? (this.taskProgress += 5.0E-4) : (this.taskType.equals("program") ? (this.taskProgress += 0.0025) : (this.taskType.equals("flash") ? (this.taskProgress += 0.01) : (this.taskProgress += 1.0)));
                this.wasAbleToConsumePower = true;
            }
            if (this.taskProgress >= 1.0) {
                NBTTagList list;
                if (this.taskType.equals("category")) {
                    list = this.getNBTTagListForKey("compilerCategories");
                    list.func_74742_a((NBTBase)new NBTTagString(this.currentTask.toString()));
                } else if (this.taskType.equals("program")) {
                    list = this.getNBTTagListForKey("compilerPrograms");
                    list.func_74742_a((NBTBase)new NBTTagString(this.currentTask.toString()));
                } else if (this.taskType.equals("flash")) {
                    if (!this.getInventory().func_70301_a(1).func_190926_b()) {
                        ItemStack programmer = this.getInventory().func_70301_a(1);
                        if (!programmer.func_77942_o()) {
                            programmer.func_77982_d(new NBTTagCompound());
                        }
                        programmer.func_77978_p().func_74778_a("LogisticsRecipeTarget", this.currentTask.toString());
                    }
                } else {
                    throw new UnsupportedOperationException(this.taskType);
                }
                this.taskType = "";
                this.currentTask = null;
                this.taskProgress = 0.0;
                this.wasAbleToConsumePower = false;
            }
            this.updateClient();
        }
    }

    public void updateClient() {
        MainProxy.sendToPlayerList((ModernPacket)this.getClientUpdatePacket(), this.playerList);
    }

    @Override
    public void onBlockBreak() {
        this.inventory.dropContents(this.field_145850_b, this.func_174877_v());
    }

    public void setStateOnClient(CompilerStatusPacket compilerStatusPacket) {
        this.getInventory().func_70299_a(0, compilerStatusPacket.getDisk());
        this.getInventory().func_70299_a(1, compilerStatusPacket.getProgrammer());
        this.currentTask = compilerStatusPacket.getCategory();
        this.taskProgress = compilerStatusPacket.getProgress();
        this.wasAbleToConsumePower = compilerStatusPacket.isWasAbleToConsumePower();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.inventory.readFromNBT(nbt, "programcompilerinv");
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.inventory.writeToNBT(nbt, "programcompilerinv");
        return super.func_189515_b(nbt);
    }

    public ResourceLocation getCurrentTask() {
        return this.currentTask;
    }

    public double getTaskProgress() {
        return this.taskProgress;
    }

    public boolean isWasAbleToConsumePower() {
        return this.wasAbleToConsumePower;
    }

    public SimpleStackInventory getInventory() {
        return this.inventory;
    }

    public static class ProgrammCategories {
        public static final ResourceLocation BASIC = new ResourceLocation("logisticspipes", "compilercategory.basic");
        public static final ResourceLocation TIER_2 = new ResourceLocation("logisticspipes", "compilercategory.tier_2");
        public static final ResourceLocation FLUID = new ResourceLocation("logisticspipes", "compilercategory.fluid");
        public static final ResourceLocation TIER_3 = new ResourceLocation("logisticspipes", "compilercategory.tier_3");
        public static final ResourceLocation CHASSIS = new ResourceLocation("logisticspipes", "compilercategory.chassis");
        public static final ResourceLocation CHASSIS_2 = new ResourceLocation("logisticspipes", "compilercategory.chassis_2");
        public static final ResourceLocation CHASSIS_3 = new ResourceLocation("logisticspipes", "compilercategory.chassis_3");
        public static final ResourceLocation MODDED = new ResourceLocation("logisticspipes", "compilercategory.modded");

        static {
            programByCategory.put(BASIC, new HashSet());
            programByCategory.put(TIER_2, new HashSet());
            programByCategory.put(FLUID, new HashSet());
            programByCategory.put(TIER_3, new HashSet());
            programByCategory.put(CHASSIS, new HashSet());
            programByCategory.put(CHASSIS_2, new HashSet());
            programByCategory.put(CHASSIS_3, new HashSet());
            programByCategory.put(MODDED, new HashSet());
        }
    }
}

