/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.powertile;

import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.gui.hud.HUDPowerLevel;
import logisticspipes.interfaces.IBlockWatchingHandler;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.interfaces.IHeadUpDisplayBlockRendererProvider;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IPowerLevelDisplay;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.block.PowerProviderGui;
import logisticspipes.network.packets.block.PowerProviderLevel;
import logisticspipes.network.packets.hud.HUDStartBlockWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopBlockWatchingPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

@CCType(name="LogisticsPowerProvider")
public abstract class LogisticsPowerProviderTileEntity
extends LogisticsSolidTileEntity
implements IGuiTileEntity,
ISubSystemPowerProvider,
IPowerLevelDisplay,
IGuiOpenControler,
IHeadUpDisplayBlockRendererProvider,
IBlockWatchingHandler {
    public static final int BC_COLOR = 65535;
    public static final int RF_COLOR = 0xFF0000;
    public static final int IC2_COLOR = 0xFFFF00;
    public boolean needMorePowerTriggerCheck = true;
    protected Map<Integer, Double> orders = new HashMap<Integer, Double>();
    protected BitSet reOrdered = new BitSet(ServerRouter.getBiggestSimpleID());
    protected boolean pauseRequesting = false;
    protected double internalStorage = 0.0;
    protected int maxMode = 1;
    private double lastUpdateStorage = 0.0;
    private PlayerCollectionList guiListener = new PlayerCollectionList();
    private PlayerCollectionList watcherList = new PlayerCollectionList();
    private IHeadUpDisplayRenderer HUD = new HUDPowerLevel(this);
    private boolean init = false;

    protected LogisticsPowerProviderTileEntity() {
    }

    @Override
    public void func_73660_a() {
        double fullfillRatio;
        double globalRequest;
        super.func_73660_a();
        this.pauseRequesting = false;
        if (!this.init) {
            if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
                LogisticsHUDRenderer.instance().add(this);
            }
            this.init = true;
        }
        if ((globalRequest = this.orders.values().stream().reduce(Double::sum).orElse(0.0).doubleValue()) > 0.0 && (fullfillRatio = Math.min(1.0, Math.min(this.internalStorage, this.getMaxProvidePerTick()) / globalRequest)) > 0.0) {
            Function<NeighborTileEntity, CoreRoutedPipe> getPipe = neighbor -> (CoreRoutedPipe)((LogisticsTileGenericPipe)neighbor.getTileEntity()).pipe;
            this.orders.entrySet().stream().map(routerIdToOrderCount -> new Pair<IRouter, Double>(SimpleServiceLocator.routerManager.getRouter((Integer)routerIdToOrderCount.getKey()), Math.min(this.internalStorage, (Double)routerIdToOrderCount.getValue() * fullfillRatio))).filter(destinationToPower -> destinationToPower.getValue1() != null && ((IRouter)destinationToPower.getValue1()).getPipe() != null).forEach(destinationToPower -> new WorldCoordinatesWrapper(this).allNeighborTileEntities().flatMap(neighbor -> neighbor.getJavaInstanceOf(LogisticsTileGenericPipe.class).map(Stream::of).orElseGet(Stream::empty)).filter(neighbor -> ((LogisticsTileGenericPipe)neighbor.getTileEntity()).pipe instanceof CoreRoutedPipe && !((CoreRoutedPipe)getPipe.apply((NeighborTileEntity)neighbor)).stillNeedReplace() && ((CoreRoutedPipe)getPipe.apply((NeighborTileEntity)neighbor)).getRouter() != null).flatMap(neighbor -> ((CoreRoutedPipe)getPipe.apply((NeighborTileEntity)neighbor)).getRouter().getDistanceTo((IRouter)destinationToPower.getValue1()).stream().map(exitRoute -> new Pair<NeighborTileEntity, ExitRoute>((NeighborTileEntity)neighbor, (ExitRoute)exitRoute))).filter(neighborToExit -> ((ExitRoute)neighborToExit.getValue2()).containsFlag(PipeRoutingConnectionType.canPowerSubSystemFrom) && ((ExitRoute)neighborToExit.getValue2()).filters.stream().noneMatch(IFilter::blockPower)).findFirst().ifPresent(neighborToSource -> {
                CoreRoutedPipe sourcePipe = (CoreRoutedPipe)getPipe.apply((NeighborTileEntity)neighborToSource.getValue1());
                if (sourcePipe.isInitialized()) {
                    sourcePipe.container.addLaser(((NeighborTileEntity)neighborToSource.getValue1()).getOurDirection(), 1.0f, this.getLaserColor(), true, true);
                }
                this.sendPowerLaserPackets(sourcePipe.getRouter(), (IRouter)destinationToPower.getValue1(), ((ExitRoute)neighborToSource.getValue2()).exitOrientation, ((ExitRoute)neighborToSource.getValue2()).exitOrientation != ((NeighborTileEntity)neighborToSource.getValue1()).getDirection());
                this.internalStorage -= ((Double)destinationToPower.getValue2()).doubleValue();
                if (this.internalStorage <= 0.0) {
                    this.internalStorage = 0.0;
                }
                this.handlePower(((IRouter)destinationToPower.getValue1()).getPipe(), (Double)destinationToPower.getValue2());
            }));
        }
        this.orders.clear();
        if (MainProxy.isServer((IBlockAccess)this.field_145850_b) && this.internalStorage != this.lastUpdateStorage) {
            this.updateClients();
            this.lastUpdateStorage = this.internalStorage;
        }
    }

    protected abstract void handlePower(CoreRoutedPipe var1, double var2);

    private void sendPowerLaserPackets(IRouter sourceRouter, IRouter destinationRouter, EnumFacing exitOrientation, boolean addBall) {
        if (sourceRouter == destinationRouter) {
            return;
        }
        LinkedList<Triplet<IRouter, EnumFacing, Boolean>> todo = new LinkedList<Triplet<IRouter, EnumFacing, Boolean>>();
        todo.add(new Triplet<IRouter, EnumFacing, Boolean>(sourceRouter, exitOrientation, addBall));
        while (!todo.isEmpty()) {
            Triplet part = (Triplet)todo.pollFirst();
            List<ExitRoute> exits = ((IRouter)part.getValue1()).getRoutersOnSide((EnumFacing)part.getValue2());
            for (ExitRoute exit : exits) {
                IRouter nextRouter;
                if (!exit.containsFlag(PipeRoutingConnectionType.canPowerSubSystemFrom)) continue;
                int distance = ((IRouter)part.getValue1()).getDistanceToNextPowerPipe(exit.exitOrientation);
                CoreRoutedPipe pipe = ((IRouter)part.getValue1()).getPipe();
                if (pipe != null && pipe.isInitialized()) {
                    pipe.container.addLaser(exit.exitOrientation, distance, this.getLaserColor(), false, (Boolean)part.getValue3());
                }
                if ((nextRouter = exit.destination) == destinationRouter) {
                    return;
                }
                block2: for (ExitRoute newExit : nextRouter.getDistanceTo(destinationRouter)) {
                    if (!newExit.containsFlag(PipeRoutingConnectionType.canPowerSubSystemFrom)) continue;
                    for (IFilter filter : newExit.filters) {
                        if (!filter.blockPower()) continue;
                        continue block2;
                    }
                    todo.addLast(new Triplet<IRouter, EnumFacing, Boolean>(nextRouter, newExit.exitOrientation, newExit.exitOrientation != exit.exitOrientation));
                }
            }
        }
    }

    protected abstract double getMaxProvidePerTick();

    @CCCommand(description="Returns the color for the power provided by this power provider")
    protected abstract int getLaserColor();

    @Override
    @CCCommand(description="Returns the max. amount of storable power")
    public abstract int getMaxStorage();

    @Override
    @CCCommand(description="Returns the power type stored in this power provider")
    public abstract String getBrand();

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
            LogisticsHUDRenderer.instance().remove(this);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
            this.init = false;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
            LogisticsHUDRenderer.instance().remove(this);
        }
    }

    @Override
    public void requestPower(int destination, double amount) {
        if (this.pauseRequesting) {
            return;
        }
        if (this.getBrand().equals("EU")) {
            System.out.print("");
        }
        if (this.orders.containsKey(destination)) {
            if (this.reOrdered.get(destination)) {
                this.pauseRequesting = true;
                this.reOrdered.clear();
            } else {
                this.reOrdered.set(destination);
            }
        } else {
            this.reOrdered.clear();
        }
        this.orders.put(destination, amount);
    }

    @Override
    @CCCommand(description="Returns the current power level for this power provider")
    public double getPowerLevel() {
        return this.lastUpdateStorage;
    }

    @Override
    public boolean usePaused() {
        return this.pauseRequesting;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.internalStorage = nbt.func_74781_a("internalStorage") instanceof NBTTagFloat ? (double)nbt.func_74760_g("internalStorage") : nbt.func_74769_h("internalStorage");
        this.maxMode = nbt.func_74762_e("maxMode");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74780_a("internalStorageDouble", this.internalStorage);
        nbt.func_74768_a("maxMode", this.maxMode);
        return nbt;
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public int getX() {
        return this.field_174879_c.func_177958_n();
    }

    @Override
    public int getY() {
        return this.field_174879_c.func_177956_o();
    }

    @Override
    public int getZ() {
        return this.field_174879_c.func_177952_p();
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartBlockWatchingPacket.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopBlockWatchingPacket.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void playerStartWatching(EntityPlayer player) {
        this.watcherList.add(player);
        this.updateClients();
    }

    @Override
    public void playerStopWatching(EntityPlayer player) {
        this.watcherList.remove(player);
    }

    @Override
    public boolean isHUDExistent() {
        return this.func_145831_w().func_175625_s(this.field_174879_c) == this;
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.guiListener.add(player);
        this.updateClients();
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.guiListener.remove(player);
    }

    public void updateClients() {
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(PowerProviderLevel.class).setDouble(this.internalStorage).setTilePos(this), this.guiListener);
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(PowerProviderLevel.class).setDouble(this.internalStorage).setTilePos(this), this.watcherList);
    }

    public void func_145828_a(CrashReportCategory par1CrashReportCategory) {
        super.func_145828_a(par1CrashReportCategory);
        par1CrashReportCategory.func_71507_a("LP-Version", (Object)"0.10.2.211:false");
    }

    public void handlePowerPacket(double d) {
        if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
            this.internalStorage = d;
        }
    }

    @Override
    public int getChargeState() {
        return (int)Math.min(100.0, this.internalStorage * 100.0 / (double)this.getMaxStorage());
    }

    @Override
    public int getDisplayPowerLevel() {
        return this.internalStorage > 2.147483647E9 ? Integer.MAX_VALUE : (int)this.internalStorage;
    }

    @Override
    public boolean isHUDInvalid() {
        return this.func_145837_r();
    }

    @Override
    public CoordinatesGuiProvider getGuiProvider() {
        return NewGuiHandler.getGui(PowerProviderGui.class);
    }
}

