/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import logisticspipes.LPItems;
import logisticspipes.LogisticsPipes;
import logisticspipes.items.LogisticsItem;
import logisticspipes.pipes.upgrades.ActionSpeedUpgrade;
import logisticspipes.pipes.upgrades.AdvancedSatelliteUpgrade;
import logisticspipes.pipes.upgrades.CCRemoteControlUpgrade;
import logisticspipes.pipes.upgrades.CombinedSneakyUpgrade;
import logisticspipes.pipes.upgrades.ConnectionUpgradeConfig;
import logisticspipes.pipes.upgrades.CraftingByproductUpgrade;
import logisticspipes.pipes.upgrades.CraftingCleanupUpgrade;
import logisticspipes.pipes.upgrades.CraftingMonitoringUpgrade;
import logisticspipes.pipes.upgrades.FluidCraftingUpgrade;
import logisticspipes.pipes.upgrades.FuzzyUpgrade;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.ItemExtractionUpgrade;
import logisticspipes.pipes.upgrades.ItemStackExtractionUpgrade;
import logisticspipes.pipes.upgrades.LogicControllerUpgrade;
import logisticspipes.pipes.upgrades.OpaqueUpgrade;
import logisticspipes.pipes.upgrades.PatternUpgrade;
import logisticspipes.pipes.upgrades.PowerTransportationUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgradeConfig;
import logisticspipes.pipes.upgrades.SpeedUpgrade;
import logisticspipes.pipes.upgrades.UpgradeModuleUpgrade;
import logisticspipes.pipes.upgrades.power.BCPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.IC2EVPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.IC2HVPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.IC2LVPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.IC2MVPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.RFPowerSupplierUpgrade;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;

public class ItemUpgrade
extends LogisticsItem {
    public static final int MAX_LIQUID_CRAFTER = 3;
    public static final int MAX_CRAFTING_CLEANUP = 4;
    public static final int MAX_ITEM_EXTRACTION = 8;
    public static final int MAX_ITEM_STACK_EXTRACTION = 8;
    private Upgrade upgradeType;
    public static String SHIFT_INFO_PREFIX = "item.upgrade.info.";

    public ItemUpgrade(Upgrade upgradeType) {
        this.upgradeType = upgradeType;
        this.func_77627_a(false);
    }

    public static void loadUpgrades(IForgeRegistry<Item> registry) {
        ItemUpgrade.registerUpgrade(registry, "sneaky_combination", CombinedSneakyUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "sneaky", SneakyUpgradeConfig::new);
        ItemUpgrade.registerUpgrade(registry, "speed", SpeedUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "disconnection", ConnectionUpgradeConfig::new);
        ItemUpgrade.registerUpgrade(registry, "satellite_advanced", AdvancedSatelliteUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "fluid_crafting", FluidCraftingUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "crafting_byproduct", CraftingByproductUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "pattern", PatternUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "fuzzy", FuzzyUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "power_transportation", PowerTransportationUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "power_supplier_mj", BCPowerSupplierUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "power_supplier_rf", RFPowerSupplierUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "power_supplier_eu_lv", IC2LVPowerSupplierUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "power_supplier_eu_mv", IC2MVPowerSupplierUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "power_supplier_eu_hv", IC2HVPowerSupplierUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "power_supplier_eu_ev", IC2EVPowerSupplierUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "cc_remote_control", CCRemoteControlUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "crafting_monitoring", CraftingMonitoringUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "opaque", OpaqueUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "crafting_cleanup", CraftingCleanupUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "logic_controller", LogicControllerUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "module_upgrade", UpgradeModuleUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "action_speed", ActionSpeedUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "item_extraction", ItemExtractionUpgrade::new);
        ItemUpgrade.registerUpgrade(registry, "item_stack_extraction", ItemStackExtractionUpgrade::new);
    }

    public static void registerUpgrade(IForgeRegistry<Item> registry, String name, Supplier<? extends IPipeUpgrade> upgradeConstructor) {
        Upgrade upgrade = new Upgrade(upgradeConstructor);
        ItemUpgrade item = LogisticsPipes.setName(new ItemUpgrade(upgrade), String.format("upgrade_%s", name));
        LPItems.upgrades.put(upgrade.getIPipeUpgradeClass(), item);
        registry.register((IForgeRegistryEntry)item);
    }

    public IPipeUpgrade getUpgradeForItem(ItemStack itemStack, IPipeUpgrade currentUpgrade) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        if (itemStack.func_77973_b() != this) {
            return null;
        }
        if (this.upgradeType.getIPipeUpgradeClass() == null) {
            return null;
        }
        if (currentUpgrade != null && this.upgradeType.getIPipeUpgradeClass().equals(currentUpgrade.getClass())) {
            return currentUpgrade;
        }
        IPipeUpgrade newupgrade = this.upgradeType.getIPipeUpgrade();
        if (newupgrade == null) {
            return null;
        }
        return newupgrade;
    }

    @Override
    public String getModelSubdir() {
        return "upgrade";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IPipeUpgrade upgrade = this.getUpgradeForItem(stack, null);
        if (upgrade == null) {
            return;
        }
        List<String> pipe = Arrays.asList(upgrade.getAllowedPipes());
        List<String> module = Arrays.asList(upgrade.getAllowedModules());
        if (pipe.isEmpty() && module.isEmpty()) {
            return;
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            if (!pipe.isEmpty() && !module.isEmpty()) {
                String base1 = StringUtils.translate(SHIFT_INFO_PREFIX + "both1");
                String base2 = StringUtils.translate(SHIFT_INFO_PREFIX + "both2");
                tooltip.add(MessageFormat.format(base1, this.join(pipe)));
                tooltip.add(MessageFormat.format(base2, this.join(module)));
            } else if (!pipe.isEmpty()) {
                String base = StringUtils.translate(SHIFT_INFO_PREFIX + "pipe");
                tooltip.add(MessageFormat.format(base, this.join(pipe)));
            } else if (!module.isEmpty()) {
                String base = StringUtils.translate(SHIFT_INFO_PREFIX + "module");
                tooltip.add(MessageFormat.format(base, this.join(module)));
            }
        } else {
            String baseKey = MessageFormat.format("{0}.tip", stack.func_77973_b().func_77667_c(stack));
            String key = baseKey + 1;
            String translation = StringUtils.translate(key);
            if (translation.equals(key)) {
                tooltip.add(StringUtils.translate("misc.holdshift"));
            }
        }
    }

    private String join(List<String> join) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < join.size() - 2; ++i) {
            builder.append(StringUtils.translate(SHIFT_INFO_PREFIX + join.get(i)));
            builder.append(", ");
        }
        if (join.size() > 1) {
            builder.append(StringUtils.translate(SHIFT_INFO_PREFIX + join.get(join.size() - 2)));
            builder.append(" and ");
        }
        builder.append(StringUtils.translate(SHIFT_INFO_PREFIX + join.get(join.size() - 1)));
        return builder.toString();
    }

    private static class Upgrade {
        private Supplier<? extends IPipeUpgrade> upgradeConstructor;
        private Class<? extends IPipeUpgrade> upgradeClass;

        private Upgrade(Supplier<? extends IPipeUpgrade> moduleConstructor) {
            this.upgradeConstructor = moduleConstructor;
            this.upgradeClass = moduleConstructor.get().getClass();
        }

        private IPipeUpgrade getIPipeUpgrade() {
            if (this.upgradeConstructor == null) {
                return null;
            }
            return this.upgradeConstructor.get();
        }

        private Class<? extends IPipeUpgrade> getIPipeUpgradeClass() {
            return this.upgradeClass;
        }
    }
}

