/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.gui.hud.modules.HUDExtractor;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.modules.abstractmodules.LogisticsSneakyDirectionModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.ExtractorModuleInHand;
import logisticspipes.network.guis.module.inpipe.ExtractorModuleSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.modules.ExtractorModuleMode;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.connection.NeighborTileEntity;

public class ModuleExtractor
extends LogisticsSneakyDirectionModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver {
    private int currentTick = 0;
    private EnumFacing _sneakyDirection = null;
    private IHUDModuleRenderer HUD = new HUDExtractor(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();

    protected int ticksToAction() {
        return 80 / (int)Math.pow(2.0, this.getUpgradeManager().getActionSpeedUpgrade());
    }

    protected int neededEnergy() {
        return (int)(5.0 * Math.pow(1.1, this.getUpgradeManager().getItemExtractionUpgrade()) * Math.pow(1.2, this.getUpgradeManager().getItemStackExtractionUpgrade()));
    }

    protected int itemsToExtract() {
        return (int)Math.pow(2.0, this.getUpgradeManager().getItemExtractionUpgrade());
    }

    protected CoreRoutedPipe.ItemSendMode itemSendMode() {
        return this.getUpgradeManager().getItemExtractionUpgrade() > 0 ? CoreRoutedPipe.ItemSendMode.Fast : CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public EnumFacing getSneakyDirection() {
        return this._sneakyDirection;
    }

    @Override
    public void setSneakyDirection(EnumFacing sneakyDirection) {
        this._sneakyDirection = sneakyDirection;
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ExtractorModuleMode.class).setDirection(this._sneakyDirection).setModulePos(this), this.localModeWatchers);
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        return null;
    }

    @Override
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ExtractorModuleSlot.class).setSneakyOrientation(this.getSneakyDirection());
    }

    @Override
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ExtractorModuleInHand.class);
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("sneakydirection")) {
            int sneak = nbttagcompound.func_74762_e("sneakydirection");
            this._sneakyDirection = sneak == 6 ? null : EnumFacing.values()[sneak];
        } else if (nbttagcompound.func_74764_b("sneakyorientation")) {
            int t = nbttagcompound.func_74762_e("sneakyorientation");
            switch (t) {
                default: {
                    this._sneakyDirection = null;
                    break;
                }
                case 1: {
                    this._sneakyDirection = EnumFacing.UP;
                    break;
                }
                case 2: {
                    this._sneakyDirection = EnumFacing.SOUTH;
                    break;
                }
                case 3: {
                    this._sneakyDirection = EnumFacing.DOWN;
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("sneakydirection", this._sneakyDirection == null ? 6 : this._sneakyDirection.ordinal());
    }

    @Override
    public void tick() {
        EnumFacing pointedOrientation;
        if (++this.currentTick < this.ticksToAction()) {
            return;
        }
        this.currentTick = 0;
        NeighborTileEntity<TileEntity> pointedItemHandler = this._service.getPointedItemHandler();
        if (pointedItemHandler == null) {
            return;
        }
        EnumFacing extractOrientation = this._sneakyDirection;
        if (extractOrientation == null && (pointedOrientation = this._service.getPointedOrientation()) != null) {
            extractOrientation = pointedOrientation.func_176734_d();
        }
        if (extractOrientation == null) {
            return;
        }
        IInventoryUtil targetUtil = this._service.getSneakyInventory(extractOrientation);
        if (targetUtil == null) {
            return;
        }
        int itemsleft = this.itemsToExtract();
        for (int i = 0; i < targetUtil.getSizeInventory(); ++i) {
            LinkedList<Integer> jamList;
            ItemIdentifier slotitem;
            Pair<Integer, SinkReply> reply;
            ItemStack slot = targetUtil.getStackInSlot(i);
            if (slot.func_190926_b() || (reply = this._service.hasDestination(slotitem = ItemIdentifier.get(slot), true, jamList = new LinkedList<Integer>())) == null) continue;
            while (reply != null) {
                ItemStack stackToSend;
                int count = Math.min(itemsleft, slot.func_190916_E());
                count = Math.min(count, slotitem.getMaxStackSize());
                if (reply.getValue2().maxNumberOfItems > 0) {
                    count = Math.min(count, reply.getValue2().maxNumberOfItems);
                }
                while (!this._service.useEnergy(this.neededEnergy() * count) && count > 0) {
                    this._service.spawnParticle(Particles.OrangeParticle, 2);
                    --count;
                }
                if (count <= 0 || (stackToSend = targetUtil.decrStackSize(i, count)).func_190926_b()) break;
                count = stackToSend.func_190916_E();
                this._service.sendStack(stackToSend, reply, this.itemSendMode());
                if ((itemsleft -= count) <= 0 || (slot = targetUtil.getStackInSlot(i)).func_190926_b()) break;
                jamList.add(reply.getValue1());
                reply = this._service.hasDestination(ItemIdentifier.get(slot), true, jamList);
            }
            if (itemsleft <= 0) break;
        }
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("Extraction: " + (this._sneakyDirection == null ? "DEFAULT" : this._sneakyDirection.name()));
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ExtractorModuleMode.class).setDirection(this._sneakyDirection).setModulePos(this), this.localModeWatchers);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }
}

