/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import logisticspipes.gui.hud.modules.HUDProviderModule;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILegacyActiveModule;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logistics.LogisticsManager;
import logisticspipes.logisticspipes.ExtractionMode;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.modules.abstractmodules.LogisticsSneakyDirectionModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.ProviderModuleInHand;
import logisticspipes.network.guis.module.inpipe.ProviderModuleGuiProvider;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.network.packets.modules.ExtractorModuleMode;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

@CCType(name="Provider Module")
public class ModuleProvider
extends LogisticsSneakyDirectionModule
implements ILegacyActiveModule,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IModuleInventoryReceive {
    private final ItemIdentifierInventory _filterInventory = new ItemIdentifierInventory(9, "Items to provide (or empty for all)", 1);
    private EnumFacing _sneakyDirection = null;
    private boolean isActive = false;
    protected final int ticksToActiveAction = 6;
    protected final int ticksToPassiveAction = 100;
    private final Map<ItemIdentifier, Integer> displayMap = new TreeMap<ItemIdentifier, Integer>();
    public final ArrayList<ItemIdentifierStack> displayList = new ArrayList();
    private final ArrayList<ItemIdentifierStack> oldList = new ArrayList();
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    protected int currentTick = 0;
    protected boolean isExcludeFilter = false;
    protected ExtractionMode _extractionMode = ExtractionMode.Normal;
    private IHUDModuleRenderer HUD = new HUDProviderModule(this);

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this.isActive = nbttagcompound.func_74767_n("isActive");
        this.isExcludeFilter = nbttagcompound.func_74767_n("filterisexclude");
        this._extractionMode = ExtractionMode.getMode(nbttagcompound.func_74762_e("extractionMode"));
        if (nbttagcompound.func_74764_b("sneakydirection")) {
            this._sneakyDirection = EnumFacing.values()[nbttagcompound.func_74762_e("sneakydirection")];
        } else if (nbttagcompound.func_74764_b("sneakyorientation")) {
            int t = nbttagcompound.func_74762_e("sneakyorientation");
            switch (t) {
                default: {
                    this._sneakyDirection = null;
                    break;
                }
                case 1: {
                    this._sneakyDirection = EnumFacing.UP;
                    break;
                }
                case 2: {
                    this._sneakyDirection = EnumFacing.SOUTH;
                    break;
                }
                case 3: {
                    this._sneakyDirection = EnumFacing.DOWN;
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("isActive", this.isActive);
        nbttagcompound.func_74757_a("filterisexclude", this.isExcludeFilter);
        nbttagcompound.func_74768_a("extractionMode", this._extractionMode.ordinal());
        if (this._sneakyDirection != null) {
            nbttagcompound.func_74768_a("sneakydirection", this._sneakyDirection.ordinal());
        }
    }

    @Override
    public EnumFacing getSneakyDirection() {
        return this._sneakyDirection;
    }

    @Override
    public void setSneakyDirection(EnumFacing sneakyDirection) {
        this._sneakyDirection = sneakyDirection;
        if (MainProxy.isServer((IBlockAccess)this._world.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ExtractorModuleMode.class).setDirection(this._sneakyDirection).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ProviderModuleGuiProvider.class).setExtractorMode(this.getExtractionMode().ordinal()).setExclude(this.isExcludeFilter);
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ProviderModuleInHand.class);
    }

    protected int neededEnergy() {
        return (int)(1.0 * Math.pow(1.1, this.getUpgradeManager().getItemExtractionUpgrade()) * Math.pow(1.2, this.getUpgradeManager().getItemStackExtractionUpgrade()));
    }

    protected int itemsToExtract() {
        return 8 * (int)Math.pow(2.0, this.getUpgradeManager().getItemExtractionUpgrade());
    }

    protected int stacksToExtract() {
        return 1 + this.getUpgradeManager().getItemStackExtractionUpgrade();
    }

    protected CoreRoutedPipe.ItemSendMode itemSendMode() {
        return this.getUpgradeManager().getItemExtractionUpgrade() > 0 ? CoreRoutedPipe.ItemSendMode.Fast : CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        return null;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        int sent;
        this.currentTick = 0;
        this.checkUpdate(null);
        int itemsleft = this.itemsToExtract();
        LogisticsItemOrder firstOrder = null;
        LogisticsItemOrder order = null;
        for (int stacksleft = this.stacksToExtract(); itemsleft > 0 && stacksleft > 0 && this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.PROVIDER) && (firstOrder == null || firstOrder != order); --stacksleft, itemsleft -= sent) {
            if (firstOrder == null) {
                firstOrder = order;
            }
            if ((sent = this.sendStack(order.getResource().stack, itemsleft, (order = (LogisticsItemOrder)this._service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.PROVIDER)).getDestination().getRouter().getSimpleID(), order.getInformation())) < 0) break;
            this._service.spawnParticle(Particles.VioletParticle, 3);
        }
    }

    public boolean filterAllowsItem(ItemIdentifier item) {
        if (!this.hasFilter()) {
            return true;
        }
        boolean isFiltered = this.itemIsFiltered(item);
        return this.isExcludeFilter ^ isFiltered;
    }

    @Override
    public void onBlockRemoval() {
        while (this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.PROVIDER)) {
            this._service.getItemOrderManager().sendFailed();
        }
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        IInventoryUtil inv;
        ArrayList<ItemIdentifier> possible = new ArrayList<ItemIdentifier>();
        if (tree.getRequestType() instanceof ItemResource) {
            possible.add(((ItemResource)tree.getRequestType()).getItem());
        } else if (tree.getRequestType() instanceof DictResource && (inv = this._service.getPointedInventory(this._extractionMode)) != null) {
            Map<ItemIdentifier, Integer> currentInv = inv.getItemsAndCount();
            possible.addAll(currentInv.keySet().stream().filter(item -> tree.getRequestType().matches((ItemIdentifier)item, IResource.MatchSettings.NORMAL)).collect(Collectors.toList()));
        }
        for (ItemIdentifier item2 : possible) {
            int canProvide = this.getAvailableItemCount(item2);
            canProvide -= root.getAllPromissesFor((IProvideItems)((Object)this._service), item2);
            if ((canProvide = Math.min(canProvide, tree.getMissingAmount())) < 1) {
                return;
            }
            LogisticsPromise promise = new LogisticsPromise(item2, canProvide, (IProvideItems)((Object)this._service), IOrderInfoProvider.ResourceType.PROVIDER);
            tree.addPromise(promise);
        }
    }

    @Override
    public LogisticsOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        return this._service.getItemOrderManager().addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, IOrderInfoProvider.ResourceType.PROVIDER, info);
    }

    private int getAvailableItemCount(ItemIdentifier item) {
        return this.getTotalItemCount(item) - this._service.getItemOrderManager().totalItemsCountInOrders(item);
    }

    @Override
    public void getAllItems(Map<ItemIdentifier, Integer> items, List<IFilter> filters) {
        IInventoryUtil inv = this._service.getPointedInventory(this._extractionMode);
        if (inv == null) {
            return;
        }
        Map<ItemIdentifier, Integer> currentInv = inv.getItemsAndCount();
        block0: for (Map.Entry<ItemIdentifier, Integer> currItem : currentInv.entrySet()) {
            if (items.containsKey(currItem.getKey()) || !this.filterAllowsItem(currItem.getKey())) continue;
            for (IFilter filter : filters) {
                if (filter.isBlocked() != filter.isFilteredItem(currItem.getKey().getUndamaged()) && !filter.blockProvider()) continue;
                continue block0;
            }
            int remaining = currItem.getValue() - this._service.getItemOrderManager().totalItemsCountInOrders(currItem.getKey());
            if (remaining < 1) continue;
            items.put(currItem.getKey(), remaining);
        }
    }

    private int sendStack(ItemIdentifierStack stack, int maxCount, int destination, IAdditionalTargetInformation info) {
        ItemIdentifier item = stack.getItem();
        IInventoryUtil inv = this._service.getPointedInventory(this._extractionMode);
        if (inv == null) {
            this._service.getItemOrderManager().sendFailed();
            return 0;
        }
        int available = inv.itemCount(item);
        if (available == 0) {
            this._service.getItemOrderManager().sendFailed();
            return 0;
        }
        int wanted = Math.min(available, stack.getStackSize());
        wanted = Math.min(wanted, maxCount);
        wanted = Math.min(wanted, item.getMaxStackSize());
        IRouter dRtr = SimpleServiceLocator.routerManager.getRouterUnsafe(destination, false);
        if (dRtr == null) {
            this._service.getItemOrderManager().sendFailed();
            return 0;
        }
        SinkReply reply = LogisticsManager.canSink(dRtr, null, true, stack.getItem(), null, true, false);
        boolean defersend = false;
        if (reply != null && reply.maxNumberOfItems < wanted) {
            wanted = reply.maxNumberOfItems;
            if (wanted <= 0) {
                this._service.getItemOrderManager().deferSend();
                return 0;
            }
            defersend = true;
        }
        if (!this._service.canUseEnergy(wanted * this.neededEnergy())) {
            return -1;
        }
        ItemStack removed = inv.getMultipleItems(item, wanted);
        if (removed.func_190926_b()) {
            this._service.getItemOrderManager().sendFailed();
            return 0;
        }
        int sent = removed.func_190916_E();
        this._service.useEnergy(sent * this.neededEnergy());
        IRoutedItem sendedItem = this._service.sendStack(removed, destination, this.itemSendMode(), info);
        this._service.getItemOrderManager().sendSuccessfull(sent, defersend, sendedItem);
        return sent;
    }

    private int getTotalItemCount(ItemIdentifier item) {
        IInventoryUtil inv = this._service.getPointedInventory(this._extractionMode);
        if (inv == null) {
            return 0;
        }
        if (!this.filterAllowsItem(item)) {
            return 0;
        }
        return inv.itemCount(item);
    }

    private boolean hasFilter() {
        return !this._filterInventory.func_191420_l();
    }

    private boolean itemIsFiltered(ItemIdentifier item) {
        return this._filterInventory.containsItem(item);
    }

    @CCCommand(description="Returns the FilterInventory of this Module")
    public IInventory getFilterInventory() {
        return this._filterInventory;
    }

    public boolean isExcludeFilter() {
        return this.isExcludeFilter;
    }

    public void setFilterExcluded(boolean isExcludeFilter) {
        this.isExcludeFilter = isExcludeFilter;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public ExtractionMode getExtractionMode() {
        return this._extractionMode;
    }

    public void setExtractionMode(int id) {
        this._extractionMode = ExtractionMode.getMode(id);
    }

    public void nextExtractionMode() {
        this._extractionMode = this._extractionMode.next();
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(!this.isExcludeFilter ? "Included" : "Excluded");
        list.add("Mode: " + this._extractionMode.getExtractionModeString());
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    private void checkUpdate(EntityPlayer player) {
        if (this.localModeWatchers.size() == 0 && player == null) {
            return;
        }
        this.displayList.clear();
        this.displayMap.clear();
        this.getAllItems(this.displayMap, new ArrayList<IFilter>(0));
        this.displayList.ensureCapacity(this.displayMap.size());
        this.displayList.addAll(this.displayMap.entrySet().stream().map(item -> new ItemIdentifierStack((ItemIdentifier)item.getKey(), (Integer)item.getValue())).collect(Collectors.toList()));
        if (!this.oldList.equals(this.displayList)) {
            this.oldList.clear();
            this.oldList.ensureCapacity(this.displayList.size());
            this.oldList.addAll(this.displayList);
            MainProxy.sendToPlayerList(PacketHandler.getPacket(ModuleInventory.class).setIdentList(this.displayList).setModulePos(this).setCompressable(true), this.localModeWatchers);
        } else if (player != null) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(this.displayList).setModulePos(this).setCompressable(true), player);
        }
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        this.checkUpdate(player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public void handleInvContent(Collection<ItemIdentifierStack> list) {
        this.displayList.clear();
        this.displayList.addAll(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        if (this.isExcludeFilter || this._filterInventory.func_191420_l()) {
            return null;
        }
        Map<ItemIdentifier, Integer> mapIC = this._filterInventory.getItemsAndCount();
        ArrayList<ItemIdentifier> li = new ArrayList<ItemIdentifier>(mapIC.size());
        li.addAll(mapIC.keySet());
        return li;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return this.isExcludeFilter || this._filterInventory.func_191420_l();
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }
}

