/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.DelayPacketException;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.StaticResolverUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.util.LPDataIOWrapper;
import network.rs485.logisticspipes.util.LPDataInput;
import org.apache.logging.log4j.Level;

@ChannelHandler.Sharable
public class PacketHandler
extends MessageToMessageCodec<FMLProxyPacket, ModernPacket> {
    public static final Map<Integer, StackTraceElement[]> debugMap = new HashMap<Integer, StackTraceElement[]>();
    protected static final AttributeKey<ThreadLocal<FMLProxyPacket>> INBOUNDPACKETTRACKER = AttributeKey.newInstance((String)"lp:inboundpacket");
    public static List<ModernPacket> packetlist;
    public static Map<Class<? extends ModernPacket>, ModernPacket> packetmap;
    private static int packetDebugID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ModernPacket> T getPacket(Class<T> clazz) {
        ModernPacket packet = packetmap.get(clazz).template();
        if (LPConstants.DEBUG && MainProxy.proxy.getSide().equals("Client")) {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            Map<Integer, StackTraceElement[]> map = debugMap;
            synchronized (map) {
                int id = packetDebugID++;
                debugMap.put(id, trace);
                packet.setDebugId(id);
            }
        }
        return (T)packet;
    }

    public static void initialize() {
        Set<Class<? extends ModernPacket>> classes = StaticResolverUtil.findClassesByType(ModernPacket.class);
        PacketHandler.loadPackets(classes);
        if (packetlist.isEmpty()) {
            throw new RuntimeException("Cannot load Packet Classes");
        }
    }

    private static void loadPackets(Set<Class<? extends ModernPacket>> classesIn) {
        List classes = classesIn.stream().sorted(Comparator.comparing(Class::getCanonicalName)).collect(Collectors.toList());
        packetlist = new ArrayList<ModernPacket>(classes.size());
        packetmap = new HashMap<Class<? extends ModernPacket>, ModernPacket>(classes.size());
        int currentId = 0;
        for (Class cls : classes) {
            try {
                ModernPacket instance = (ModernPacket)cls.getConstructor(Integer.TYPE).newInstance(currentId);
                packetlist.add(instance);
                packetmap.put(cls, instance);
                ++currentId;
            }
            catch (Throwable ignoredButPrinted) {
                ignoredButPrinted.printStackTrace();
            }
        }
    }

    public static FMLProxyPacket toFMLPacket(ModernPacket msg) throws Exception {
        return PacketHandler.toFMLPacket(msg, "LogisticsPipes");
    }

    private static FMLProxyPacket toFMLPacket(ModernPacket msg, String channel) {
        ByteBuf buffer = Unpooled.buffer();
        PacketHandler.fillByteBuf(msg, buffer);
        return new FMLProxyPacket(new PacketBuffer(buffer), channel);
    }

    public static void fillByteBuf(ModernPacket msg, ByteBuf buffer) {
        buffer.writeShort(msg.getId());
        buffer.writeInt(msg.getDebugId());
        LPDataIOWrapper.writeData(buffer, msg::writeData);
    }

    public static void addPacketToNBT(ModernPacket packet, NBTTagCompound nbt) {
        ByteBuf dataBuffer = Unpooled.buffer();
        PacketHandler.fillByteBuf(packet, dataBuffer);
        byte[] data = new byte[dataBuffer.readableBytes()];
        dataBuffer.getBytes(0, data);
        dataBuffer.release();
        nbt.func_74773_a("LogisticsPipes:PacketData", data);
    }

    @SideOnly(value=Side.CLIENT)
    public static void queueAndRemovePacketFromNBT(NBTTagCompound nbt) {
        byte[] data = nbt.func_74770_j("LogisticsPipes:PacketData");
        if (data.length > 0) {
            LPDataIOWrapper.provideData(data, dataInput -> {
                short packetID = dataInput.readShort();
                ModernPacket packet = packetlist.get(packetID).template();
                packet.setDebugId(dataInput.readInt());
                packet.readData(dataInput);
                SimpleServiceLocator.clientBufferHandler.queuePacket(packet, MainProxy.proxy.getClientPlayer());
            });
        }
        nbt.func_82580_o("LogisticsPipes:PacketData");
    }

    public static void onPacketData(LPDataInput data, EntityPlayer player) {
        if (player == null) {
            return;
        }
        short packetID = data.readShort();
        ModernPacket packet = packetlist.get(packetID).template();
        packet.setDebugId(data.readInt());
        packet.readData(data);
        PacketHandler.onPacketData(packet, player);
    }

    public static void onPacketData(ModernPacket packet, EntityPlayer player) {
        try {
            packet.processPacket(player);
            if (LPConstants.DEBUG) {
                debugMap.remove(packet.getDebugId());
            }
        }
        catch (DelayPacketException e) {
            if (packet.retry() && MainProxy.isClient((IBlockAccess)player.func_130014_f_())) {
                SimpleServiceLocator.clientBufferHandler.queuePacket(packet, player);
            } else if (LPConstants.DEBUG) {
                LogisticsPipes.log.error(packet.getClass().getName());
                LogisticsPipes.log.error(packet.toString());
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.attr(INBOUNDPACKETTRACKER).set(new ThreadLocal());
    }

    protected final void encode(ChannelHandlerContext ctx, ModernPacket msg, List<Object> out) throws Exception {
        FMLProxyPacket proxy = PacketHandler.toFMLPacket(msg, (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        FMLProxyPacket old = (FMLProxyPacket)((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).get();
        if (old != null) {
            proxy.setDispatcher(old.getDispatcher());
        }
        out.add(proxy);
    }

    protected final void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) {
        ByteBuf payload = msg.payload();
        short packetID = payload.readShort();
        ModernPacket packet = packetlist.get(packetID).template();
        packet.setDebugId(payload.readInt());
        ((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).set(msg);
        LPDataIOWrapper.provideData(payload.slice(), packet::readData);
        EntityPlayer player = MainProxy.proxy.getEntityPlayerFromNetHandler(msg.handler());
        if (player != null) {
            out.add(new InboundModernPacketWrapper(packet, player));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log((Level)Level.ERROR, (Throwable)cause, (String)"LogisticsPipes PacketHandler exception caught", (Object[])new Object[0]);
        super.exceptionCaught(ctx, cause);
    }

    static {
        packetDebugID = 1;
    }

    static class InboundModernPacketWrapper {
        final ModernPacket packet;
        final EntityPlayer player;

        InboundModernPacketWrapper(ModernPacket p, EntityPlayer e) {
            this.packet = p;
            this.player = e;
        }
    }
}

