/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import logisticspipes.LPItems;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SetCurrentPagePacket
extends ModernPacket {
    private float sliderProgress;
    private int page;
    private EnumHand hand;

    public SetCurrentPagePacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ItemStack book = player.func_184586_b(this.hand);
        if (book.func_77973_b() != LPItems.itemGuideBook) {
            return;
        }
        NBTTagCompound nbt = book.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74776_a("sliderProgress", this.sliderProgress);
        nbt.func_74768_a("page", this.page);
        book.func_77982_d(nbt);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.hand = input.readEnum(EnumHand.class);
        this.sliderProgress = input.readFloat();
        this.page = input.readInt();
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeEnum(this.hand);
        output.writeFloat(this.sliderProgress);
        output.writeInt(this.page);
    }

    @Override
    public ModernPacket template() {
        return new SetCurrentPagePacket(this.getId());
    }

    public float getSliderProgress() {
        return this.sliderProgress;
    }

    public SetCurrentPagePacket setSliderProgress(float sliderProgress) {
        this.sliderProgress = sliderProgress;
        return this;
    }

    public int getPage() {
        return this.page;
    }

    public SetCurrentPagePacket setPage(int page) {
        this.page = page;
        return this;
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public SetCurrentPagePacket setHand(EnumHand hand) {
        this.hand = hand;
        return this;
    }
}

