/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debug;

import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.debug.LogWindow;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SendNewLogWindow
extends ModernPacket {
    private int windowID;
    private String title;

    public SendNewLogWindow(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.windowID = input.readInt();
        this.title = input.readUTF();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogWindow.getWindow(this.windowID).setTitle(this.title);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeInt(this.windowID);
        output.writeUTF(this.title);
    }

    @Override
    public ModernPacket template() {
        return new SendNewLogWindow(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public int getWindowID() {
        return this.windowID;
    }

    public SendNewLogWindow setWindowID(int windowID) {
        this.windowID = windowID;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public SendNewLogWindow setTitle(String title) {
        this.title = title;
        return this;
    }
}

