/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debuggui;

import logisticspipes.commands.commands.debug.DebugGuiController;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class DebugDataPacket
extends ModernPacket {
    private byte[] payload;
    private int identifier;

    public DebugDataPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.payload = input.readByteArray();
        this.identifier = input.readInt();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        DebugGuiController.instance().handleDataPacket(this.payload, this.identifier, player);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeByteArray(this.payload);
        output.writeInt(this.identifier);
    }

    @Override
    public ModernPacket template() {
        return new DebugDataPacket(this.getId());
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public DebugDataPacket setPayload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public DebugDataPacket setIdentifier(int identifier) {
        this.identifier = identifier;
        return this;
    }
}

