/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.util.List;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.routing.order.ClientSideOrderInfo;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class PipeManagerContentPacket
extends CoordinatesPacket {
    private LogisticsOrderManager<? extends LogisticsOrder, ?> manager;
    private List<IOrderInfoProvider> clientOrder;

    public PipeManagerContentPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_());
        if (pipe == null || !(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        CoreRoutedPipe cPipe = (CoreRoutedPipe)pipe.pipe;
        cPipe.getClientSideOrderManager().clear();
        cPipe.getClientSideOrderManager().addAll(this.clientOrder);
    }

    @Override
    public ModernPacket template() {
        return new PipeManagerContentPacket(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.manager.size());
        for (LogisticsOrder order : this.manager) {
            output.writeSerializable(order);
        }
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.clientOrder = input.readLinkedList(ClientSideOrderInfo::new);
    }

    public LogisticsOrderManager<? extends LogisticsOrder, ?> getManager() {
        return this.manager;
    }

    public PipeManagerContentPacket setManager(LogisticsOrderManager<? extends LogisticsOrder, ?> manager) {
        this.manager = manager;
        return this;
    }
}

