/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class PipePositionPacket
extends CoordinatesPacket {
    private int travelId;
    private float speed;
    private float position;
    private EnumFacing input;
    private EnumFacing output;
    private float yaw;

    public PipePositionPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe tile = this.getPipe(player.func_130014_f_(), CoordinatesPacket.LTGPCompletionCheck.TRANSPORT);
        if (tile == null || tile.pipe == null || tile.pipe.transport == null) {
            return;
        }
        tile.pipe.transport.handleItemPositionPacket(this.travelId, this.input, this.output, this.speed, this.position, this.yaw);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.travelId);
        output.writeFloat(this.speed);
        output.writeFloat(this.position);
        output.writeFacing(this.input);
        output.writeFacing(this.output);
        output.writeFloat(this.yaw);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.travelId = input.readInt();
        this.speed = input.readFloat();
        this.position = input.readFloat();
        this.input = input.readFacing();
        this.output = input.readFacing();
        this.yaw = input.readFloat();
    }

    @Override
    public ModernPacket template() {
        return new PipePositionPacket(this.getId());
    }

    public int getTravelId() {
        return this.travelId;
    }

    public PipePositionPacket setTravelId(int travelId) {
        this.travelId = travelId;
        return this;
    }

    public float getSpeed() {
        return this.speed;
    }

    public PipePositionPacket setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public float getPosition() {
        return this.position;
    }

    public PipePositionPacket setPosition(float position) {
        this.position = position;
        return this;
    }

    public EnumFacing getInput() {
        return this.input;
    }

    public PipePositionPacket setInput(EnumFacing input) {
        this.input = input;
        return this;
    }

    public EnumFacing getOutput() {
        return this.output;
    }

    public PipePositionPacket setOutput(EnumFacing output) {
        this.output = output;
        return this;
    }

    public float getYaw() {
        return this.yaw;
    }

    public PipePositionPacket setYaw(float yaw) {
        this.yaw = yaw;
        return this;
    }
}

