/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.LaserData;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class RoutingLaserPacket
extends ModernPacket {
    List<LaserData> lasers = new ArrayList<LaserData>();

    public RoutingLaserPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        while (input.readBoolean()) {
            this.lasers.add(new LaserData().readData(input));
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsHUDRenderer.instance().setLasers(this.getLasers());
    }

    @Override
    public void writeData(LPDataOutput output) {
        for (LaserData laser : this.lasers) {
            output.writeBoolean(true);
            laser.writeData(output);
        }
        output.writeBoolean(false);
    }

    @Override
    public ModernPacket template() {
        return new RoutingLaserPacket(this.getId());
    }

    public RoutingLaserPacket setLasers(List<LaserData> lasers) {
        this.lasers = lasers;
        return this;
    }

    public List<LaserData> getLasers() {
        return this.lasers;
    }
}

