/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.routingdebug;

import java.util.EnumSet;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.debug.ClientViewController;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;

@StaticResolve
public class RoutingUpdateDebugClosedSet
extends ModernPacket {
    private DoubleCoordinates pos;
    private EnumSet<PipeRoutingConnectionType> set;

    public RoutingUpdateDebugClosedSet(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.set = input.readEnumSet(PipeRoutingConnectionType.class);
        this.pos = new DoubleCoordinates(input);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ClientViewController.instance().handlePacket(this);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeEnumSet(this.set, PipeRoutingConnectionType.class);
        output.writeSerializable(this.pos);
    }

    @Override
    public ModernPacket template() {
        return new RoutingUpdateDebugClosedSet(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public DoubleCoordinates getPos() {
        return this.pos;
    }

    public RoutingUpdateDebugClosedSet setPos(DoubleCoordinates pos) {
        this.pos = pos;
        return this;
    }

    public EnumSet<PipeRoutingConnectionType> getSet() {
        return this.set;
    }

    public RoutingUpdateDebugClosedSet setSet(EnumSet<PipeRoutingConnectionType> set) {
        this.set = set;
        return this;
    }
}

