/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LPBlocks;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.IRotationProvider;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.items.ItemLogisticsPipe;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericSubMultiBlock;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.pipes.basic.ltgpmodcompat.LPMicroblockBlock;
import logisticspipes.proxy.MainProxy;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.renderer.newpipe.PropertyCache;
import logisticspipes.renderer.newpipe.PropertyRenderList;
import logisticspipes.ticks.QueuedTasks;
import logisticspipes.utils.LPPositionSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import network.rs485.logisticspipes.config.ClientConfiguration;
import network.rs485.logisticspipes.proxy.mcmp.BlockAccessDelegate;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.DoubleCoordinatesType;

public class LogisticsBlockGenericPipe
extends LPMicroblockBlock {
    public static boolean ignoreSideRayTrace = false;
    public static Map<Item, Function<Item, ? extends CoreUnroutedPipe>> pipes = new HashMap<Item, Function<Item, ? extends CoreUnroutedPipe>>();
    public static Map<DoubleCoordinates, CoreUnroutedPipe> pipeRemoved = new HashMap<DoubleCoordinates, CoreUnroutedPipe>();
    public static Map<DoubleCoordinates, BlockPos> pipeSubMultiRemoved = new HashMap<DoubleCoordinates, BlockPos>();
    private static long lastRemovedDate = -1L;
    protected final Random rand = new Random();
    public static final PropertyInteger rotationProperty = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)3);
    public static final PropertyEnum<PipeRenderModel> modelTypeProperty = PropertyEnum.func_177709_a((String)"model_type", PipeRenderModel.class);
    public static final Map<EnumFacing, PropertyBool> connectionPropertys = Arrays.stream(EnumFacing.values()).collect(Collectors.toMap(key -> key, key -> PropertyBool.func_177716_a((String)("connection_" + key.ordinal()))));
    public static final PropertyRenderList propertyRenderList = new PropertyRenderList();
    public static final PropertyCache propertyCache = new PropertyCache();
    public static final AxisAlignedBB PIPE_CENTER_BB = new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125);
    public static final List<AxisAlignedBB> PIPE_CONN_BB = Arrays.asList(new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.1875, 0.8125), new AxisAlignedBB(0.1875, 0.8125, 0.1875, 0.8125, 1.0, 0.8125), new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.1875), new AxisAlignedBB(0.1875, 0.1875, 0.8125, 0.8125, 0.8125, 1.0), new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.1875, 0.8125, 0.8125), new AxisAlignedBB(0.8125, 0.1875, 0.1875, 1.0, 0.8125, 0.8125));
    private static final EnumFacing[] DIR_VALUES = new EnumFacing[EnumFacing.field_82609_l.length + 1];

    public LogisticsBlockGenericPipe() {
        super(Material.field_151592_s);
        IBlockState state = this.field_176227_L.func_177621_b().func_177226_a((IProperty)rotationProperty, (Comparable)Integer.valueOf(0)).func_177226_a(modelTypeProperty, (Comparable)((Object)PipeRenderModel.NONE));
        connectionPropertys.values().forEach(it -> state.func_177226_a((IProperty)it, (Comparable)Boolean.valueOf(false)));
        this.func_180632_j(state);
        this.func_149647_a(LogisticsPipes.CREATIVE_TAB_LP);
    }

    public static void removePipe(CoreUnroutedPipe pipe) {
        if (!LogisticsBlockGenericPipe.isValid(pipe)) {
            return;
        }
        if (pipe.canBeDestroyed() || pipe.destroyByPlayer()) {
            pipe.onBlockRemoval();
        } else if (pipe.preventRemove()) {
            LogisticsBlockGenericPipe.cacheTileToPreventRemoval(pipe);
        }
        World world = pipe.container.func_145831_w();
        if (lastRemovedDate != world.func_82737_E()) {
            lastRemovedDate = world.func_82737_E();
            pipeRemoved.clear();
            pipeSubMultiRemoved.clear();
        }
        if (pipe.isMultiBlock()) {
            if (pipe.preventRemove()) {
                throw new UnsupportedOperationException("A multi block can't be protected against removal.");
            }
            LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> list = ((CoreMultiBlockPipe)pipe).getRotatedSubBlocks();
            list.forEach(pos -> pos.add(new DoubleCoordinates(pipe)));
            for (DoubleCoordinates pos2 : pipe.container.subMultiBlock) {
                TileEntity tile = pos2.getTileEntity((IBlockAccess)world);
                if (!(tile instanceof LogisticsTileGenericSubMultiBlock)) continue;
                DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare> equ = list.findClosest(pos2);
                if (equ != null) {
                    ((LogisticsTileGenericSubMultiBlock)tile).removeSubType(equ.getType());
                }
                if (((LogisticsTileGenericSubMultiBlock)tile).removeMainPipe(new DoubleCoordinates(pipe))) {
                    LogisticsBlockGenericSubMultiBlock.redirectedToMainPipe = true;
                    pos2.setBlockToAir(world);
                    LogisticsBlockGenericSubMultiBlock.redirectedToMainPipe = false;
                    pipeSubMultiRemoved.put(new DoubleCoordinates(pos2), pipe.container.func_174877_v());
                    continue;
                }
                MainProxy.sendPacketToAllWatchingChunk(tile, ((LogisticsTileGenericSubMultiBlock)tile).getLPDescriptionPacket());
            }
        }
        BlockPos pos3 = pipe.container.func_174877_v();
        pipeRemoved.put(new DoubleCoordinates(pos3), pipe);
        world.func_175713_t(pos3);
    }

    public static ItemLogisticsPipe registerPipe(IForgeRegistry<Item> registry, String name, Function<Item, ? extends CoreUnroutedPipe> constructor) {
        ItemLogisticsPipe item = new ItemLogisticsPipe();
        LogisticsPipes.setName(item, String.format("pipe_%s", name));
        pipes.put(item, constructor);
        CoreUnroutedPipe dummyPipe = LogisticsBlockGenericPipe.createPipe(item);
        if (dummyPipe != null) {
            item.setPipeIconIndex(dummyPipe.getIconIndexForItem(), dummyPipe.getTextureIndex());
            MainProxy.proxy.setIconProviderFromPipe(item, dummyPipe);
            item.setDummyPipe(dummyPipe);
        }
        registry.register((IForgeRegistryEntry)item);
        return item;
    }

    public static CoreUnroutedPipe createPipe(Item key) {
        Function<Item, ? extends CoreUnroutedPipe> pipe = pipes.get(key);
        if (pipe != null) {
            return pipe.apply(key);
        }
        LogisticsPipes.log.warn("Detected pipe with unknown key (" + key + "). This should not have happend.");
        return null;
    }

    public static boolean placePipe(CoreUnroutedPipe pipe, World world, BlockPos blockPos, Block block) {
        return LogisticsBlockGenericPipe.placePipe(pipe, world, blockPos, block, null);
    }

    public static boolean placePipe(CoreUnroutedPipe pipe, World world, BlockPos blockPos, Block block, ITubeOrientation orientation) {
        IBlockState oldBlockState = world.func_180495_p(blockPos);
        boolean placed = world.func_180501_a(blockPos, block.func_176223_P(), 0);
        if (world.field_72995_K) {
            return placed;
        }
        if (placed) {
            TileEntity tile = world.func_175625_s(blockPos);
            if (tile instanceof LogisticsTileGenericPipe) {
                LogisticsTileGenericPipe tilePipe = (LogisticsTileGenericPipe)tile;
                if (pipe instanceof CoreMultiBlockPipe) {
                    DoubleCoordinates placeAt;
                    if (orientation == null) {
                        throw new NullPointerException();
                    }
                    CoreMultiBlockPipe mPipe = (CoreMultiBlockPipe)pipe;
                    orientation.setOnPipe(mPipe);
                    LogisticsBlockGenericSubMultiBlock.currentCreatedMultiBlock = placeAt = new DoubleCoordinates(blockPos);
                    LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> positions = ((CoreMultiBlockPipe)pipe).getSubBlocks();
                    orientation.rotatePositions(positions);
                    for (DoubleCoordinatesType doubleCoordinatesType : positions) {
                        doubleCoordinatesType.add(placeAt);
                        TileEntity subTile = world.func_175625_s(doubleCoordinatesType.getBlockPos());
                        IBlockState oldSubBlockState = world.func_180495_p(doubleCoordinatesType.getBlockPos());
                        if (subTile instanceof LogisticsTileGenericSubMultiBlock) {
                            ((LogisticsTileGenericSubMultiBlock)subTile).addMultiBlockMainPos(placeAt);
                            ((LogisticsTileGenericSubMultiBlock)subTile).addSubTypeTo((CoreMultiBlockPipe.SubBlockTypeForShare)((Object)doubleCoordinatesType.getType()));
                            MainProxy.sendPacketToAllWatchingChunk(subTile, ((LogisticsTileGenericSubMultiBlock)subTile).getLPDescriptionPacket());
                        } else {
                            world.func_180501_a(doubleCoordinatesType.getBlockPos(), LPBlocks.subMultiblock.func_176223_P(), 0);
                            subTile = world.func_175625_s(doubleCoordinatesType.getBlockPos());
                            if (subTile instanceof LogisticsTileGenericSubMultiBlock) {
                                ((LogisticsTileGenericSubMultiBlock)subTile).addSubTypeTo((CoreMultiBlockPipe.SubBlockTypeForShare)((Object)doubleCoordinatesType.getType()));
                            }
                        }
                        world.markAndNotifyBlock(doubleCoordinatesType.getBlockPos(), world.func_175726_f(doubleCoordinatesType.getBlockPos()), oldSubBlockState, world.func_180495_p(doubleCoordinatesType.getBlockPos()), 3);
                    }
                    LogisticsBlockGenericSubMultiBlock.currentCreatedMultiBlock = null;
                }
                tilePipe.initialize(pipe);
            }
            world.markAndNotifyBlock(blockPos, world.func_175726_f(blockPos), oldBlockState, world.func_180495_p(blockPos), 3);
        }
        return placed;
    }

    public static CoreUnroutedPipe getPipe(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (!(tile instanceof LogisticsTileGenericPipe) || tile.func_145837_r()) {
            return null;
        }
        return ((LogisticsTileGenericPipe)tile).pipe;
    }

    public static boolean isFullyDefined(CoreUnroutedPipe pipe) {
        return pipe != null && pipe.transport != null && pipe.container != null;
    }

    public static boolean isValid(CoreUnroutedPipe pipe) {
        return LogisticsBlockGenericPipe.isFullyDefined(pipe);
    }

    private static void cacheTileToPreventRemoval(CoreUnroutedPipe pipe) {
        World worldCache = pipe.getWorld();
        BlockPos posCache = pipe.getPos();
        LogisticsTileGenericPipe tileCache = pipe.container;
        CoreUnroutedPipe fPipe = pipe;
        fPipe.setPreventRemove(true);
        QueuedTasks.queueTask(() -> {
            if (!fPipe.preventRemove()) {
                return null;
            }
            boolean changed = false;
            if (worldCache.func_180495_p(posCache) != null || worldCache.func_180495_p(posCache).func_177230_c() != LPBlocks.pipe) {
                worldCache.func_175656_a(posCache, LPBlocks.pipe.func_176223_P());
                changed = true;
            }
            if (worldCache.func_175625_s(posCache) != tileCache) {
                worldCache.func_175690_a(posCache, tileCache);
                changed = true;
            }
            if (changed) {
                worldCache.markAndNotifyBlock(posCache, worldCache.func_175726_f(posCache), worldCache.func_180495_p(posCache), worldCache.func_180495_p(posCache), 3);
            }
            fPipe.setPreventRemove(false);
            return null;
        });
    }

    @Nonnull
    public ArrayList<ItemStack> getDrops(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if (MainProxy.isClient(world)) {
            return null;
        }
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe(world, pos);
            if (pipe == null) {
                pipe = pipeRemoved.get(new DoubleCoordinates(pos));
            }
            if (pipe == null) continue;
            if (pipe.item != null && (pipe.canBeDestroyed() || pipe.destroyByPlayer())) {
                list.addAll(pipe.dropContents());
                list.add(new ItemStack(pipe.item, 1, this.func_180651_a(state)));
                continue;
            }
            if (pipe.item == null) continue;
            LogisticsBlockGenericPipe.cacheTileToPreventRemoval(pipe);
        }
        mcmpBlockAccess.addDrops(list, world, pos, state, fortune);
        return list;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void addCollisionBoxToList(LogisticsTileGenericPipe pipe, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        this.func_185477_a(pipe.func_145831_w().func_180495_p(pipe.func_174877_v()), pipe.func_145831_w(), pipe.func_174877_v(), entityBox, collidingBoxes, entityIn, isActualState);
    }

    public void func_185477_a(IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LogisticsTileGenericPipe) {
            LogisticsTileGenericPipe tile = (LogisticsTileGenericPipe)te;
            CoreUnroutedPipe pipe = tile.pipe;
            if (pipe instanceof PipeBlockRequestTable) {
                LogisticsBlockGenericPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)Block.field_185505_j);
                return;
            }
            if (pipe != null && pipe.isMultiBlock()) {
                ((CoreMultiBlockPipe)pipe).addCollisionBoxesToList(collidingBoxes, entityBox);
                if (!pipe.actAsNormalPipe()) {
                    return;
                }
            }
            Arrays.stream(EnumFacing.field_82609_l).filter(tile::isPipeConnectedCached).map(f -> PIPE_CONN_BB.get(f.func_176745_a())).forEach(bb -> LogisticsBlockGenericPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)bb));
        }
        LogisticsBlockGenericPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PIPE_CENTER_BB);
        mcmpBlockAccess.addCollisionBoxToList(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, @Nonnull BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            return new AxisAlignedBB((double)pos.func_177958_n() + 0.0, (double)pos.func_177956_o() + 0.0, (double)pos.func_177952_p() + 0.0, (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 1.0);
        }
        InternalRayTraceResult rayTraceResult = this.doRayTrace(world, pos, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null) {
            AxisAlignedBB box = rayTraceResult.boundingBox;
            if (rayTraceResult.hitPart == Part.PIPE) {
                float scale = 0.001f;
                box = box.func_72321_a((double)scale, (double)scale, (double)scale);
            }
            return box.func_186670_a(pos);
        }
        return super.func_180640_a(state, world, pos);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            Vec3d vec3d1;
            Vec3d vec3d = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            RayTraceResult raytraceresult = field_185505_j.func_72327_a(vec3d, vec3d1 = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
            return raytraceresult == null ? null : new RayTraceResult(raytraceresult.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), raytraceresult.field_178784_b, pos);
        }
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe == null) {
            return this.func_185503_a(pos, start, end, Block.field_185505_j);
        }
        InternalRayTraceResult result = this.doRayTrace(world, pos, start, end);
        if (result == null) {
            return mcmpBlockAccess.collisionRayTrace(state, world, pos, start, end);
        }
        RayTraceResult secondResult = mcmpBlockAccess.collisionRayTrace(state, world, pos, start, end);
        if (secondResult != null && secondResult.field_72307_f.func_72438_d(start) < result.rayTraceResult.field_72307_f.func_72438_d(start)) {
            return secondResult;
        }
        return result.rayTraceResult;
    }

    public InternalRayTraceResult doRayTrace(World world, BlockPos pos, EntityPlayer player) {
        double reachDistance = 5.0;
        if (player instanceof EntityPlayerMP) {
            reachDistance = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        }
        double eyeHeight = player.func_70047_e();
        Vec3d lookVec = player.func_70040_Z();
        Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + eyeHeight, player.field_70161_v);
        Vec3d end = start.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        return this.doRayTrace(world, pos, start, end);
    }

    public InternalRayTraceResult doRayTrace(World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LogisticsTileGenericPipe) {
            LogisticsTileGenericPipe tileG = (LogisticsTileGenericPipe)te;
            CoreUnroutedPipe pipe = tileG.pipe;
            if (!LogisticsBlockGenericPipe.isValid(pipe)) {
                return null;
            }
            if (pipe.isMultiBlock()) {
                InternalRayTraceResult result1 = this.doRayTraceMultiblock(tileG, (CoreMultiBlockPipe)pipe, start, end);
                if (!pipe.actAsNormalPipe()) {
                    return result1;
                }
                InternalRayTraceResult result2 = this.doRayTrace(tileG, pipe, start, end);
                return Stream.of(result1, result2).filter(Objects::nonNull).min(Comparator.comparing(r -> r.rayTraceResult.field_72307_f.func_72436_e(start))).orElse(null);
            }
            return this.doRayTrace(tileG, pipe, start, end);
        }
        return null;
    }

    private InternalRayTraceResult doRayTrace(LogisticsTileGenericPipe tileG, CoreUnroutedPipe pipe, Vec3d start, Vec3d end) {
        if (tileG == null) {
            return null;
        }
        if (!LogisticsBlockGenericPipe.isValid(pipe)) {
            return null;
        }
        ArrayList<Hit> list = new ArrayList<Hit>();
        for (EnumFacing side : DIR_VALUES) {
            if (side != null && !tileG.isPipeConnectedCached(side) || side != null && ignoreSideRayTrace) continue;
            AxisAlignedBB bb = this.getPipeBoundingBox(side);
            list.add(new Hit(this.func_185503_a(tileG.func_174877_v(), start, end, bb), bb, side, Part.PIPE));
        }
        return list.stream().filter(r -> r.rayTraceResult != null).min(Comparator.comparing(r -> r.rayTraceResult.field_72307_f.func_72436_e(start))).map(r -> new InternalRayTraceResult(r.part, r.rayTraceResult, r.box, r.side)).orElse(null);
    }

    private InternalRayTraceResult doRayTraceMultiblock(LogisticsTileGenericPipe tileG, CoreMultiBlockPipe pipe, Vec3d start, Vec3d direction) {
        if (tileG == null) {
            return null;
        }
        if (!LogisticsBlockGenericPipe.isValid(pipe)) {
            return null;
        }
        ArrayList<RayTraceResult> hits = new ArrayList<RayTraceResult>();
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        pipe.addCollisionBoxesToList(boxes, null);
        while (hits.size() < boxes.size()) {
            hits.add(null);
        }
        for (int i = 0; i < boxes.size(); ++i) {
            AxisAlignedBB bb = (AxisAlignedBB)boxes.get(i);
            hits.set(i, super.func_185503_a(tileG.func_174877_v(), start, direction, bb.func_186670_a(BlockPos.field_177992_a.func_177973_b((Vec3i)tileG.func_174877_v()))));
        }
        return hits.stream().filter(Objects::nonNull).min(Comparator.comparing(r -> r.field_72307_f.func_72436_e(start))).map(r -> new InternalRayTraceResult(Part.PIPE, (RayTraceResult)r, pipe.getCompleteBox(), null)).orElse(null);
    }

    private AxisAlignedBB getPipeBoundingBox(@Nullable EnumFacing side) {
        if (side == null) {
            return PIPE_CENTER_BB;
        }
        return PIPE_CONN_BB.get(side.func_176745_a());
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new LogisticsTileGenericPipe();
    }

    public float func_176195_g(IBlockState state, World par1World, BlockPos pos) {
        return Configs.pipeDurability;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean canBeReplacedByLeaves(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return false;
    }

    @Override
    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            return true;
        }
        return super.isSideSolid(state, world, pos, side);
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        LogisticsBlockGenericPipe.removePipe(LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, pos));
        super.func_180663_b(world, pos, state);
    }

    public void func_180653_a(World world, final @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
        if (world.field_72995_K) {
            return;
        }
        int i1 = this.func_149745_a(world.field_73012_v);
        for (int j1 = 0; j1 < i1; ++j1) {
            if (world.field_73012_v.nextFloat() > chance) continue;
            CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, pos);
            if (pipe == null) {
                pipe = pipeRemoved.get(new DoubleCoordinates(pos));
            }
            if (pipe == null) {
                return;
            }
            if (pipe.item != null && (pipe.canBeDestroyed() || pipe.destroyByPlayer())) {
                for (ItemStack stack : pipe.dropContents()) {
                    LogisticsBlockGenericPipe.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
                }
                LogisticsBlockGenericPipe.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(pipe.item, 1, this.func_180651_a(state)));
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                final CoreUnroutedPipe finalPipe = pipe;
                BlockAccessDelegate worldDelegate = new BlockAccessDelegate((IBlockAccess)world){

                    @Override
                    public TileEntity func_175625_s(BlockPos testPos) {
                        if (pos == testPos) {
                            return finalPipe.container;
                        }
                        return super.func_175625_s(pos);
                    }
                };
                mcmpBlockAccess.addDrops(list, worldDelegate, pos, state, fortune);
                for (ItemStack stack : list) {
                    LogisticsBlockGenericPipe.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
                }
                continue;
            }
            if (pipe.item == null) continue;
            LogisticsBlockGenericPipe.cacheTileToPreventRemoval(pipe);
        }
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pick = super.getPickBlock(state, target, world, pos, player);
        if (!pick.func_190926_b()) {
            return pick;
        }
        InternalRayTraceResult rayTraceResult = this.doRayTrace(world, pos, player);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null) {
            switch (rayTraceResult.hitPart) {
                case PIPE: {
                    return new ItemStack(LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, (BlockPos)pos).item);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)worldIn, pos);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            pipe.container.scheduleNeighborChange();
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlaced();
            pipe.onBlockPlacedBy(placer);
            if (pipe instanceof IRotationProvider) {
                ((IRotationProvider)((Object)pipe)).setFacing(placer.func_174811_aO().func_176734_d());
            }
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        if (super.func_180639_a(world, pos, state, player, hand, side, xOffset, yOffset, zOffset)) {
            return true;
        }
        ItemStack heldItem = (ItemStack)player.field_71071_by.field_70462_a.get(player.field_71071_by.field_70461_c);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            if (!heldItem.func_190926_b()) {
                if (heldItem.func_77973_b() == Items.field_151155_ap) {
                    return false;
                }
                if (heldItem.func_77973_b() instanceof ItemLogisticsPipe) {
                    return false;
                }
            }
            return pipe.blockActivated(player);
        }
        return false;
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            pipe.onEntityCollidedWithBlock(entity);
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        if (super.addHitEffects(state, world, target, effectRenderer)) {
            return true;
        }
        BlockPos pos = target.func_178782_a();
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (pipe == null) {
            return false;
        }
        TextureAtlasSprite icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        EnumFacing sideHit = target.field_178784_b;
        LogisticsBlockGenericPipe block = LPBlocks.pipe;
        float b = 0.1f;
        double px = target.field_72307_f.field_72450_a + this.rand.nextDouble() * (state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72336_d - state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72340_a - (double)(b * 2.0f)) + (double)b + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72340_a;
        double py = target.field_72307_f.field_72448_b + this.rand.nextDouble() * (state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e - state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72338_b - (double)(b * 2.0f)) + (double)b + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72338_b;
        double pz = target.field_72307_f.field_72449_c + this.rand.nextDouble() * (state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72334_f - state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72339_c - (double)(b * 2.0f)) + (double)b + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72339_c;
        if (sideHit == EnumFacing.DOWN) {
            py = target.field_72307_f.field_72448_b + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72338_b - (double)b;
        }
        if (sideHit == EnumFacing.UP) {
            py = target.field_72307_f.field_72448_b + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e + (double)b;
        }
        if (sideHit == EnumFacing.NORTH) {
            pz = target.field_72307_f.field_72449_c + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72339_c - (double)b;
        }
        if (sideHit == EnumFacing.SOUTH) {
            pz = target.field_72307_f.field_72449_c + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72334_f + (double)b;
        }
        if (sideHit == EnumFacing.EAST) {
            px = target.field_72307_f.field_72450_a + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72340_a - (double)b;
        }
        if (sideHit == EnumFacing.WEST) {
            px = target.field_72307_f.field_72450_a + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72336_d + (double)b;
        }
        Particle fx = effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), px, py, pz, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)world.func_180495_p(target.func_178782_a()))});
        fx.func_187117_a(icon);
        effectRenderer.func_78873_a(fx.func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        if (super.addDestroyEffects(world, pos, effectRenderer)) {
            return true;
        }
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (pipe == null) {
            return false;
        }
        ClientConfiguration config = LogisticsPipes.getClientPlayerConfig();
        LogisticsNewRenderPipe.renderDestruction(pipe, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), effectRenderer);
        return true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IProperty[]{rotationProperty});
        builder.add(new IProperty[]{modelTypeProperty});
        connectionPropertys.values().forEach(xva$0 -> builder.add(new IProperty[]{xva$0}));
        builder.add(new IUnlistedProperty[]{propertyRenderList});
        builder.add(new IUnlistedProperty[]{propertyCache});
        mcmpBlockAccess.addBlockState(builder);
        return builder.build();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        this.checkForRenderChanges(worldIn, pos);
        state = super.func_176221_a(state, worldIn, pos);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe(worldIn, pos);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            if (pipe instanceof IRotationProvider) {
                state = state.func_177226_a((IProperty)rotationProperty, (Comparable)Integer.valueOf(((IRotationProvider)((Object)pipe)).getRotation()));
            }
            for (EnumFacing side : EnumFacing.field_82609_l) {
                state = state.func_177226_a((IProperty)connectionPropertys.get(side), (Comparable)Boolean.valueOf(pipe.container.renderState.pipeConnectionMatrix.isConnected(side)));
            }
            if (pipe instanceof PipeBlockRequestTable) {
                state = state.func_177226_a(modelTypeProperty, (Comparable)((Object)PipeRenderModel.REQUEST_TABLE));
            }
        }
        return state;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = mcmpBlockAccess.getExtendedState(state, worldIn, pos);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe(worldIn, pos);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            LogisticsNewRenderPipe.checkAndCalculateRenderCache(pipe.container);
            state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)propertyRenderList, pipe.container.renderState.cachedRenderer);
            state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)propertyCache, pipe.container.renderState.objectCache);
        } else {
            state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)propertyRenderList, LogisticsNewRenderPipe.getBasicPipeFrameRenderList());
        }
        return state;
    }

    private void checkForRenderChanges(IBlockAccess worldIn, BlockPos blockPos) {
        TileEntity tile = new DoubleCoordinates(blockPos).getTileEntity(worldIn);
        if (!(tile instanceof LogisticsTileGenericPipe)) {
            return;
        }
        ((LogisticsTileGenericPipe)tile).renderState.checkForRenderUpdate(worldIn, blockPos);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    static {
        LogisticsBlockGenericPipe.DIR_VALUES[0] = null;
        System.arraycopy(EnumFacing.field_82609_l, 0, DIR_VALUES, 1, EnumFacing.field_82609_l.length);
    }

    public static class InternalRayTraceResult {
        public final Part hitPart;
        public final RayTraceResult rayTraceResult;
        public final AxisAlignedBB boundingBox;
        public final EnumFacing sideHit;

        InternalRayTraceResult(Part hitPart, RayTraceResult rayTraceResult, AxisAlignedBB boundingBox, EnumFacing side) {
            this.hitPart = hitPart;
            this.rayTraceResult = rayTraceResult;
            this.boundingBox = boundingBox;
            this.sideHit = side;
        }

        public String toString() {
            return String.format("RayTraceResult: %s, %s", this.hitPart == null ? "null" : this.hitPart.name(), this.boundingBox == null ? "null" : this.boundingBox.toString());
        }
    }

    public static enum Part {
        PIPE,
        UNKNOWN;

    }

    private static class Hit {
        public RayTraceResult rayTraceResult;
        public AxisAlignedBB box;
        public EnumFacing side;
        public Part part;

        public RayTraceResult getRayTraceResult() {
            return this.rayTraceResult;
        }

        public AxisAlignedBB getBox() {
            return this.box;
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public Part getPart() {
            return this.part;
        }

        public Hit setRayTraceResult(RayTraceResult rayTraceResult) {
            this.rayTraceResult = rayTraceResult;
            return this;
        }

        public Hit setBox(AxisAlignedBB box) {
            this.box = box;
            return this;
        }

        public Hit setSide(EnumFacing side) {
            this.side = side;
            return this;
        }

        public Hit setPart(Part part) {
            this.part = part;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Hit)) {
                return false;
            }
            Hit other = (Hit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RayTraceResult this$rayTraceResult = this.getRayTraceResult();
            RayTraceResult other$rayTraceResult = other.getRayTraceResult();
            if (this$rayTraceResult == null ? other$rayTraceResult != null : !this$rayTraceResult.equals(other$rayTraceResult)) {
                return false;
            }
            AxisAlignedBB this$box = this.getBox();
            AxisAlignedBB other$box = other.getBox();
            if (this$box == null ? other$box != null : !this$box.equals(other$box)) {
                return false;
            }
            EnumFacing this$side = this.getSide();
            EnumFacing other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            Part this$part = this.getPart();
            Part other$part = other.getPart();
            return !(this$part == null ? other$part != null : !((Object)((Object)this$part)).equals((Object)other$part));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Hit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RayTraceResult $rayTraceResult = this.getRayTraceResult();
            result = result * 59 + ($rayTraceResult == null ? 43 : $rayTraceResult.hashCode());
            AxisAlignedBB $box = this.getBox();
            result = result * 59 + ($box == null ? 43 : $box.hashCode());
            EnumFacing $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            Part $part = this.getPart();
            result = result * 59 + ($part == null ? 43 : ((Object)((Object)$part)).hashCode());
            return result;
        }

        public String toString() {
            return "LogisticsBlockGenericPipe.Hit(rayTraceResult=" + this.getRayTraceResult() + ", box=" + this.getBox() + ", side=" + this.getSide() + ", part=" + (Object)((Object)this.getPart()) + ")";
        }

        @ConstructorProperties(value={"rayTraceResult", "box", "side", "part"})
        public Hit(RayTraceResult rayTraceResult, AxisAlignedBB box, EnumFacing side, Part part) {
            this.rayTraceResult = rayTraceResult;
            this.box = box;
            this.side = side;
            this.part = part;
        }
    }

    public static enum PipeRenderModel implements IStringSerializable
    {
        NONE,
        REQUEST_TABLE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

