/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic.ltgpmodcompat;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import logisticspipes.asm.ModDependentInterface;
import logisticspipes.asm.ModDependentMethod;
import logisticspipes.proxy.SimpleServiceLocator;
import mcmultipart.MCMultiPart;
import mcmultipart.RayTraceHelper;
import mcmultipart.api.container.IMultipartContainerBlock;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.block.TileMultipartContainer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.proxy.mcmp.subproxy.IMCMPBlockAccess;
import org.apache.commons.lang3.tuple.Pair;

@ModDependentInterface(modId={"mcmultipart"}, interfacePath={"mcmultipart.api.container.IMultipartContainerBlock"})
public abstract class LPMicroblockBlock
extends BlockContainer
implements IMultipartContainerBlock {
    public static IMCMPBlockAccess mcmpBlockAccess = SimpleServiceLocator.mcmpProxy.createMCMPBlockAccess();

    public LPMicroblockBlock(Material materialIn) {
        super(materialIn);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.getWeakChanges(world, pos) : super.getWeakChanges(world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean isFertile(@Nonnull World world, @Nonnull BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isFertile(world, pos) : super.isFertile(world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, double yToTest, Material material, boolean testingHead) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isEntityInsideMaterial(world, pos, state, entity, yToTest, material, testingHead) : super.isEntityInsideMaterial(world, pos, state, entity, yToTest, material, testingHead);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.func_176205_b(world, pos) : super.func_176205_b(world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public void onPlantGrow(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, BlockPos source) {
        Block block = mcmpBlockAccess.getBlock();
        if (block != null) {
            block.onPlantGrow(state, world, pos, source);
        } else {
            super.onPlantGrow(state, world, pos, source);
        }
    }

    @ModDependentMethod(modId="mcmultipart")
    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.func_176211_b(state, world, pos, side) : super.func_176211_b(state, world, pos, side);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean func_149653_t() {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.func_149653_t() : super.func_149653_t();
    }

    @ModDependentMethod(modId="mcmultipart")
    public Boolean isAABBInsideMaterial(World world, BlockPos pos, AxisAlignedBB boundingBox, Material material) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isAABBInsideMaterial(world, pos, boundingBox, material) : super.isAABBInsideMaterial(world, pos, boundingBox, material);
    }

    @ModDependentMethod(modId="mcmultipart")
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        Block block = mcmpBlockAccess.getBlock();
        if (block != null) {
            block.func_180655_c(state, world, pos, rand);
        } else {
            super.func_180655_c(state, world, pos, rand);
        }
    }

    @ModDependentMethod(modId="mcmultipart")
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        Block block = mcmpBlockAccess.getBlock();
        if (block != null) {
            block.func_180634_a(world, pos, state, entity);
        } else {
            super.func_180634_a(world, pos, state, entity);
        }
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean func_190946_v(IBlockState state) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.func_190946_v(state) : super.func_190946_v(state);
    }

    @ModDependentMethod(modId="mcmultipart")
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        Block block = mcmpBlockAccess.getBlock();
        if (block != null) {
            block.func_180650_b(world, pos, state, rand);
        } else {
            super.func_180650_b(world, pos, state, rand);
        }
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isBurning(world, pos) : super.isBurning(world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.canSustainLeaves(state, world, pos) : super.canSustainLeaves(state, world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.func_180641_l(blockState, world, pos) : super.func_180641_l(blockState, world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public void func_180645_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
        Block block = mcmpBlockAccess.getBlock();
        if (block != null) {
            block.func_180645_a(world, pos, state, random);
        } else {
            super.func_180645_a(world, pos, state, random);
        }
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isSideSolid(state, world, pos, side) : super.isSideSolid(state, world, pos, side);
    }

    @ModDependentMethod(modId="mcmultipart")
    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.getLightOpacity(state, world, pos) : super.getLightOpacity(state, world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public float getEnchantPowerBonus(World world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.getEnchantPowerBonus(world, pos) : super.getEnchantPowerBonus(world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isLadder(state, world, pos, entity) : super.isLadder(state, world, pos, entity);
    }

    @Nonnull
    @ModDependentMethod(modId="mcmultipart")
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.func_193383_a(world, state, pos, face) : super.func_193383_a(world, state, pos, face);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isLeaves(state, world, pos) : super.isLeaves(state, world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.getExplosionResistance(world, pos, exploder, explosion) : super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @ModDependentMethod(modId="mcmultipart")
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        Block block = mcmpBlockAccess.getBlock();
        if (block != null) {
            block.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        } else {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        }
    }

    @ModDependentMethod(modId="mcmultipart")
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.getLightValue(state, world, pos) : super.getLightValue(state, world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isFoliage(world, pos) : super.isFoliage(world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.canConnectRedstone(state, world, pos, side) : super.canConnectRedstone(state, world, pos, side);
    }

    @ModDependentMethod(modId="mcmultipart")
    public void func_176224_k(World world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        if (block != null) {
            block.func_176224_k(world, pos);
        } else {
            super.func_176224_k(world, pos);
        }
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isBeaconBase(world, pos, beacon) : super.isBeaconBase(world, pos, beacon);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isFlammable(world, pos, face) : super.isFlammable(world, pos, face);
    }

    @ModDependentMethod(modId="mcmultipart")
    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.func_180656_a(state, world, pos, side) : super.func_180656_a(state, world, pos, side);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, BlockPos pos, @Nonnull EnumFacing direction, IPlantable plantable) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.canSustainPlant(state, world, pos, direction, plantable) : super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean isWood(IBlockAccess world, BlockPos pos) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isWood(world, pos) : super.isWood(world, pos);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean canCreatureSpawn(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EntityLiving.SpawnPlacementType type) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.canCreatureSpawn(state, world, pos, type) : super.canCreatureSpawn(state, world, pos, type);
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean isFireSource(@Nonnull World world, BlockPos pos, EnumFacing side) {
        Block block = mcmpBlockAccess.getBlock();
        return block != null ? block.isFireSource(world, pos, side) : super.isFireSource(world, pos, side);
    }

    @ModDependentMethod(modId="mcmultipart")
    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        Block block = mcmpBlockAccess.getBlock();
        if (block != null) {
            block.onNeighborChange(world, pos, neighbor);
        } else {
            super.onNeighborChange(world, pos, neighbor);
        }
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        Pair vectors = RayTraceHelper.getRayTraceVectors((EntityPlayer)player);
        RayTraceResult hit = this.func_180636_a(state, world, pos, (Vec3d)vectors.getLeft(), (Vec3d)vectors.getRight());
        Optional tile = BlockMultipartContainer.getTile((IBlockAccess)world, (BlockPos)pos);
        if (hit != null && tile.isPresent() && hit.subHit >= 0 && !world.field_72995_K) {
            IPartSlot slot = (IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit);
            boolean canRemove = ((TileMultipartContainer)tile.get()).get(slot).map(i -> {
                if (i.getPart().canPlayerDestroy(i, player)) {
                    i.getPart().onPartHarvested(i, player);
                    if (player == null || !player.field_71075_bZ.field_75098_d) {
                        i.getPart().getDrops((IBlockAccess)i.getPartWorld(), pos, i, 0).forEach(s -> LPMicroblockBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)s));
                    }
                    return true;
                }
                return false;
            }).orElse(true);
            if (canRemove) {
                ((TileMultipartContainer)tile.get()).removePart(slot);
            }
        }
        if (hit != null && hit.subHit == -1) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return false;
    }

    @ModDependentMethod(modId="mcmultipart")
    public float func_180647_a(IBlockState state, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        Pair vectors = RayTraceHelper.getRayTraceVectors((EntityPlayer)player);
        RayTraceResult hit = this.func_180636_a(this.func_176223_P(), world, pos, (Vec3d)vectors.getLeft(), (Vec3d)vectors.getRight());
        if (hit != null && hit.subHit >= 0) {
            return BlockMultipartContainer.getTile((IBlockAccess)world, (BlockPos)pos).map(t -> (IPartInfo)t.get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit)).get()).map(i -> Float.valueOf(i.getPart().getPlayerRelativePartHardness(i, (RayTraceResult)hit.hitInfo, player))).orElse(Float.valueOf(0.0f)).floatValue();
        }
        if (hit != null) {
            return super.func_180647_a(state, player, world, pos);
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    @ModDependentMethod(modId="mcmultipart")
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        Pair vectors = RayTraceHelper.getRayTraceVectors((EntityPlayer)MCMultiPart.proxy.getPlayer());
        RayTraceResult hit = this.func_180636_a(this.func_176223_P(), world, pos, (Vec3d)vectors.getLeft(), (Vec3d)vectors.getRight());
        if (hit != null && hit.subHit >= 0) {
            IPartInfo part = (IPartInfo)((TileMultipartContainer)BlockMultipartContainer.getTile((IBlockAccess)world, (BlockPos)pos).get()).get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit)).get();
            if (!part.getPart().addDestroyEffects(part, manager)) {
                IBlockState state = part.getPart().getActualState((IBlockAccess)part.getPartWorld(), pos, part);
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        for (int k = 0; k < 4; ++k) {
                            double xOff = ((double)i + 0.5) / 4.0;
                            double yOff = ((double)j + 0.5) / 4.0;
                            double zOff = ((double)k + 0.5) / 4.0;
                            manager.func_78873_a((Particle)new ParticleDigging(world, (double)pos.func_177958_n() + xOff, (double)pos.func_177956_o() + yOff, (double)pos.func_177952_p() + zOff, xOff - 0.5, yOff - 0.5, zOff - 0.5, state){}.func_174846_a(pos));
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @ModDependentMethod(modId="mcmultipart")
    public boolean addHitEffects(IBlockState mpState, World world, RayTraceResult hit, ParticleManager manager) {
        if (hit != null && hit.subHit >= 0) {
            BlockPos pos = hit.func_178782_a();
            IPartInfo part = (IPartInfo)((TileMultipartContainer)BlockMultipartContainer.getTile((IBlockAccess)world, (BlockPos)pos).get()).get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit)).get();
            if (!part.getPart().addHitEffects(part, (RayTraceResult)hit.hitInfo, manager) && part.getPart().getRenderType(part) != EnumBlockRenderType.INVISIBLE) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                AxisAlignedBB aabb = part.getPart().getBoundingBox(part);
                double pX = (double)x + world.field_73012_v.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a - 0.2) + 0.1 + aabb.field_72340_a;
                double pY = (double)y + world.field_73012_v.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b - 0.2) + 0.1 + aabb.field_72338_b;
                double pZ = (double)z + world.field_73012_v.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c - 0.2) + 0.1 + aabb.field_72339_c;
                switch (hit.field_178784_b) {
                    case DOWN: {
                        pY = (double)y + aabb.field_72338_b - 0.1;
                        break;
                    }
                    case UP: {
                        pY = (double)y + aabb.field_72337_e + 0.1;
                        break;
                    }
                    case NORTH: {
                        pZ = (double)z + aabb.field_72339_c - 0.1;
                        break;
                    }
                    case SOUTH: {
                        pZ = (double)z + aabb.field_72334_f + 0.1;
                        break;
                    }
                    case WEST: {
                        pX = (double)x + aabb.field_72340_a - 0.1;
                        break;
                    }
                    case EAST: {
                        pX = (double)x + aabb.field_72336_d + 0.1;
                    }
                }
                manager.func_78873_a(new ParticleDigging(world, pX, pY, pZ, 0.0, 0.0, 0.0, part.getPart().getActualState((IBlockAccess)part.getPartWorld(), pos, part)){}.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
            }
            return true;
        }
        return false;
    }

    @Nonnull
    @ModDependentMethod(modId="mcmultipart")
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult hit, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        if (hit != null && hit.subHit >= 0) {
            return BlockMultipartContainer.getTile((IBlockAccess)world, (BlockPos)pos).map(t -> t.get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit))).filter(Optional::isPresent).map(o -> ((IPartInfo)o.get()).getPart().getPickPart((IPartInfo)o.get(), (RayTraceResult)hit.hitInfo, player)).orElse(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    @ModDependentMethod(modId="mcmultipart")
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Pair vectors = RayTraceHelper.getRayTraceVectors((EntityPlayer)player);
        RayTraceResult hit = this.func_180636_a(this.func_176223_P(), world, pos, (Vec3d)vectors.getLeft(), (Vec3d)vectors.getRight());
        if (hit != null && hit.subHit >= 0) {
            return BlockMultipartContainer.getTile((IBlockAccess)world, (BlockPos)pos).map(t -> (IPartInfo)t.get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit)).get()).map(i -> i.getPart().onPartActivated(i, player, hand, (RayTraceResult)hit.hitInfo)).orElse(false);
        }
        return false;
    }

    @ModDependentMethod(modId="mcmultipart")
    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        Pair vectors = RayTraceHelper.getRayTraceVectors((EntityPlayer)player);
        RayTraceResult hit = this.func_180636_a(this.func_176223_P(), world, pos, (Vec3d)vectors.getLeft(), (Vec3d)vectors.getRight());
        if (hit != null && hit.subHit >= 0) {
            BlockMultipartContainer.getTile((IBlockAccess)world, (BlockPos)pos).map(t -> (IPartInfo)t.get((IPartSlot)MCMultiPart.slotRegistry.getValue(hit.subHit)).get()).ifPresent(i -> i.getPart().onPartClicked(i, player, (RayTraceResult)hit.hitInfo));
        }
    }
}

