/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.tubes;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.interfaces.ITubeRenderOrientation;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.tube.GainTubeRenderer;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeMultiBlockTransportLogistics;
import logisticspipes.utils.IPositionRotateble;
import logisticspipes.utils.LPPositionSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.DoubleCoordinatesType;

public class HSTubeGain
extends CoreMultiBlockPipe {
    private TubeGainOrientation orientation;
    private List<AxisAlignedBB> boxes = null;

    public HSTubeGain(Item item) {
        super(new PipeMultiBlockTransportLogistics(), item);
    }

    @Override
    public void writeData(LPDataOutput output) {
        if (this.orientation == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeEnum(this.orientation);
        }
    }

    @Override
    public void readData(LPDataInput input) {
        if (input.readBoolean()) {
            this.orientation = input.readEnum(TubeGainOrientation.class);
        }
    }

    @Override
    public LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> getSubBlocks() {
        LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> list = new LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>>(DoubleCoordinatesType.class);
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 0.0, -1.0, CoreMultiBlockPipe.SubBlockTypeForShare.GAIN_B));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 0.0, -2.0, CoreMultiBlockPipe.SubBlockTypeForShare.GAIN_A));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 1.0, -1.0, CoreMultiBlockPipe.SubBlockTypeForShare.GAIN_A));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 1.0, -2.0, CoreMultiBlockPipe.SubBlockTypeForShare.GAIN_B));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 1.0, -3.0, CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
        return list;
    }

    @Override
    public LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> getRotatedSubBlocks() {
        LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> set = this.getSubBlocks();
        this.orientation.rotatePositions(set);
        return set;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74778_a("orientation", this.orientation.name());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.orientation = TubeGainOrientation.valueOf(data.func_74779_i("orientation"));
    }

    @Override
    public void addCollisionBoxesToList(List<AxisAlignedBB> arraylist, AxisAlignedBB axisalignedbb) {
        if (this.boxes == null || this.boxes.isEmpty()) {
            this.boxes = new ArrayList<AxisAlignedBB>();
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            for (int i = -1; i < 54; ++i) {
                double xOne = x;
                double yOne = y;
                double zOne = z;
                double xTwo = x;
                double yTwo = y + 2.0;
                double zTwo = z;
                if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.SOUTH) {
                    zOne += (double)(4.0f * (float)(i - 4) / 50.0f);
                    zTwo += (double)(4.0f * (float)(i + 4) / 50.0f);
                    xOne += 1.0;
                    xTwo -= 2.0;
                } else if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.WEST) {
                    xOne -= 3.0;
                    xTwo -= 3.0;
                    xOne += (double)(4.0f * (float)(i - 4) / 50.0f);
                    xTwo += (double)(4.0f * (float)(i + 4) / 50.0f);
                    zOne -= 1.0;
                    zTwo += 2.0;
                } else if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.NORTH) {
                    zOne += 1.0;
                    zTwo += 1.0;
                    zOne -= (double)(4.0f * (float)(i - 4) / 50.0f);
                    zTwo -= (double)(4.0f * (float)(i + 4) / 50.0f);
                    xOne -= 1.0;
                    xTwo += 2.0;
                } else if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.EAST) {
                    xOne += 4.0;
                    xTwo += 4.0;
                    xOne -= (double)(4.0f * (float)(i - 4) / 50.0f);
                    xTwo -= (double)(4.0f * (float)(i + 4) / 50.0f);
                    zOne -= 1.0;
                    zTwo += 2.0;
                }
                AxisAlignedBB box2 = GainTubeRenderer.getObjectBoundsAt(new AxisAlignedBB(Math.min(xOne, xTwo), Math.min(yOne, yTwo), Math.min(zOne, zTwo), Math.max(xOne, xTwo), Math.max(yOne, yTwo), Math.max(zOne, zTwo)).func_72317_d(-x, -y, -z), this.orientation);
                if (box2 == null) continue;
                LPPositionSet lpBox = new LPPositionSet(DoubleCoordinates.class);
                lpBox.addFrom(box2);
                DoubleCoordinates center = lpBox.getCenter();
                box2 = new AxisAlignedBB(center.getXCoord() - 0.3, center.getYCoord() - 0.3, center.getZCoord() - 0.3, center.getXCoord() + 0.3, center.getYCoord() + 0.3, center.getZCoord() + 0.3);
                AxisAlignedBB cBox = this.getCompleteBox();
                double minX = Math.max(box2.field_72340_a, cBox.field_72340_a);
                double minY = Math.max(box2.field_72338_b, cBox.field_72338_b);
                double minZ = Math.max(box2.field_72339_c, cBox.field_72339_c);
                double maxX = Math.min(box2.field_72336_d, cBox.field_72336_d);
                double maxY = Math.min(box2.field_72337_e, cBox.field_72337_e);
                double maxZ = Math.min(box2.field_72334_f, cBox.field_72334_f);
                this.boxes.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ).func_72317_d(x, y, z));
            }
        }
        arraylist.addAll(this.boxes.stream().filter(box -> box != null && (axisalignedbb == null || axisalignedbb.func_72326_a(box))).collect(Collectors.toList()));
    }

    @Override
    public AxisAlignedBB getCompleteBox() {
        return GainTubeRenderer.tubeGain.get(this.orientation.getRenderOrientation()).bounds().toAABB();
    }

    @Override
    public ITubeOrientation getTubeOrientation(EntityPlayer player, int xPos, int zPos) {
        double x = (double)xPos + 0.5 - player.field_70165_t;
        double z = (double)zPos + 0.5 - player.field_70161_v;
        double w = Math.atan2(x, z);
        double halfPI = 1.5707963267948966;
        double halfhalfPI = halfPI / 2.0;
        if ((w -= halfhalfPI) < 0.0) {
            w += Math.PI * 2;
        }
        EnumFacing dir = null;
        if (0.0 < w && w <= halfPI) {
            dir = EnumFacing.EAST;
        } else if (halfPI < w && w <= 2.0 * halfPI) {
            dir = EnumFacing.NORTH;
        } else if (2.0 * halfPI < w && w <= 3.0 * halfPI) {
            dir = EnumFacing.WEST;
        } else if (3.0 * halfPI < w && w <= 4.0 * halfPI) {
            dir = EnumFacing.SOUTH;
        }
        for (TubeGainOrientation ori : TubeGainOrientation.values()) {
            if (!ori.dir.equals((Object)dir)) continue;
            return ori;
        }
        return null;
    }

    @Override
    public float getPipeLength() {
        return 4.0f;
    }

    @Override
    public EnumFacing getExitForInput(EnumFacing commingFrom) {
        if (this.orientation.dir.func_176734_d() == commingFrom) {
            return this.orientation.dir;
        }
        if (this.orientation.dir == commingFrom) {
            return this.orientation.dir.func_176734_d();
        }
        return null;
    }

    @Override
    public TileEntity getConnectedEndTile(EnumFacing output) {
        if (this.orientation.dir.func_176734_d() == output) {
            return this.container.getTile(output);
        }
        DoubleCoordinates pos = new DoubleCoordinates(0.0, 1.0, -3.0);
        LPPositionSet set = new LPPositionSet(DoubleCoordinates.class);
        set.add(pos);
        this.orientation.rotatePositions(set);
        TileEntity subTile = pos.add(this.getLPPosition()).getTileEntity((IBlockAccess)this.getWorld());
        if (subTile instanceof LogisticsTileGenericSubMultiBlock) {
            return ((LogisticsTileGenericSubMultiBlock)subTile).getTile(output);
        }
        return null;
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        return 0;
    }

    @Override
    public int getTextureIndex() {
        return 0;
    }

    @Override
    public boolean actAsNormalPipe() {
        return false;
    }

    @Override
    public ISpecialPipeRenderer getSpecialRenderer() {
        return GainTubeRenderer.instance;
    }

    @Override
    public IHighlightPlacementRenderer getHighlightRenderer() {
        return GainTubeRenderer.instance;
    }

    @Override
    public DoubleCoordinates getItemRenderPos(float fPos, LPTravelingItem travelItem) {
        if (this.orientation.getDir().func_176734_d() == travelItem.input == (this.orientation.getOffset().getLength() != 0.0)) {
            fPos = this.transport.getPipeLength() - fPos;
        }
        float x = 0.5f;
        float y = 1.5f;
        float z = 0.5f;
        if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.SOUTH) {
            z -= fPos;
            z += 3.5f;
            y -= 0.0f;
            double a = fPos / this.transport.getPipeLength() * 3.0f;
            double b = -0.030238483815369 * Math.pow(a, 5.0) + 0.225914176523007 * Math.pow(a, 4.0) - 0.502711673373567 * Math.pow(a, 3.0) + 0.233256545765967 * Math.pow(a, 2.0) - 0.074807924321475 * a + 9.9653425518E-5;
            y = (float)((double)y + b * (double)this.transport.getPipeLength() / 3.0);
        } else if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.NORTH) {
            z += fPos;
            z -= 3.5f;
            x -= 0.0f;
            double a = fPos / this.transport.getPipeLength() * 3.0f;
            double b = -0.030238483815369 * Math.pow(a, 5.0) + 0.225914176523007 * Math.pow(a, 4.0) - 0.502711673373567 * Math.pow(a, 3.0) + 0.233256545765967 * Math.pow(a, 2.0) - 0.074807924321475 * a + 9.9653425518E-5;
            y = (float)((double)y + b * (double)this.transport.getPipeLength() / 3.0);
        } else if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.WEST) {
            x += fPos;
            x -= 3.5f;
            z -= 0.0f;
            double a = fPos / this.transport.getPipeLength() * 3.0f;
            double b = -0.030238483815369 * Math.pow(a, 5.0) + 0.225914176523007 * Math.pow(a, 4.0) - 0.502711673373567 * Math.pow(a, 3.0) + 0.233256545765967 * Math.pow(a, 2.0) - 0.074807924321475 * a + 9.9653425518E-5;
            y = (float)((double)y + b * (double)this.transport.getPipeLength() / 3.0);
        } else if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.EAST) {
            x -= fPos;
            x += 3.5f;
            z += 0.0f;
            double a = fPos / this.transport.getPipeLength() * 3.0f;
            double b = -0.030238483815369 * Math.pow(a, 5.0) + 0.225914176523007 * Math.pow(a, 4.0) - 0.502711673373567 * Math.pow(a, 3.0) + 0.233256545765967 * Math.pow(a, 2.0) - 0.074807924321475 * a + 9.9653425518E-5;
            y = (float)((double)y + b * (double)this.transport.getPipeLength() / 3.0);
        }
        return new DoubleCoordinates(x, y, z);
    }

    @Override
    public double getItemRenderYaw(float fPos, LPTravelingItem travelItem) {
        boolean condition = this.orientation.getRenderOrientation() == TubeGainRenderOrientation.NORTH || this.orientation.getRenderOrientation() == TubeGainRenderOrientation.SOUTH;
        return condition ? 0.0 : 90.0;
    }

    @Override
    public double getItemRenderPitch(float fPos, LPTravelingItem travelItem) {
        double b;
        if (this.orientation.getDir().func_176734_d() == travelItem.input == (this.orientation.getOffset().getLength() != 0.0)) {
            fPos = this.transport.getPipeLength() - fPos;
        }
        if ((double)fPos < 0.5) {
            double a = 0.5 / (double)this.transport.getPipeLength() * 3.0;
            b = -0.15119241907684 * Math.pow(a, 4.0) + 0.903656706092028 * Math.pow(a, 3.0) - 1.5081350201207 * Math.pow(a, 2.0) + 0.466513091531934 * a - 0.074807924321475;
            b = b * (double)this.transport.getPipeLength() * -13.0;
            b = b * (double)fPos / 0.5;
        } else if ((double)fPos < 3.5) {
            double a = fPos / this.transport.getPipeLength() * 3.0f;
            b = -0.15119241907684 * Math.pow(a, 4.0) + 0.903656706092028 * Math.pow(a, 3.0) - 1.5081350201207 * Math.pow(a, 2.0) + 0.466513091531934 * a - 0.074807924321475;
            b = b * (double)this.transport.getPipeLength() * -13.0;
        } else {
            double a = 3.5 / (double)this.transport.getPipeLength() * 3.0;
            b = -0.15119241907684 * Math.pow(a, 4.0) + 0.903656706092028 * Math.pow(a, 3.0) - 1.5081350201207 * Math.pow(a, 2.0) + 0.466513091531934 * a - 0.074807924321475;
            b = b * (double)this.transport.getPipeLength() * -13.0;
            b = b * (double)(this.transport.getPipeLength() - fPos) / ((double)this.transport.getPipeLength() - 3.5);
        }
        if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.NORTH) {
            return b;
        }
        if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.SOUTH) {
            return -b;
        }
        if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.EAST) {
            return -b;
        }
        if (this.orientation.getRenderOrientation() == TubeGainRenderOrientation.WEST) {
            return b;
        }
        return 0.0;
    }

    @Override
    public double getBoxRenderScale(float fPos, LPTravelingItem travelItem) {
        return 1.0;
    }

    @Override
    public boolean isHSTube() {
        return true;
    }

    public TubeGainOrientation getOrientation() {
        return this.orientation;
    }

    public static enum TubeGainRenderOrientation implements ITubeRenderOrientation
    {
        NORTH(EnumFacing.NORTH),
        SOUTH(EnumFacing.SOUTH),
        WEST(EnumFacing.WEST),
        EAST(EnumFacing.EAST);

        private EnumFacing dir;

        private TubeGainRenderOrientation(EnumFacing dir) {
            this.dir = dir;
        }

        public void rotateOrientation(IPositionRotateble set) {
            if (this == EAST) {
                set.rotateRight();
            } else if (this == WEST) {
                set.rotateLeft();
            } else if (this == SOUTH) {
                set.rotateLeft();
                set.rotateLeft();
            }
        }

        public EnumFacing getDir() {
            return this.dir;
        }
    }

    public static enum TubeGainOrientation implements ITubeOrientation
    {
        NORTH(TubeGainRenderOrientation.NORTH, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.NORTH),
        SOUTH(TubeGainRenderOrientation.SOUTH, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.SOUTH),
        EAST(TubeGainRenderOrientation.EAST, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.EAST),
        WEST(TubeGainRenderOrientation.WEST, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.WEST);

        TubeGainRenderOrientation renderOrientation;
        DoubleCoordinates offset;
        EnumFacing dir;

        private TubeGainOrientation(TubeGainRenderOrientation render, DoubleCoordinates off, EnumFacing dir) {
            this.renderOrientation = render;
            this.offset = off;
            this.dir = dir;
        }

        @Override
        public void rotatePositions(IPositionRotateble set) {
            this.renderOrientation.rotateOrientation(set);
        }

        @Override
        public void setOnPipe(CoreMultiBlockPipe pipe) {
            ((HSTubeGain)pipe).orientation = this;
        }

        @Override
        public TubeGainRenderOrientation getRenderOrientation() {
            return this.renderOrientation;
        }

        @Override
        public DoubleCoordinates getOffset() {
            return this.offset;
        }

        public EnumFacing getDir() {
            return this.dir;
        }
    }
}

