/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy;

import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import logisticspipes.LPItems;
import logisticspipes.LogisticsEventListener;
import logisticspipes.LogisticsPipes;
import logisticspipes.entity.FakePlayerLP;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.PacketInboundHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.IProxy;
import logisticspipes.routing.debug.RoutingTableDebugUpdateThread;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.ticks.RoutingTableUpdateThread;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.PlayerCollectionList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class MainProxy {
    @SidedProxy(clientSide="logisticspipes.proxy.side.ClientProxy", serverSide="logisticspipes.proxy.side.ServerProxy")
    public static IProxy proxy;
    private static int globalTick;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    private static WeakHashMap<Thread, Side> threadSideMap;
    private static Map<Integer, FakePlayerLP> fakePlayers;
    public static final String networkChannelName = "LogisticsPipes";

    private MainProxy() {
    }

    private static Side getEffectiveSide() {
        Thread thr = Thread.currentThread();
        if (threadSideMap.containsKey(thr)) {
            return threadSideMap.get(thr);
        }
        Side side = MainProxy.getEffectiveSide(thr);
        if (threadSideMap.size() > 50) {
            threadSideMap.clear();
        }
        threadSideMap.put(thr, side);
        return side;
    }

    private static Side getEffectiveSide(Thread thr) {
        if (thr.getName().equals("Server thread") || thr instanceof RoutingTableUpdateThread || thr instanceof RoutingTableDebugUpdateThread) {
            return Side.SERVER;
        }
        if (SimpleServiceLocator.ccProxy != null && SimpleServiceLocator.ccProxy.isLuaThread(thr)) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    public static boolean isClient(IBlockAccess blockAccess) {
        if (blockAccess instanceof World) {
            World world = (World)blockAccess;
            try {
                return world.field_72995_K;
            }
            catch (NullPointerException n) {
                LogisticsPipes.log.fatal("isClient called with a null world - using slow thread based fallback");
                n.printStackTrace();
            }
        }
        return MainProxy.isClient();
    }

    @Deprecated
    public static boolean isClient() {
        return MainProxy.getEffectiveSide() == Side.CLIENT;
    }

    public static boolean isServer(IBlockAccess blockAccess) {
        if (blockAccess instanceof World) {
            World world = (World)blockAccess;
            try {
                return !world.field_72995_K;
            }
            catch (NullPointerException n) {
                LogisticsPipes.log.fatal("isServer called with a null world - using slow thread based fallback");
                n.printStackTrace();
            }
        }
        return MainProxy.isServer();
    }

    @Deprecated
    public static boolean isServer() {
        return MainProxy.getEffectiveSide() == Side.SERVER;
    }

    public static World getClientMainWorld() {
        return proxy.getWorld();
    }

    public static void createChannels() {
        channels = NetworkRegistry.INSTANCE.newChannel(networkChannelName, new ChannelHandler[]{new PacketHandler()});
        for (Side side : Side.values()) {
            FMLEmbeddedChannel channel = channels.get(side);
            String type = channel.findChannelHandlerNameForType(PacketHandler.class);
            channel.pipeline().addAfter(type, PacketInboundHandler.class.getName(), (ChannelHandler)new PacketInboundHandler());
        }
    }

    public static void sendPacketToServer(ModernPacket packet) {
        if (MainProxy.isServer()) {
            System.err.println("sendPacketToServer called serverside !");
            new Exception().printStackTrace();
            return;
        }
        if (packet.isCompressable() || MainProxy.needsToBeCompressed(packet)) {
            SimpleServiceLocator.clientBufferHandler.addPacketToCompressor(packet);
        } else {
            channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            channels.get(Side.CLIENT).writeOutbound(new Object[]{packet});
        }
    }

    public static void sendPacketToPlayer(ModernPacket packet, EntityPlayer player) {
        if (!MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            System.err.println("sendPacketToPlayer called clientside !");
            new Exception().printStackTrace();
            return;
        }
        if (packet.isCompressable() || MainProxy.needsToBeCompressed(packet)) {
            SimpleServiceLocator.serverBufferHandler.addPacketToCompressor(packet, player);
        } else {
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
        }
    }

    public static boolean isAnyoneWatching(BlockPos pos, int dimensionID) {
        return MainProxy.isAnyoneWatching(pos.func_177958_n(), pos.func_177952_p(), dimensionID);
    }

    public static boolean isAnyoneWatching(int X, int Z, int dimensionID) {
        ChunkPos chunk = new ChunkPos(X >> 4, Z >> 4);
        PlayerCollectionList players = LogisticsEventListener.watcherList.get(chunk);
        if (players == null) {
            return false;
        }
        return !players.isEmptyWithoutCheck();
    }

    public static void sendPacketToAllWatchingChunk(TileEntity tile, ModernPacket packet) {
        MainProxy.sendPacketToAllWatchingChunk(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177952_p(), tile.func_145831_w().field_73011_w.getDimension(), packet);
    }

    public static void sendPacketToAllWatchingChunk(int X, int Z, int dimensionId, ModernPacket packet) {
        if (!MainProxy.isServer()) {
            System.err.println("sendPacketToAllWatchingChunk called clientside !");
            new Exception().printStackTrace();
            return;
        }
        ChunkPos chunk = new ChunkPos(X >> 4, Z >> 4);
        PlayerCollectionList players = LogisticsEventListener.watcherList.get(chunk);
        if (players != null) {
            for (EntityPlayer player : players.players()) {
                if (player.field_70170_p.field_73011_w.getDimension() != dimensionId) continue;
                MainProxy.sendPacketToPlayer(packet, player);
            }
            return;
        }
    }

    public static void sendToPlayerList(ModernPacket packet, PlayerCollectionList players) {
        if (players.isEmpty()) {
            return;
        }
        MainProxy.sendToPlayerList(packet, players.players());
    }

    public static void sendToPlayerList(ModernPacket packet, Iterable<EntityPlayer> players) {
        if (!MainProxy.isServer()) {
            System.err.println("sendToPlayerList called clientside !");
            new Exception().printStackTrace();
            return;
        }
        if (packet.isCompressable() || MainProxy.needsToBeCompressed(packet)) {
            for (EntityPlayer player : players) {
                SimpleServiceLocator.serverBufferHandler.addPacketToCompressor(packet, player);
            }
        } else {
            for (EntityPlayer player : players) {
                MainProxy.sendPacketToPlayer(packet, player);
            }
        }
    }

    public static void sendToPlayerList(ModernPacket packet, Stream<EntityPlayer> players) {
        if (!MainProxy.isServer()) {
            System.err.println("sendToPlayerList called clientside !");
            new Exception().printStackTrace();
            return;
        }
        if (packet.isCompressable() || MainProxy.needsToBeCompressed(packet)) {
            players.forEach(player -> SimpleServiceLocator.serverBufferHandler.addPacketToCompressor(packet, (EntityPlayer)player));
        } else {
            players.forEach(player -> MainProxy.sendPacketToPlayer(packet, player));
        }
    }

    public static void sendToAllPlayers(ModernPacket packet) {
        if (!MainProxy.isServer()) {
            System.err.println("sendToAllPlayers called clientside !");
            new Exception().printStackTrace();
            return;
        }
        if (packet.isCompressable() || MainProxy.needsToBeCompressed(packet)) {
            for (WorldServer world : DimensionManager.getWorlds()) {
                for (Object playerObject : world.field_73010_i) {
                    EntityPlayer player = (EntityPlayer)playerObject;
                    SimpleServiceLocator.serverBufferHandler.addPacketToCompressor(packet, player);
                }
            }
        } else {
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
        }
    }

    private static boolean needsToBeCompressed(ModernPacket packet) {
        return false;
    }

    public static FakePlayer getFakePlayer(World world) {
        int dimId = world.field_73011_w.getDimension();
        if (fakePlayers.containsKey(dimId)) {
            return fakePlayers.get(dimId);
        }
        if (world instanceof WorldServer) {
            FakePlayerLP fp = new FakePlayerLP((WorldServer)world);
            fakePlayers.put(dimId, fp);
            return fp;
        }
        return null;
    }

    public static File getLPFolder() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), networkChannelName);
    }

    public static void addTick() {
        ++globalTick;
    }

    public static EntityItem dropItems(World world, ItemStack stack, int xCoord, int yCoord, int zCoord) {
        EntityItem item = new EntityItem(world, (double)xCoord, (double)yCoord, (double)zCoord, stack);
        world.func_72838_d((Entity)item);
        return item;
    }

    public static boolean checkPipesConnections(TileEntity from, TileEntity to) {
        return MainProxy.checkPipesConnections(from, to, OrientationsUtil.getOrientationOfTilewithTile(from, to));
    }

    public static boolean checkPipesConnections(TileEntity from, TileEntity to, EnumFacing way) {
        return MainProxy.checkPipesConnections(from, to, way, false);
    }

    public static boolean checkPipesConnections(TileEntity from, TileEntity to, EnumFacing way, boolean ignoreSystemDisconnection) {
        if (from == null || to == null) {
            return false;
        }
        IPipeInformationProvider fromInfo = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(from);
        IPipeInformationProvider toInfo = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(to);
        if (fromInfo == null && toInfo == null) {
            return false;
        }
        if (fromInfo != null && !fromInfo.canConnect(to, way, ignoreSystemDisconnection)) {
            return false;
        }
        return toInfo == null || toInfo.canConnect(from, way.func_176734_d(), ignoreSystemDisconnection);
    }

    public static boolean isPipeControllerEquipped(EntityPlayer entityplayer) {
        return entityplayer != null && entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == LPItems.pipeController;
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        fakePlayers.entrySet().removeIf(entry -> ((FakePlayerLP)((Object)((Object)entry.getValue()))).field_70170_p == event.getWorld());
    }

    public static int getGlobalTick() {
        return globalTick;
    }

    static {
        threadSideMap = new WeakHashMap();
        fakePlayers = Maps.newHashMap();
    }
}

