/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.buildcraft;

import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.transport.pipe.behaviour.PipeBehaviourDiamondItem;
import buildcraft.transport.pipe.behaviour.PipeBehaviourDirectional;
import buildcraft.transport.pipe.behaviour.PipeBehaviourIron;
import buildcraft.transport.pipe.behaviour.PipeBehaviourObsidian;
import buildcraft.transport.tile.TilePipeHolder;
import java.util.List;
import java.util.stream.Stream;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.ReflectionHelper;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class BCPipeInformationProvider
implements IPipeInformationProvider {
    private final TilePipeHolder pipe;

    public BCPipeInformationProvider(TilePipeHolder pipe) {
        this.pipe = pipe;
    }

    @Override
    public boolean isCorrect(IPipeInformationProvider.ConnectionPipeType type) {
        if (this.pipe == null || this.pipe.getPipe() == null || !SimpleServiceLocator.buildCraftProxy.isActive()) {
            return false;
        }
        boolean precheck = false;
        if (type == IPipeInformationProvider.ConnectionPipeType.UNDEFINED) {
            precheck = this.pipe.getPipe().getDefinition().flowType == PipeApi.flowItems || this.pipe.getPipe().getDefinition().flowType == PipeApi.flowFluids;
        } else if (type == IPipeInformationProvider.ConnectionPipeType.ITEM) {
            precheck = this.pipe.getPipe().getDefinition().flowType == PipeApi.flowItems;
        } else if (type == IPipeInformationProvider.ConnectionPipeType.FLUID) {
            precheck = this.pipe.getPipe().getDefinition().flowType == PipeApi.flowFluids;
        }
        return precheck;
    }

    @Override
    public int getX() {
        return this.pipe.getPipePos().func_177958_n();
    }

    @Override
    public int getY() {
        return this.pipe.getPipePos().func_177956_o();
    }

    @Override
    public int getZ() {
        return this.pipe.getPipePos().func_177952_p();
    }

    @Override
    public World getWorld() {
        return this.pipe.func_145831_w();
    }

    @Override
    public boolean isRouterInitialized() {
        return this.pipe.getPipe() != null;
    }

    @Override
    public boolean isRoutingPipe() {
        return false;
    }

    @Override
    public CoreRoutedPipe getRoutingPipe() {
        throw new RuntimeException("This is no routing pipe");
    }

    @Override
    public TileEntity getNextConnectedTile(EnumFacing direction) {
        return this.pipe.getNeighbourTile(direction);
    }

    @Override
    public boolean isFirewallPipe() {
        return false;
    }

    @Override
    public IFilter getFirewallFilter() {
        throw new RuntimeException("This is not a firewall pipe");
    }

    @Override
    public TileEntity getTile() {
        return this.pipe;
    }

    @Override
    public boolean divideNetwork() {
        return this.pipe.getPipe().getDefinition().flowType == PipeApi.flowItems && this.pipe.getPipe().getBehaviour() instanceof PipeBehaviourObsidian || this.pipe.getPipe().getDefinition().flowType == PipeApi.flowStructure;
    }

    @Override
    public boolean powerOnly() {
        return this.pipe.getPipe().getDefinition().flowType == PipeApi.flowItems && this.pipe.getPipe().getBehaviour() instanceof PipeBehaviourDiamondItem;
    }

    @Override
    public boolean isOnewayPipe() {
        return this.pipe.getPipe().getDefinition().flowType == PipeApi.flowItems && this.pipe.getPipe().getBehaviour() instanceof PipeBehaviourIron;
    }

    @Override
    public boolean isOutputOpen(EnumFacing direction) {
        EnumFacing point = (EnumFacing)ReflectionHelper.invokePrivateMethod(PipeBehaviourDirectional.class, this.pipe.getPipe().getBehaviour(), "getCurrentDir", "getCurrentDir", new Class[0], new Object[0]);
        return point == direction;
    }

    @Override
    public boolean canConnect(TileEntity to, EnumFacing direction, boolean targeted) {
        return this.pipe.getPipe().isConnected(direction);
    }

    @Override
    public double getDistance() {
        return 1.0;
    }

    @Override
    public double getDistanceWeight() {
        return 1.0;
    }

    @Override
    public boolean isItemPipe() {
        return this.pipe != null && this.pipe.getPipe() != null && this.pipe.getPipe().getDefinition().flowType == PipeApi.flowItems && SimpleServiceLocator.buildCraftProxy.isActive();
    }

    @Override
    public boolean isFluidPipe() {
        return this.pipe != null && this.pipe.getPipe() != null && this.pipe.getPipe().getDefinition().flowType == PipeApi.flowFluids && SimpleServiceLocator.buildCraftProxy.isActive();
    }

    @Override
    public boolean isPowerPipe() {
        return this.pipe != null && this.pipe.getPipe() != null && this.pipe.getPipe().getDefinition().flowType == PipeApi.flowPower && SimpleServiceLocator.buildCraftProxy.isActive();
    }

    @Override
    public double getDistanceTo(int destinationint, EnumFacing ignore, ItemIdentifier ident, boolean isActive, double traveled, double max, List<DoubleCoordinates> visited) {
        if (traveled >= max) {
            return 2.147483647E9;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            DoubleCoordinates pos;
            IPipeInformationProvider information;
            if (ignore == dir || (information = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(this.getNextConnectedTile(dir))) == null || visited.contains(pos = new DoubleCoordinates(information))) continue;
            visited.add(pos);
            double result = information.getDistanceTo(destinationint, dir.func_176734_d(), ident, isActive, traveled + this.getDistance(), max, visited);
            visited.remove(pos);
            if (result == 2.147483647E9) {
                return result;
            }
            return result + (double)((int)this.getDistance());
        }
        return 2.147483647E9;
    }

    @Override
    public boolean acceptItem(LPTravelingItem item, TileEntity from) {
        if (this.pipe != null && this.pipe.getPipe() != null && this.pipe.getPipe().getDefinition().flowType == PipeApi.flowItems) {
            if (!(item instanceof LPTravelingItem.LPTravelingItemServer)) {
                return true;
            }
            ItemRoutingInformation routingInformation = ((LPTravelingItem.LPTravelingItemServer)item).getInfo();
            NBTTagCompound routingData = new NBTTagCompound();
            routingInformation.storeToNBT(routingData);
            ItemStack transportStack = item.getItemIdentifierStack().makeNormalStack();
            if (!transportStack.func_77942_o()) {
                transportStack.func_77982_d(new NBTTagCompound());
            }
            transportStack.func_77978_p().func_74782_a("logisticspipes:routingdata_buildcraft", (NBTBase)routingData);
            IFlowItems itemPipe = (IFlowItems)this.pipe.getPipe().getFlow();
            itemPipe.insertItemsForce(transportStack, item.output.func_176734_d(), null, (double)item.getSpeed());
            return true;
        }
        return false;
    }

    @Override
    public void refreshTileCacheOnSide(EnumFacing side) {
    }

    @Override
    public boolean isMultiBlock() {
        return false;
    }

    @Override
    public Stream<TileEntity> getPartsOfPipe() {
        return Stream.empty();
    }
}

