/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.buildcraft.recipeprovider;

import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.recipes.AssemblyRecipeBasic;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.silicon.EnumAssemblyRecipeState;
import buildcraft.silicon.tile.TileAssemblyTable;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.utils.item.ItemIdentifierInventory;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class AssemblyTable
implements ICraftingRecipeProvider {
    @Override
    public boolean canOpenGui(TileEntity tile) {
        return tile instanceof TileAssemblyTable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean importRecipe(TileEntity tile, ItemIdentifierInventory inventory) {
        if (!(tile instanceof TileAssemblyTable)) {
            return false;
        }
        TileAssemblyTable table = (TileAssemblyTable)tile;
        ItemIdentifierInventory inputs = new ItemIdentifierInventory(inventory.func_70302_i_() - 2, "AssemblyTableDummyInv", 64, false);
        for (int i = 0; i < inventory.func_70302_i_() - 2; ++i) {
            inputs.setInventorySlotContents(i, inventory.getIDStackInSlot(i));
        }
        ItemStack output = inventory.func_70301_a(inventory.func_70302_i_() - 2);
        AssemblyRecipeBasic firstRecipe = null;
        AssemblyRecipeBasic nextRecipe = null;
        boolean takeNext = false;
        for (AssemblyRecipe r : AssemblyRecipeRegistry.REGISTRY.values()) {
            if (!(r instanceof AssemblyRecipeBasic) || !table.recipesStates.entrySet().stream().filter(it -> ((TileAssemblyTable.AssemblyInstruction)it.getKey()).recipe == r).anyMatch(it -> it.getValue() != EnumAssemblyRecipeState.POSSIBLE)) continue;
            if (firstRecipe == null) {
                firstRecipe = (AssemblyRecipeBasic)r;
            }
            if (takeNext) {
                nextRecipe = (AssemblyRecipeBasic)r;
                break;
            }
            if (output == null || !r.getOutputPreviews().stream().anyMatch(it -> ItemStack.func_77989_b((ItemStack)output, (ItemStack)it)) || r.getOutputs(inputs.toNonNullList()).isEmpty()) continue;
            takeNext = true;
        }
        if (nextRecipe == null) {
            nextRecipe = firstRecipe;
        }
        if (nextRecipe == null) {
            return false;
        }
        inventory.func_70299_a(inventory.func_70302_i_() - 2, nextRecipe.getOutputPreviews().stream().findFirst().orElse(ItemStack.field_190927_a));
        try {
            int i;
            for (i = 0; i < inventory.func_70302_i_() - 2; ++i) {
                inventory.clearInventorySlotContents(i);
            }
            i = 0;
            for (Object input : nextRecipe.getInputsFor(inventory.func_70301_a(inventory.func_70302_i_() - 2))) {
                ItemStack processed = null;
                if (input instanceof String) {
                    NonNullList ores = OreDictionary.getOres((String)((String)input));
                    if (ores != null && ores.size() <= 0) {
                        // empty if block
                    }
                } else if (input instanceof ItemStack) {
                    processed = (ItemStack)input;
                } else if (input instanceof Item) {
                    processed = new ItemStack((Item)input);
                } else if (input instanceof Block) {
                    processed = new ItemStack((Block)input, 1, 0);
                } else {
                    if (!(input instanceof Integer)) {
                        throw new IllegalArgumentException("Unknown Object passed to recipe!");
                    }
                    processed = null;
                }
                if (processed == null) continue;
                inventory.func_70299_a(i, processed);
                ++i;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        inventory.compactFirst(9);
        return true;
    }
}

