/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.api.IHUDArmor;
import logisticspipes.config.Configs;
import logisticspipes.hud.HUDConfig;
import logisticspipes.interfaces.IDebugHUDProvider;
import logisticspipes.interfaces.IHUDConfig;
import logisticspipes.interfaces.IHeadUpDisplayBlockRendererProvider;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LaserData;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.item.ItemStackRenderer;
import logisticspipes.utils.math.Vector3d;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class LogisticsHUDRenderer {
    public IDebugHUDProvider debugHUD = null;
    private LinkedList<IHeadUpDisplayRendererProvider> list = new LinkedList();
    private double lastXPos = 0.0;
    private double lastYPos = 0.0;
    private double lastZPos = 0.0;
    private int progress = 0;
    private long last = 0L;
    private ArrayList<IHeadUpDisplayBlockRendererProvider> providers = new ArrayList();
    private List<LaserData> lasers = new ArrayList<LaserData>();
    private static LogisticsHUDRenderer renderer = null;
    private boolean displayCross = false;
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/icons.png");

    public void add(IHeadUpDisplayBlockRendererProvider provider) {
        IHeadUpDisplayBlockRendererProvider toRemove = null;
        for (IHeadUpDisplayBlockRendererProvider listedProvider : this.providers) {
            if (listedProvider.getX() != provider.getX() || listedProvider.getY() != provider.getY() || listedProvider.getZ() != provider.getZ()) continue;
            toRemove = listedProvider;
            break;
        }
        if (toRemove != null) {
            this.providers.remove(toRemove);
        }
        this.providers.add(provider);
    }

    public void remove(IHeadUpDisplayBlockRendererProvider provider) {
        this.providers.remove(provider);
    }

    public void clear() {
        this.providers.clear();
        LogisticsHUDRenderer.instance().clearList(false);
    }

    private void clearList(boolean flag) {
        if (flag) {
            this.list.forEach(IHeadUpDisplayRendererProvider::stopWatching);
        }
        this.list.clear();
    }

    private void refreshList(double x, double y, double z) {
        ArrayList<Pair<Double, IHeadUpDisplayRendererProvider>> newList = new ArrayList<Pair<Double, IHeadUpDisplayRendererProvider>>();
        for (IRouter router : SimpleServiceLocator.routerManager.getRouters()) {
            double dis;
            CoreRoutedPipe coreRoutedPipe;
            if (router == null || !((coreRoutedPipe = router.getPipe()) instanceof IHeadUpDisplayRendererProvider) || coreRoutedPipe.getWorld().field_73011_w.getDimension() != FMLClientHandler.instance().getClient().field_71441_e.field_73011_w.getDimension() || !((dis = Math.hypot((double)coreRoutedPipe.getX() - x + 0.5, Math.hypot((double)coreRoutedPipe.getY() - y + 0.5, (double)coreRoutedPipe.getZ() - z + 0.5))) < (double)Configs.LOGISTICS_HUD_RENDER_DISTANCE) || !(dis > 0.75)) continue;
            newList.add(new Pair<Double, IHeadUpDisplayRendererProvider>(dis, (IHeadUpDisplayRendererProvider)((Object)coreRoutedPipe)));
            if (this.list.contains(coreRoutedPipe)) continue;
            ((IHeadUpDisplayRendererProvider)((Object)coreRoutedPipe)).startWatching();
        }
        ArrayList remove = new ArrayList();
        this.providers.stream().filter(provider -> provider.getWorldForHUD().field_73011_w.getDimension() == FMLClientHandler.instance().getClient().field_71441_e.field_73011_w.getDimension()).forEach(provider -> {
            double dis = Math.hypot((double)provider.getX() - x + 0.5, Math.hypot((double)provider.getY() - y + 0.5, (double)provider.getZ() - z + 0.5));
            if (dis < (double)Configs.LOGISTICS_HUD_RENDER_DISTANCE && dis > 0.75 && !provider.isHUDInvalid() && provider.isHUDExistent()) {
                newList.add(new Pair<Double, IHeadUpDisplayBlockRendererProvider>(dis, (IHeadUpDisplayBlockRendererProvider)provider));
                if (!this.list.contains(provider)) {
                    provider.startWatching();
                }
            } else if (provider.isHUDInvalid() || !provider.isHUDExistent()) {
                remove.add(provider);
            }
        });
        for (IHeadUpDisplayBlockRendererProvider iHeadUpDisplayBlockRendererProvider : remove) {
            this.providers.remove(iHeadUpDisplayBlockRendererProvider);
        }
        if (newList.size() < 1) {
            this.clearList(true);
            return;
        }
        Collections.sort(newList, (o1, o2) -> {
            if ((Double)o1.getValue1() < (Double)o2.getValue1()) {
                return -1;
            }
            if ((Double)o1.getValue1() > (Double)o2.getValue1()) {
                return 1;
            }
            return 0;
        });
        for (IHeadUpDisplayRendererProvider iHeadUpDisplayRendererProvider : this.list) {
            boolean contains = false;
            for (Pair pair : newList) {
                if (!((IHeadUpDisplayRendererProvider)pair.getValue2()).equals(iHeadUpDisplayRendererProvider)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            iHeadUpDisplayRendererProvider.stopWatching();
        }
        this.clearList(false);
        for (Pair pair : newList) {
            this.list.addLast((IHeadUpDisplayRendererProvider)pair.getValue2());
        }
    }

    private boolean playerWearsHUD() {
        return FMLClientHandler.instance().getClient().field_71439_g != null && FMLClientHandler.instance().getClient().field_71439_g.field_71071_by != null && FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70460_b != null && !((ItemStack)FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70460_b.get(3)).func_190926_b() && this.checkItemStackForHUD((ItemStack)FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70460_b.get(3));
    }

    private boolean checkItemStackForHUD(ItemStack stack) {
        if (stack.func_77973_b() instanceof IHUDArmor) {
            return ((IHUDArmor)stack.func_77973_b()).isEnabled(stack);
        }
        return false;
    }

    public void renderPlayerDisplay(long renderTicks) {
        if (!this.displayRenderer()) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (this.displayHUD() && this.displayCross) {
            ScaledResolution res = new ScaledResolution(mc);
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            if (GuiIngameForge.renderCrosshairs && mc.field_71456_v != null) {
                mc.field_71446_o.func_110577_a(TEXTURE);
                GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)1.0);
                GL11.glDisable((int)3042);
                mc.field_71456_v.func_73729_b(width / 2 - 7, height / 2 - 7, 0, 0, 16, 16);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderWorldRelative(long renderTicks, float partialTick) {
        if (!this.displayRenderer()) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        if (this.list.size() == 0 || Math.hypot(this.lastXPos - player.field_70165_t, Math.hypot(this.lastYPos - player.field_70163_u, this.lastZPos - player.field_70161_v)) > 0.5 || renderTicks % 10L == 0L && (this.lastXPos != player.field_70165_t || this.lastYPos != player.field_70163_u || this.lastZPos != player.field_70161_v) || renderTicks % 600L == 0L) {
            this.refreshList(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            this.lastXPos = player.field_70165_t;
            this.lastYPos = player.field_70163_u;
            this.lastZPos = player.field_70161_v;
        }
        boolean cursorHandled = false;
        this.displayCross = false;
        IHUDConfig config = this.debugHUD == null ? new HUDConfig((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(3)) : new IHUDConfig(){

            @Override
            public boolean isHUDSatellite() {
                return false;
            }

            @Override
            public boolean isHUDProvider() {
                return false;
            }

            @Override
            public boolean isHUDPowerLevel() {
                return false;
            }

            @Override
            public boolean isHUDInvSysCon() {
                return false;
            }

            @Override
            public boolean isHUDCrafting() {
                return false;
            }

            @Override
            public boolean isHUDChassie() {
                return false;
            }

            @Override
            public void setHUDChassie(boolean state) {
            }

            @Override
            public void setHUDCrafting(boolean state) {
            }

            @Override
            public void setHUDInvSysCon(boolean state) {
            }

            @Override
            public void setHUDPowerJunction(boolean state) {
            }

            @Override
            public void setHUDProvider(boolean state) {
            }

            @Override
            public void setHUDSatellite(boolean state) {
            }
        };
        IHeadUpDisplayRendererProvider thisIsLast = null;
        List<IHeadUpDisplayRendererProvider> toUse = this.list;
        if (this.debugHUD != null) {
            toUse = this.debugHUD.getHUDs();
        }
        for (IHeadUpDisplayRendererProvider renderer : toUse) {
            if (renderer.getRenderer() == null || !renderer.getRenderer().display(config)) continue;
            GL11.glPushMatrix();
            if (!cursorHandled) {
                double z;
                double y;
                double x = (double)renderer.getX() + 0.5 - player.field_70165_t;
                if (Math.hypot(x, Math.hypot(y = (double)renderer.getY() + 0.5 - player.field_70163_u, z = (double)renderer.getZ() + 0.5 - player.field_70161_v)) < 0.75 || renderer instanceof IHeadUpDisplayBlockRendererProvider && (((IHeadUpDisplayBlockRendererProvider)renderer).isHUDInvalid() || !((IHeadUpDisplayBlockRendererProvider)renderer).isHUDExistent())) {
                    this.refreshList(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    GL11.glPopMatrix();
                    break;
                }
                int[] pos = this.getCursor(renderer);
                if (pos.length == 2 && renderer.getRenderer().cursorOnWindow(pos[0], pos[1])) {
                    renderer.getRenderer().handleCursor(pos[0], pos[1]);
                    if (Keyboard.isKeyDown((int)42)) {
                        thisIsLast = renderer;
                        this.displayCross = true;
                    }
                    cursorHandled = true;
                }
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (thisIsLast != renderer) {
                this.displayOneView(renderer, config, partialTick, false);
            }
            GL11.glPopMatrix();
        }
        if (thisIsLast != null) {
            GL11.glPushMatrix();
            GL11.glDisable((int)3042);
            GL11.glDisable((int)2929);
            this.displayOneView(thisIsLast, config, partialTick, true);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        RayTraceResult box = mc.field_71476_x;
        if (box != null && box.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.progress = Keyboard.isKeyDown((int)29) ? Math.min(this.progress + 2 * Math.max(1, (int)Math.floor((double)(System.currentTimeMillis() - this.last) / 50.0)), 100) : Math.max(this.progress - 2 * Math.max(1, (int)Math.floor((double)(System.currentTimeMillis() - this.last) / 50.0)), 0);
            if (this.progress != 0) {
                List<Object> textData = new ArrayList();
                if (textData.isEmpty()) {
                    textData = SimpleServiceLocator.neiProxy.getInfoForPosition(player.field_70170_p, (EntityPlayer)player, box);
                }
                if (!textData.isEmpty()) {
                    double xCoord = (double)box.func_178782_a().func_177958_n() + 0.5;
                    double yCoord = (double)box.func_178782_a().func_177956_o() + 0.5;
                    double zCoord = (double)box.func_178782_a().func_177952_p() + 0.5;
                    double x = xCoord - player.field_70169_q - (player.field_70165_t - player.field_70169_q) * (double)partialTick;
                    double y = yCoord - player.field_70167_r - (player.field_70163_u - player.field_70167_r) * (double)partialTick;
                    double z = zCoord - player.field_70166_s - (player.field_70161_v - player.field_70166_s) * (double)partialTick;
                    GL11.glDisable((int)2929);
                    GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)(this.getAngle(z, x) + 110.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(-1.0f * this.getAngle(Math.hypot(x + 0.8, z + 0.8), y + 0.5) + 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                    double dProgress = (double)this.progress / 100.0;
                    GL11.glTranslated((double)(0.4 * dProgress + 0.6), (double)(-0.2 * dProgress - 0.6), (double)-0.0);
                    GL11.glScalef((float)0.01f, (float)0.01f, (float)1.0f);
                    int heigth = Math.max(32, 10 * textData.size() + 15);
                    int width = 0;
                    for (String string : textData) {
                        width = Math.max(width, mc.field_71466_p.func_78256_a(string) + 22);
                    }
                    width = Math.max(32, width + 15);
                    GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)96);
                    GuiGraphics.drawGuiBackGround(mc, (int)(-0.5 * (double)(width - 32) * dProgress) - 16, (int)(-0.5 * (double)(heigth - 32) * dProgress) - 16, (int)(0.5 * (double)(width - 32) * dProgress) + 16, (int)(0.5 * (double)(heigth - 32) * dProgress) + 16, 0.0f, false);
                    GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
                    if (this.progress == 100) {
                        GL11.glTranslated((double)((int)(-0.5 * (double)(width - 32) * dProgress) - 16), (double)((int)(-0.5 * (double)(heigth - 32) * dProgress) - 16), (double)-1.0E-4);
                        for (int i = 0; i < textData.size(); ++i) {
                            mc.field_71466_p.func_78276_b((String)textData.get(i), 28, 8 + i * 10, 0);
                        }
                        ItemStack item = SimpleServiceLocator.neiProxy.getItemForPosition(player.field_70170_p, (EntityPlayer)player, box);
                        if (item != null) {
                            float f = 1.2f;
                            float scaleY = 1.2f;
                            float scaleZ = -1.0E-4f;
                            GL11.glScalef((float)f, (float)scaleY, (float)scaleZ);
                            ItemStackRenderer itemStackRenderer = new ItemStackRenderer(5, 6, 0.0f, true, true);
                            itemStackRenderer.setItemstack(item).setDisplayAmount(ItemStackRenderer.DisplayAmount.NEVER);
                            itemStackRenderer.setScaleX(f).setScaleY(scaleY).setScaleZ(scaleZ);
                            itemStackRenderer.renderInGui();
                        }
                    }
                    GL11.glEnable((int)2929);
                }
            }
        } else if (!Keyboard.isKeyDown((int)29)) {
            this.progress = 0;
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (LaserData data : this.lasers) {
            GL11.glPushMatrix();
            double x = (double)data.getPosX() + 0.5 - player.field_70169_q - (player.field_70165_t - player.field_70169_q) * (double)partialTick;
            double y = (double)data.getPosY() + 0.5 - player.field_70167_r - (player.field_70163_u - player.field_70167_r) * (double)partialTick;
            double z = (double)data.getPosZ() + 0.5 - player.field_70166_s - (player.field_70161_v - player.field_70166_s) * (double)partialTick;
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            switch (data.getDir()) {
                case NORTH: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case SOUTH: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    break;
                }
                case WEST: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case UP: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                case DOWN: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    break;
                }
            }
            GL11.glScalef((float)0.01f, (float)0.01f, (float)0.01f);
            Tessellator tessellator = Tessellator.func_178181_a();
            for (float i = 0.0f; i < (float)(6 * data.getLength()); i += 1.0f) {
                this.setColor(i, data.getConnectionType());
                float shift = 100.0f * i / 6.0f;
                float start = 0.0f;
                if (data.isStartPipe() && i == 0.0f) {
                    start = -6.0f;
                }
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b((double)(19.7f + shift), 3.0, -3.0);
                buffer.func_181662_b((double)(3.0f + shift + start), 3.0, -3.0);
                buffer.func_181662_b((double)(3.0f + shift + start), 3.0, 3.0);
                buffer.func_181662_b((double)(19.7f + shift), 3.0, 3.0);
                tessellator.func_78381_a();
                buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b((double)(19.7f + shift), -3.0, 3.0);
                buffer.func_181662_b((double)(3.0f + shift + start), -3.0, 3.0);
                buffer.func_181662_b((double)(3.0f + shift + start), -3.0, -3.0);
                buffer.func_181662_b((double)(19.7f + shift), -3.0, -3.0);
                tessellator.func_78381_a();
                buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b((double)(19.7f + shift), 3.0, 3.0);
                buffer.func_181662_b((double)(3.0f + shift + start), 3.0, 3.0);
                buffer.func_181662_b((double)(3.0f + shift + start), -3.0, 3.0);
                buffer.func_181662_b((double)(19.7f + shift), -3.0, 3.0);
                tessellator.func_78381_a();
                buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b((double)(19.7f + shift), -3.0, -3.0);
                buffer.func_181662_b((double)(3.0f + shift + start), -3.0, -3.0);
                buffer.func_181662_b((double)(3.0f + shift + start), 3.0, -3.0);
                buffer.func_181662_b((double)(19.7f + shift), 3.0, -3.0);
                tessellator.func_78381_a();
            }
            if (data.isStartPipe()) {
                this.setColor(0.0f, data.getConnectionType());
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b(-3.0, 3.0, 3.0);
                buffer.func_181662_b(-3.0, 3.0, -3.0);
                buffer.func_181662_b(-3.0, -3.0, -3.0);
                buffer.func_181662_b(-3.0, -3.0, 3.0);
                tessellator.func_78381_a();
            }
            if (data.isFinalPipe()) {
                this.setColor(6 * data.getLength() - 1, data.getConnectionType());
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b((double)(100.0f * (float)data.getLength() + 3.0f), 3.0, -3.0);
                buffer.func_181662_b((double)(100.0f * (float)data.getLength() + 3.0f), 3.0, 3.0);
                buffer.func_181662_b((double)(100.0f * (float)data.getLength() + 3.0f), -3.0, 3.0);
                buffer.func_181662_b((double)(100.0f * (float)data.getLength() + 3.0f), -3.0, -3.0);
                tessellator.func_78381_a();
            }
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3553);
        this.last = System.currentTimeMillis();
    }

    private void setColor(float i, EnumSet<PipeRoutingConnectionType> flags) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        if (!flags.isEmpty()) {
            int k = 0;
            for (PipeRoutingConnectionType type : PipeRoutingConnectionType.values) {
                if (flags.contains((Object)type)) {
                    ++k;
                }
                if (k - 1 != (int)i % flags.size()) continue;
                this.setColor(type);
                break;
            }
        }
    }

    private void setColor(PipeRoutingConnectionType type) {
        switch (type) {
            case canRouteTo: {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)0.5f);
                break;
            }
            case canRequestFrom: {
                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
                break;
            }
            case canPowerFrom: {
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)0.5f);
                break;
            }
        }
    }

    private void displayOneView(IHeadUpDisplayRendererProvider renderer, IHUDConfig config, float partialTick, boolean shifted) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        double x = (double)renderer.getX() + 0.5 - player.field_70169_q - (player.field_70165_t - player.field_70169_q) * (double)partialTick;
        double y = (double)renderer.getY() + 0.5 - player.field_70167_r - (player.field_70163_u - player.field_70167_r) * (double)partialTick;
        double z = (double)renderer.getZ() + 0.5 - player.field_70166_s - (player.field_70161_v - player.field_70166_s) * (double)partialTick;
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(this.getAngle(z, x) + 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-1.0f * this.getAngle(Math.hypot(x, z), y - (double)player.func_70047_e()) + 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.4f);
        GL11.glScalef((float)0.01f, (float)0.01f, (float)1.0f);
        renderer.getRenderer().renderHeadUpDisplay(Math.hypot(x, Math.hypot(y, z)), false, shifted, mc, config);
    }

    private float getAngle(double x, double y) {
        return (float)(Math.atan2(x, y) * 360.0 / (Math.PI * 2));
    }

    public double up(double input) {
        input %= 360.0;
        while (input < 0.0 && !Double.isNaN(input) && !Double.isInfinite(input)) {
            input += 360.0;
        }
        return input;
    }

    private int[] getCursor(IHeadUpDisplayRendererProvider renderer) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        Vector3d playerView = Vector3d.getFromAngles((double)((270.0f - player.field_70177_z) / 360.0f * -2.0f) * Math.PI, (double)(player.field_70125_A / 360.0f * -2.0f) * Math.PI);
        Vector3d playerPos = new Vector3d();
        playerPos.x = player.field_70165_t;
        playerPos.y = player.field_70163_u + (double)player.func_70047_e();
        playerPos.z = player.field_70161_v;
        Vector3d panelPos = new Vector3d();
        panelPos.x = (double)renderer.getX() + 0.5;
        panelPos.y = (double)renderer.getY() + 0.5;
        panelPos.z = (double)renderer.getZ() + 0.5;
        Vector3d panelView = new Vector3d();
        panelView.x = playerPos.x - panelPos.x;
        panelView.y = playerPos.y - panelPos.y;
        panelView.z = playerPos.z - panelPos.z;
        panelPos.add(panelView, 0.44);
        double d = panelPos.x * panelView.x + panelPos.y * panelView.y + panelPos.z * panelView.z;
        double c = panelView.x * playerPos.x + panelView.y * playerPos.y + panelView.z * playerPos.z;
        double b = panelView.x * playerView.x + panelView.y * playerView.y + panelView.z * playerView.z;
        double a = (d - c) / b;
        Vector3d viewPos = new Vector3d();
        viewPos.x = playerPos.x + a * playerView.x - panelPos.x;
        viewPos.y = playerPos.y + a * playerView.y - panelPos.y;
        viewPos.z = playerPos.z + a * playerView.z - panelPos.z;
        Vector3d panelScalVector1 = new Vector3d();
        if (panelView.y == 0.0) {
            panelScalVector1.x = 0.0;
            panelScalVector1.y = 1.0;
            panelScalVector1.z = 0.0;
        } else {
            panelScalVector1 = panelView.getOrtogonal(-panelView.x, null, -panelView.z).makeVectorLength(1.0);
        }
        Vector3d panelScalVector2 = new Vector3d();
        if (panelView.z == 0.0) {
            panelScalVector2.x = 0.0;
            panelScalVector2.y = 0.0;
            panelScalVector2.z = 1.0;
        } else {
            panelScalVector2 = panelView.getOrtogonal(1.0, 0.0, null).makeVectorLength(1.0);
        }
        if (panelScalVector1.y == 0.0) {
            return new int[0];
        }
        double cursorY = -viewPos.y / panelScalVector1.y;
        Vector3d restViewPos = viewPos.clone();
        restViewPos.x += cursorY * panelScalVector1.x;
        restViewPos.y = 0.0;
        restViewPos.z += cursorY * panelScalVector1.z;
        double cursorX = panelScalVector2.x == 0.0 ? restViewPos.z / panelScalVector2.z : restViewPos.x / panelScalVector2.x;
        cursorX *= 106.38297872340426;
        cursorY *= 106.38297872340426;
        if (panelView.z < 0.0) {
            cursorX *= -1.0;
        }
        if (panelView.y < 0.0) {
            cursorY *= -1.0;
        }
        return new int[]{(int)cursorX, (int)cursorY};
    }

    public boolean displayRenderer() {
        if (!this.displayHUD() && this.list.size() != 0) {
            this.clearList(true);
        }
        return this.displayHUD();
    }

    private boolean displayHUD() {
        return (this.playerWearsHUD() || this.debugHUD != null) && FMLClientHandler.instance().getClient().field_71462_r == null && FMLClientHandler.instance().getClient().field_71474_y.field_74320_O == 0 && !FMLClientHandler.instance().getClient().field_71474_y.field_74319_N;
    }

    public void resetLasers() {
        this.lasers.clear();
    }

    public void setLasers(List<LaserData> newLasers) {
        this.lasers.clear();
        this.lasers.addAll(newLasers);
    }

    public boolean hasLasers() {
        return !this.lasers.isEmpty();
    }

    public static LogisticsHUDRenderer instance() {
        if (renderer == null) {
            renderer = new LogisticsHUDRenderer();
        }
        return renderer;
    }
}

