/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import java.util.HashMap;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.operation.LPRotation;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.proxy.object3d.operation.LPUVScale;
import net.minecraft.util.EnumFacing;

public class LogisticsNewSolidBlockWorldRenderer {
    static Map<BlockRotation, IModel3D> block = new HashMap<BlockRotation, IModel3D>();
    static Map<CoverSides, Map<BlockRotation, IModel3D>> texturePlate_Inner = new HashMap<CoverSides, Map<BlockRotation, IModel3D>>();
    static Map<CoverSides, Map<BlockRotation, IModel3D>> texturePlate_Outer = new HashMap<CoverSides, Map<BlockRotation, IModel3D>>();

    public static void loadModels() {
        if (!SimpleServiceLocator.cclProxy.isActivated()) {
            return;
        }
        try {
            Map<String, IModel3D> blockPartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/BlockModel_result.obj"), 7, new LPScale(0.01f));
            block = null;
            for (Map.Entry<String, IModel3D> entry : blockPartModels.entrySet()) {
                if (!entry.getKey().contains(" Block ")) continue;
                if (block != null) {
                    throw new UnsupportedOperationException();
                }
                block = LogisticsNewSolidBlockWorldRenderer.computeRotated(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)));
            }
            texturePlate_Outer.clear();
            texturePlate_Inner.clear();
            for (CoverSides side : CoverSides.values()) {
                String grp_Outer = "OutSide_" + side.getLetter();
                String grp_Inside = "Inside_" + side.getLetter();
                for (Map.Entry<String, IModel3D> entry : blockPartModels.entrySet()) {
                    if (entry.getKey().contains(" " + grp_Outer + " ")) {
                        texturePlate_Outer.put(side, LogisticsNewSolidBlockWorldRenderer.computeRotated(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    }
                    if (!entry.getKey().contains(" " + grp_Inside + " ")) continue;
                    texturePlate_Inner.put(side, LogisticsNewSolidBlockWorldRenderer.computeRotated(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                }
                if (texturePlate_Outer.get((Object)side) == null) {
                    throw new RuntimeException("Couldn't load OutSide " + side.name() + " (" + grp_Outer + ").");
                }
                if (texturePlate_Inner.get((Object)side) != null) continue;
                throw new RuntimeException("Couldn't load OutSide " + side.name() + " (" + grp_Outer + ").");
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<BlockRotation, IModel3D> computeRotated(IModel3D m) {
        m.apply(new LPUVScale(1.0, 0.75));
        HashMap<BlockRotation, IModel3D> map = new HashMap<BlockRotation, IModel3D>();
        for (BlockRotation rot : BlockRotation.values()) {
            IModel3D model = m.copy();
            switch (rot.getInteger()) {
                case 0: {
                    model.apply(LPRotation.sideOrientation(0, 3));
                    model.apply(new LPTranslation(0.0, 0.0, 1.0));
                    break;
                }
                case 1: {
                    model.apply(LPRotation.sideOrientation(0, 1));
                    model.apply(new LPTranslation(1.0, 0.0, 0.0));
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    model.apply(LPRotation.sideOrientation(0, 2));
                    model.apply(new LPTranslation(1.0, 0.0, 1.0));
                }
            }
            model.computeNormals();
            model.computeStandardLighting();
            map.put(rot, model);
        }
        return map;
    }

    static {
        LogisticsNewSolidBlockWorldRenderer.loadModels();
    }

    static enum BlockRotation {
        ZERO(0),
        ONE(1),
        TWO(2),
        THREE(3);

        private int integer;

        private BlockRotation(int rot) {
            this.integer = rot;
        }

        static BlockRotation getRotation(int from) {
            for (BlockRotation rot : BlockRotation.values()) {
                if (rot.getInteger() != from) continue;
                return rot;
            }
            return null;
        }

        public int getInteger() {
            return this.integer;
        }
    }

    static enum CoverSides {
        DOWN(EnumFacing.DOWN, "D"),
        NORTH(EnumFacing.NORTH, "N"),
        SOUTH(EnumFacing.SOUTH, "S"),
        WEST(EnumFacing.WEST, "W"),
        EAST(EnumFacing.EAST, "E");

        private EnumFacing dir;
        private String letter;

        private CoverSides(EnumFacing dir, String letter) {
            this.dir = dir;
            this.letter = letter;
        }

        public EnumFacing getDir(BlockRotation rot) {
            EnumFacing result = this.dir;
            if (result != EnumFacing.DOWN) {
                switch (rot.getInteger()) {
                    case 0: {
                        result = result.func_176746_e();
                    }
                    case 3: {
                        result = result.func_176746_e();
                    }
                    case 1: {
                        result = result.func_176746_e();
                    }
                }
            }
            return result;
        }

        public String getLetter() {
            return this.letter;
        }
    }
}

