/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.List;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.world.DoubleCoordinates;

@SideOnly(value=Side.CLIENT)
public class ClientSideOrderInfo
implements IOrderInfoProvider {
    private final ItemIdentifierStack asDisplayItem;
    private final boolean isFinished;
    private final IOrderInfoProvider.ResourceType type;
    private final boolean inProgress;
    private final int routerId;
    private final boolean isWatched = false;
    private final List<Float> progresses;
    private final byte machineProgress;
    private final DoubleCoordinates targetPosition;
    private final ItemIdentifier targetType;

    public ClientSideOrderInfo(LPDataInput input) {
        this.asDisplayItem = input.readItemIdentifierStack();
        this.routerId = input.readInt();
        this.isFinished = input.readBoolean();
        this.inProgress = input.readBoolean();
        this.type = input.readEnum(IOrderInfoProvider.ResourceType.class);
        this.progresses = input.readArrayList(LPDataInput::readFloat);
        this.machineProgress = input.readByte();
        if (input.readBoolean()) {
            this.targetPosition = new DoubleCoordinates(input);
            this.targetType = input.readItemIdentifier();
        } else {
            this.targetPosition = null;
            this.targetType = null;
        }
    }

    @Override
    public void setWatched() {
    }

    @Override
    public ItemIdentifierStack getAsDisplayItem() {
        return this.asDisplayItem;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public IOrderInfoProvider.ResourceType getType() {
        return this.type;
    }

    @Override
    public boolean isInProgress() {
        return this.inProgress;
    }

    @Override
    public int getRouterId() {
        return this.routerId;
    }

    @Override
    public boolean isWatched() {
        return this.isWatched;
    }

    @Override
    public List<Float> getProgresses() {
        return this.progresses;
    }

    @Override
    public byte getMachineProgress() {
        return this.machineProgress;
    }

    @Override
    public DoubleCoordinates getTargetPosition() {
        return this.targetPosition;
    }

    @Override
    public ItemIdentifier getTargetType() {
        return this.targetType;
    }
}

