/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.routing.order.ClientSideOrderInfo;
import logisticspipes.routing.order.IOrderInfoProvider;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.util.LPFinalSerializable;

public class LinkedLogisticsOrderList
extends ArrayList<IOrderInfoProvider>
implements LPFinalSerializable {
    private static final long serialVersionUID = 4328359512757178338L;
    private List<LinkedLogisticsOrderList> subOrders = new ArrayList<LinkedLogisticsOrderList>();
    private List<IOrderInfoProvider> cachedList = null;
    private List<Float> cachedProgress = null;

    public LinkedLogisticsOrderList() {
    }

    public LinkedLogisticsOrderList(LPDataInput input) {
        ArrayList<IOrderInfoProvider> orderInfoProviders = input.readArrayList(ClientSideOrderInfo::new);
        if (orderInfoProviders == null) {
            throw new NullPointerException("Null order info providers read");
        }
        this.addAll(orderInfoProviders);
        ArrayList<LinkedLogisticsOrderList> orderLists = input.readArrayList(LinkedLogisticsOrderList::new);
        if (orderLists == null) {
            throw new NullPointerException("Null order lists read");
        }
        this.subOrders.addAll(orderLists);
    }

    @Override
    public void write(LPDataOutput output) {
        output.writeCollection(this);
        output.writeCollection(this.subOrders);
    }

    private void generateCache() {
        this.cachedList = new ArrayList<IOrderInfoProvider>();
        this.cachedList.addAll(this);
        for (LinkedLogisticsOrderList sub : this.subOrders) {
            this.cachedList.addAll(sub.getList());
        }
    }

    public List<IOrderInfoProvider> getList() {
        if (this.cachedList == null) {
            this.generateCache();
        }
        return this.cachedList;
    }

    public int getTreeRootSize() {
        int subSize = 0;
        for (LinkedLogisticsOrderList sub : this.subOrders) {
            subSize += sub.getTreeRootSize();
        }
        return Math.max(this.size(), subSize);
    }

    public int getSubTreeRootSize() {
        int subSize = 0;
        for (LinkedLogisticsOrderList sub : this.subOrders) {
            subSize += sub.getTreeRootSize();
        }
        return subSize;
    }

    public void setWatched() {
        this.forEach(IOrderInfoProvider::setWatched);
        this.subOrders.forEach(LinkedLogisticsOrderList::setWatched);
    }

    private void createProgressCache() {
        this.cachedProgress = new ArrayList<Float>();
        for (IOrderInfoProvider order : this) {
            order.getProgresses().stream().filter(n -> !this.cachedProgress.contains(n)).forEach((? super T n) -> this.cachedProgress.add((Float)n));
        }
    }

    public List<Float> getProgresses() {
        if (this.cachedProgress == null) {
            this.createProgressCache();
        }
        return this.cachedProgress;
    }

    public List<LinkedLogisticsOrderList> getSubOrders() {
        return this.subOrders;
    }
}

