/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.BufferTransfer;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import network.rs485.logisticspipes.util.LPDataIOWrapper;

public class ServerPacketBufferHandlerThread {
    private final ServerCompressorThread serverCompressorThread = new ServerCompressorThread();
    private final ServerDecompressorThread serverDecompressorThread = new ServerDecompressorThread();

    private static byte[] compress(byte[] content) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(content);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] decompress(byte[] contentBytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int buffer;
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(contentBytes));
            while ((buffer = gzip.read()) != -1) {
                out.write(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.serverDecompressorThread.serverTickEnd();
    }

    public void setPause(boolean flag) {
        this.serverCompressorThread.setPause(flag);
    }

    public void addPacketToCompressor(ModernPacket packet, EntityPlayer player) {
        this.serverCompressorThread.addPacketToCompressor(packet, player);
    }

    public void handlePacket(byte[] content, EntityPlayer player) {
        this.serverDecompressorThread.handlePacket(content, player);
    }

    public void clear(final EntityPlayer player) {
        new Thread(){

            @Override
            public void run() {
                ServerPacketBufferHandlerThread.this.serverCompressorThread.clear(player);
                ServerPacketBufferHandlerThread.this.serverDecompressorThread.clear(player);
            }
        }.start();
    }

    private static class ServerDecompressorThread
    extends Thread {
        private final HashMap<EntityPlayer, LinkedList<byte[]>> queue = new HashMap();
        private final HashMap<EntityPlayer, byte[]> ByteBuffer = new HashMap();
        private final LinkedList<Pair<EntityPlayer, byte[]>> PacketBuffer = new LinkedList();
        private final ReentrantLock packetBufferLock = new ReentrantLock();
        private Queue<EntityPlayer> playersToClear = new LinkedList<EntityPlayer>();

        public ServerDecompressorThread() {
            super("LogisticsPipes Packet Decompressor Server");
            this.setDaemon(true);
            this.start();
        }

        private void handlePacketData(Pair<EntityPlayer, byte[]> playerDataPair) {
            LPDataIOWrapper.provideData(playerDataPair.getValue2(), input -> PacketHandler.onPacketData(input, (EntityPlayer)playerDataPair.getValue1()));
        }

        public void serverTickEnd() {
            while (true) {
                Pair<EntityPlayer, byte[]> part = null;
                this.packetBufferLock.lock();
                try {
                    if (this.PacketBuffer.size() > 0) {
                        part = this.PacketBuffer.pop();
                    }
                }
                finally {
                    this.packetBufferLock.unlock();
                }
                if (part == null) break;
                this.handlePacketData(part);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            while (true) {
                byte[] ByteBufferForPlayer;
                void var3_6;
                boolean flag = false;
                Object buffer = null;
                Object var3_4 = null;
                HashMap<EntityPlayer, LinkedList<byte[]>> hashMap = this.queue;
                synchronized (hashMap) {
                    if (this.queue.size() > 0) {
                        Iterator<Map.Entry<EntityPlayer, LinkedList<byte[]>>> it = this.queue.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<EntityPlayer, LinkedList<byte[]>> lPlayer = it.next();
                            if (lPlayer.getValue().size() > 0) {
                                flag = true;
                                buffer = lPlayer.getValue().getFirst();
                                EntityPlayer entityPlayer = lPlayer.getKey();
                                if (lPlayer.getValue().size() > 1) {
                                    lPlayer.getValue().removeFirst();
                                    break;
                                }
                                it.remove();
                                break;
                            }
                            it.remove();
                        }
                    }
                }
                if (flag && buffer != null && var3_6 != null) {
                    ByteBufferForPlayer = this.ByteBuffer.get(var3_6);
                    if (ByteBufferForPlayer == null) {
                        ByteBufferForPlayer = new byte[]{};
                        this.ByteBuffer.put((EntityPlayer)var3_6, ByteBufferForPlayer);
                    }
                    byte[] packetbytes = ServerPacketBufferHandlerThread.decompress(buffer);
                    byte[] newBuffer = new byte[packetbytes.length + ByteBufferForPlayer.length];
                    System.arraycopy(ByteBufferForPlayer, 0, newBuffer, 0, ByteBufferForPlayer.length);
                    System.arraycopy(packetbytes, 0, newBuffer, ByteBufferForPlayer.length, packetbytes.length);
                    this.ByteBuffer.put((EntityPlayer)var3_6, newBuffer);
                }
                if (flag) continue;
                for (Map.Entry<EntityPlayer, byte[]> entry : this.ByteBuffer.entrySet()) {
                    int size;
                    while (entry.getValue().length >= 4 && (size = (((ByteBufferForPlayer = entry.getValue())[0] & 0xFF) << 24) + ((ByteBufferForPlayer[1] & 0xFF) << 16) + ((ByteBufferForPlayer[2] & 0xFF) << 8) + ((ByteBufferForPlayer[3] & 0xFF) << 0)) + 4 <= ByteBufferForPlayer.length) {
                        byte[] packet = Arrays.copyOfRange(ByteBufferForPlayer, 4, size + 4);
                        ByteBufferForPlayer = Arrays.copyOfRange(ByteBufferForPlayer, size + 4, ByteBufferForPlayer.length);
                        entry.setValue(ByteBufferForPlayer);
                        this.packetBufferLock.lock();
                        try {
                            this.PacketBuffer.add(new Pair<EntityPlayer, byte[]>(entry.getKey(), packet));
                        }
                        finally {
                            this.packetBufferLock.unlock();
                        }
                    }
                }
                Iterator<byte[]> it = this.ByteBuffer.values().iterator();
                while (it.hasNext()) {
                    byte[] byArray = it.next();
                    if (byArray.length != 0) continue;
                    it.remove();
                }
                Object object = this.queue;
                synchronized (object) {
                    while (this.queue.size() == 0) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                object = this.playersToClear;
                synchronized (object) {
                    EntityPlayer entityPlayer;
                    do {
                        if ((entityPlayer = this.playersToClear.poll()) == null) continue;
                        this.ByteBuffer.remove(entityPlayer);
                    } while (entityPlayer != null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePacket(byte[] content, EntityPlayer player) {
            HashMap<EntityPlayer, LinkedList<byte[]>> hashMap = this.queue;
            synchronized (hashMap) {
                LinkedList<Object> list = this.queue.get(player);
                if (list == null) {
                    list = new LinkedList();
                    this.queue.put(player, list);
                }
                list.addLast(content);
                this.queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(EntityPlayer player) {
            Object object = this.queue;
            synchronized (object) {
                this.queue.remove(player);
            }
            object = this.playersToClear;
            synchronized (object) {
                this.playersToClear.add(player);
            }
        }
    }

    private static class ServerCompressorThread
    extends Thread {
        private final HashMap<EntityPlayer, LinkedList<ModernPacket>> serverList = new HashMap();
        private final HashMap<EntityPlayer, byte[]> serverBuffer = new HashMap();
        private boolean pause = false;
        private Queue<EntityPlayer> playersToClear = new LinkedList<EntityPlayer>();

        public ServerCompressorThread() {
            super("LogisticsPipes Packet Compressor Server");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = this.serverList;
                synchronized (object) {
                    if (!this.pause) {
                        for (Map.Entry<EntityPlayer, LinkedList<ModernPacket>> playerPacketEntry : this.serverList.entrySet()) {
                            EntityPlayer player = playerPacketEntry.getKey();
                            this.serverBuffer.put(player, LPDataIOWrapper.collectData(output -> {
                                if (this.serverBuffer.containsKey(player)) {
                                    output.writeBytes(this.serverBuffer.get(player));
                                }
                                LinkedList packets = (LinkedList)playerPacketEntry.getValue();
                                try {
                                    for (ModernPacket packet : packets) {
                                        output.writeByteArray(LPDataIOWrapper.collectData(dataOutput -> {
                                            dataOutput.writeShort(packet.getId());
                                            dataOutput.writeInt(packet.getDebugId());
                                            packet.writeData(dataOutput);
                                        }));
                                    }
                                }
                                finally {
                                    packets.clear();
                                }
                            }));
                        }
                        this.serverList.clear();
                    }
                }
                for (Map.Entry entry : this.serverBuffer.entrySet()) {
                    byte[] sendbuffer;
                    while (((byte[])entry.getValue()).length > 32768) {
                        sendbuffer = Arrays.copyOf((byte[])entry.getValue(), 32768);
                        byte[] newbuffer = Arrays.copyOfRange((byte[])entry.getValue(), 32768, ((byte[])entry.getValue()).length);
                        entry.setValue(newbuffer);
                        byte[] compressed = ServerPacketBufferHandlerThread.compress(sendbuffer);
                        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(BufferTransfer.class).setContent(compressed), (EntityPlayer)entry.getKey());
                    }
                    sendbuffer = (byte[])entry.getValue();
                    byte[] compressed = ServerPacketBufferHandlerThread.compress(sendbuffer);
                    MainProxy.sendPacketToPlayer(PacketHandler.getPacket(BufferTransfer.class).setContent(compressed), (EntityPlayer)entry.getKey());
                }
                this.serverBuffer.clear();
                object = this.serverList;
                synchronized (object) {
                    while (this.pause || this.serverList.size() == 0) {
                        try {
                            this.serverList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                object = this.playersToClear;
                synchronized (object) {
                    EntityPlayer entityPlayer;
                    do {
                        if ((entityPlayer = this.playersToClear.poll()) == null) continue;
                        this.serverBuffer.remove(entityPlayer);
                    } while (entityPlayer != null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPacketToCompressor(ModernPacket packet, EntityPlayer player) {
            HashMap<EntityPlayer, LinkedList<ModernPacket>> hashMap = this.serverList;
            synchronized (hashMap) {
                LinkedList<ModernPacket> packetList = this.serverList.get(player);
                if (packetList == null) {
                    packetList = new LinkedList();
                    this.serverList.put(player, packetList);
                }
                packetList.add(packet);
                if (!this.pause) {
                    this.serverList.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPause(boolean flag) {
            HashMap<EntityPlayer, LinkedList<ModernPacket>> hashMap = this.serverList;
            synchronized (hashMap) {
                this.pause = flag;
                if (!this.pause) {
                    this.serverList.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(EntityPlayer player) {
            Object object = this.serverList;
            synchronized (object) {
                this.serverList.remove(player);
            }
            object = this.playersToClear;
            synchronized (object) {
                this.playersToClear.add(player);
            }
        }
    }
}

