/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import logisticspipes.LogisticsPipes;
import logisticspipes.asm.DevEnvHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public final class VersionChecker
implements Callable<VersionInfo> {
    public static final int COMMIT_MAX_LINE_LENGTH = 60;
    private static Future<VersionInfo> versionCheckFuture;
    private String statusString;
    private VersionInfo versionInfo = null;

    private VersionChecker() {
    }

    public static VersionChecker runVersionCheck() {
        VersionChecker obj = new VersionChecker();
        versionCheckFuture = LogisticsPipes.singleThreadExecutor.submit(obj);
        return obj;
    }

    public String getVersionCheckerStatus() {
        if (versionCheckFuture != null) {
            if (versionCheckFuture.isDone()) {
                this.statusString = this.internalGetVersionCheckerStatus();
                versionCheckFuture = null;
            } else {
                this.statusString = this.internalGetVersionCheckerStatus();
            }
        }
        return this.statusString;
    }

    public boolean isVersionCheckDone() {
        return this.versionInfo != null;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    private String internalGetVersionCheckerStatus() {
        if (versionCheckFuture.isDone()) {
            try {
                this.versionInfo = versionCheckFuture.get();
                if (this.versionInfo == null) {
                    if (DevEnvHelper.isDevelopmentEnvironment()) {
                        return "You are running Logistics Pipes from a development environment.";
                    }
                    return "It seems you are missing the current version information on Logistics Pipes. There is no version checking available.";
                }
                if (this.versionInfo.isNewVersionAvailable()) {
                    return "New Logistics Pipes build found: #" + this.versionInfo.getNewestBuild();
                }
                return "You have the newest Logistics Pipes build :)";
            }
            catch (InterruptedException e) {
                return "The version check task was interrupted and there is no version information available.";
            }
            catch (ExecutionException e) {
                LogisticsPipes.log.warn("The version check task had an exception while getting the newest version information", (Throwable)e);
                return "The version check task had an exception. See the log file for more information.";
            }
        }
        return "The version check is not yet ready, sorry.";
    }

    @Override
    public VersionInfo call() throws Exception {
        String jsonString;
        if ("0.10.2.211:false".equals("%VERSION%:%DEBUG%")) {
            return null;
        }
        VersionInfo versionInfo = new VersionInfo();
        URL url = new URL("http://rs485.network/version?VERSION=0.10.2.211:false");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        InputStream inputStream = (InputStream)conn.getContent();
        try (Scanner sc = new Scanner(inputStream);){
            sc.useDelimiter("\\A");
            jsonString = sc.next();
        }
        Gson gson = new Gson();
        LinkedTreeMap part = (LinkedTreeMap)gson.fromJson(jsonString, LinkedTreeMap.class);
        Boolean hasNew = (Boolean)part.get((Object)"new");
        versionInfo.setNewVersionAvailable(hasNew);
        if (hasNew.booleanValue()) {
            versionInfo.setNewestBuild(String.valueOf(part.get((Object)"build")));
            LogisticsPipes.log.info("New Logistics Pipes build found: #" + versionInfo.getNewestBuild());
            LinkedTreeMap changelog = (LinkedTreeMap)part.get((Object)"changelog");
            ArrayList<String> changeLogList = new ArrayList<String>();
            if (changelog != null) {
                for (String build : changelog.keySet()) {
                    changeLogList.add(build + ": ");
                    for (String commit : (List)changelog.get((Object)build)) {
                        if (commit.length() > 60) {
                            String prefix = "    ";
                            boolean first = true;
                            while (!commit.isEmpty()) {
                                int maxLength = first ? 60 : 60 - prefix.length();
                                int splitAt = commit.substring(0, Math.min(maxLength, commit.length())).lastIndexOf(32);
                                if (commit.length() < 60) {
                                    splitAt = commit.length();
                                }
                                if (splitAt <= 0) {
                                    splitAt = Math.min(maxLength, commit.length());
                                } else if (commit.length() > 60 && splitAt < 40) {
                                    splitAt = Math.min(maxLength, commit.length());
                                }
                                changeLogList.add((first ? "" : prefix) + commit.substring(0, splitAt));
                                commit = commit.substring(splitAt);
                                first = false;
                            }
                            continue;
                        }
                        changeLogList.add(commit);
                    }
                }
            }
            versionInfo.setChangelog(changeLogList);
            this.sendIMCOutdatedMessage(versionInfo);
        }
        return versionInfo;
    }

    private void sendIMCOutdatedMessage(VersionInfo versionInfo) {
        if (Loader.isModLoaded((String)"VersionChecker")) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("oldVersion", "0.10.2.211:false");
            tag.func_74778_a("newVersion", versionInfo.getNewestBuild());
            tag.func_74778_a("updateUrl", "http://ci.rs485.network/view/Logistics%20Pipes/");
            tag.func_74757_a("isDirectLink", false);
            StringBuilder stringBuilder = new StringBuilder();
            for (String changeLogLine : versionInfo.getChangelog()) {
                stringBuilder.append(changeLogLine).append("\n");
            }
            tag.func_74778_a("changeLog", stringBuilder.toString());
            FMLInterModComms.sendRuntimeMessage((Object)"LogisticsPipes", (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)tag);
            versionInfo.setImcMessageSent(true);
        }
    }

    public static class VersionInfo {
        private boolean newVersionAvailable;
        private boolean imcMessageSent;
        private String newestBuild;
        private List<String> changelog;

        public boolean isNewVersionAvailable() {
            return this.newVersionAvailable;
        }

        public boolean isImcMessageSent() {
            return this.imcMessageSent;
        }

        public String getNewestBuild() {
            return this.newestBuild;
        }

        public List<String> getChangelog() {
            return this.changelog;
        }

        public VersionInfo setNewVersionAvailable(boolean newVersionAvailable) {
            this.newVersionAvailable = newVersionAvailable;
            return this;
        }

        public VersionInfo setImcMessageSent(boolean imcMessageSent) {
            this.imcMessageSent = imcMessageSent;
            return this;
        }

        public VersionInfo setNewestBuild(String newestBuild) {
            this.newestBuild = newestBuild;
            return this;
        }

        public VersionInfo setChangelog(List<String> changelog) {
            this.changelog = changelog;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VersionInfo)) {
                return false;
            }
            VersionInfo other = (VersionInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNewVersionAvailable() != other.isNewVersionAvailable()) {
                return false;
            }
            if (this.isImcMessageSent() != other.isImcMessageSent()) {
                return false;
            }
            String this$newestBuild = this.getNewestBuild();
            String other$newestBuild = other.getNewestBuild();
            if (this$newestBuild == null ? other$newestBuild != null : !this$newestBuild.equals(other$newestBuild)) {
                return false;
            }
            List<String> this$changelog = this.getChangelog();
            List<String> other$changelog = other.getChangelog();
            return !(this$changelog == null ? other$changelog != null : !((Object)this$changelog).equals(other$changelog));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VersionInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNewVersionAvailable() ? 79 : 97);
            result = result * 59 + (this.isImcMessageSent() ? 79 : 97);
            String $newestBuild = this.getNewestBuild();
            result = result * 59 + ($newestBuild == null ? 43 : $newestBuild.hashCode());
            List<String> $changelog = this.getChangelog();
            result = result * 59 + ($changelog == null ? 43 : ((Object)$changelog).hashCode());
            return result;
        }

        public String toString() {
            return "VersionChecker.VersionInfo(newVersionAvailable=" + this.isNewVersionAvailable() + ", imcMessageSent=" + this.isImcMessageSent() + ", newestBuild=" + this.getNewestBuild() + ", changelog=" + this.getChangelog() + ")";
        }
    }
}

