/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import java.util.List;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.proxy.MainProxy;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeTransportLogistics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;

public class PipeMultiBlockTransportLogistics
extends PipeTransportLogistics {
    private CoreMultiBlockPipe multiPipe;

    public PipeMultiBlockTransportLogistics() {
        super(false);
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, EnumFacing side) {
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe != null && ((LogisticsTileGenericPipe)tile).pipe.isHSTube()) {
            return true;
        }
        if (tile instanceof LogisticsTileGenericSubMultiBlock && ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe() != null && !((LogisticsTileGenericSubMultiBlock)tile).getMainPipe().isEmpty()) {
            for (LogisticsTileGenericPipe pipe : ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe()) {
                if (pipe.pipe != null && pipe.pipe.isHSTube()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public CoreMultiBlockPipe getMultiPipe() {
        CoreUnroutedPipe uPipe;
        if (this.multiPipe == null && (uPipe = this.getPipe()) instanceof CoreMultiBlockPipe) {
            this.multiPipe = (CoreMultiBlockPipe)uPipe;
        }
        return this.multiPipe;
    }

    @Override
    public float getPipeLength() {
        if (this.getMultiPipe() != null) {
            return this.getMultiPipe().getPipeLength();
        }
        return super.getPipeLength();
    }

    @Override
    public double getDistanceWeight() {
        if (this.getMultiPipe() != null) {
            return this.getMultiPipe().getDistanceWeight();
        }
        return super.getDistanceWeight();
    }

    @Override
    public float getYawDiff(LPTravelingItem item) {
        if (this.getMultiPipe() != null) {
            return this.getMultiPipe().getYawDiff(item);
        }
        return super.getYawDiff(item);
    }

    @Override
    public PipeTransportLogistics.RoutingResult resolveDestination(LPTravelingItem.LPTravelingItemServer data) {
        if (this.getMultiPipe() == null) {
            return new PipeTransportLogistics.RoutingResult(null, false);
        }
        return new PipeTransportLogistics.RoutingResult(this.getMultiPipe().getExitForInput(data.input.func_176734_d()), true);
    }

    @Override
    protected void reachedEnd(LPTravelingItem item) {
        TileEntity tile = null;
        if (this.getMultiPipe() != null) {
            tile = this.getMultiPipe().getConnectedEndTile(item.output);
        }
        if (this.items.scheduleRemoval(item)) {
            if (MainProxy.isServer((IBlockAccess)this.container.func_145831_w())) {
                this.handleTileReachedServer((LPTravelingItem.LPTravelingItemServer)item, tile, item.output);
            } else {
                this.handleTileReachedClient((LPTravelingItem.LPTravelingItemClient)item, tile, item.output);
            }
        }
    }

    @Override
    protected void handleTileReachedServer(LPTravelingItem.LPTravelingItemServer arrivingItem, TileEntity tile, EnumFacing dir) {
        List<LogisticsTileGenericPipe> masterTile;
        this.markChunkModified(tile);
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof CoreMultiBlockPipe) {
            this.passToNextPipe(arrivingItem, tile);
            return;
        }
        if (tile instanceof LogisticsTileGenericSubMultiBlock && !(masterTile = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe()).isEmpty()) {
            if (masterTile.size() > 1) {
                throw new UnsupportedOperationException();
            }
            this.passToNextPipe(arrivingItem, masterTile.get(0));
            return;
        }
        Explosion explosion = new Explosion(this.getWorld(), null, (double)this.getPipe().getX(), (double)this.getPipe().getY(), (double)this.getPipe().getZ(), 4.0f, false, true);
        explosion.func_77279_a(true);
    }

    @Override
    protected void handleTileReachedClient(LPTravelingItem.LPTravelingItemClient arrivingItem, TileEntity tile, EnumFacing dir) {
        List<LogisticsTileGenericPipe> masterTile;
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof CoreMultiBlockPipe) {
            this.passToNextPipe(arrivingItem, tile);
            return;
        }
        if (tile instanceof LogisticsTileGenericSubMultiBlock && !(masterTile = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe()).isEmpty()) {
            if (masterTile.size() > 1) {
                throw new UnsupportedOperationException();
            }
            this.passToNextPipe(arrivingItem, masterTile.get(0));
            return;
        }
        Explosion explosion = new Explosion(this.getWorld(), null, (double)this.getPipe().getX(), (double)this.getPipe().getY(), (double)this.getPipe().getZ(), 4.0f, false, true);
        explosion.func_77279_a(true);
    }

    @Override
    public void readjustSpeed(LPTravelingItem.LPTravelingItemServer item) {
        item.setSpeed(0.8f);
    }

    @Override
    public CoreUnroutedPipe getNextPipe(EnumFacing output) {
        List<LogisticsTileGenericPipe> list;
        TileEntity tile = null;
        if (this.getMultiPipe() != null) {
            tile = this.getMultiPipe().getConnectedEndTile(output);
        }
        if (tile instanceof LogisticsTileGenericSubMultiBlock && !(list = ((LogisticsTileGenericSubMultiBlock)tile).getMainPipe()).isEmpty()) {
            if (list.size() > 1) {
                throw new UnsupportedOperationException();
            }
            tile = list.get(0);
        }
        if (tile instanceof LogisticsTileGenericPipe) {
            return ((LogisticsTileGenericPipe)tile).pipe;
        }
        return null;
    }
}

