/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.HashSet;
import logisticspipes.utils.IPositionRotateble;
import net.minecraft.util.math.AxisAlignedBB;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class LPPositionSet<T extends DoubleCoordinates>
extends HashSet<T>
implements IPositionRotateble {
    private static final long serialVersionUID = -3611750920959862658L;
    private Class<T> clazz;

    public LPPositionSet(Class<?> clazz) {
        this.clazz = clazz;
    }

    public int getMaxX() {
        return (int)this.getMaxXD();
    }

    public int getMaxY() {
        return (int)this.getMaxYD();
    }

    public int getMaxZ() {
        return (int)this.getMaxZD();
    }

    public int getMinX() {
        return (int)this.getMaxXD();
    }

    public int getMinY() {
        return (int)this.getMaxYD();
    }

    public int getMinZ() {
        return (int)this.getMaxZD();
    }

    public double getMaxXD() {
        double x = -1.7976931348623157E308;
        for (DoubleCoordinates pos : this) {
            x = Math.max(x, pos.getXDouble());
        }
        return x;
    }

    public double getMaxYD() {
        double y = -1.7976931348623157E308;
        for (DoubleCoordinates pos : this) {
            y = Math.max(y, pos.getYDouble());
        }
        return y;
    }

    public double getMaxZD() {
        double z = -1.7976931348623157E308;
        for (DoubleCoordinates pos : this) {
            z = Math.max(z, pos.getZDouble());
        }
        return z;
    }

    public double getMinXD() {
        double x = Double.MAX_VALUE;
        for (DoubleCoordinates pos : this) {
            x = Math.min(x, pos.getXDouble());
        }
        return x;
    }

    public double getMinYD() {
        double y = Double.MAX_VALUE;
        for (DoubleCoordinates pos : this) {
            y = Math.min(y, pos.getYDouble());
        }
        return y;
    }

    public double getMinZD() {
        double z = Double.MAX_VALUE;
        for (DoubleCoordinates pos : this) {
            z = Math.min(z, pos.getZDouble());
        }
        return z;
    }

    public void addToAll(DoubleCoordinates lpPosition) {
        for (DoubleCoordinates pos : this) {
            pos.add(lpPosition);
        }
    }

    @Override
    public void rotateLeft() {
        this.forEach(DoubleCoordinates::rotateLeft);
    }

    @Override
    public void rotateRight() {
        this.forEach(DoubleCoordinates::rotateRight);
    }

    public AxisAlignedBB toABB() {
        return new AxisAlignedBB(this.getMinXD(), this.getMinYD(), this.getMinZD(), this.getMaxXD(), this.getMaxYD(), this.getMaxZD());
    }

    @Override
    public void mirrorX() {
        this.forEach(DoubleCoordinates::mirrorX);
    }

    @Override
    public void mirrorZ() {
        this.forEach(DoubleCoordinates::mirrorZ);
    }

    public void addFrom(AxisAlignedBB completeBox) {
        this.add(this.clazz.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE).newInstance(completeBox.field_72340_a, completeBox.field_72338_b, completeBox.field_72339_c));
        this.add(this.clazz.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE).newInstance(completeBox.field_72336_d, completeBox.field_72337_e, completeBox.field_72334_f));
    }

    public DoubleCoordinates getCenter() {
        return new DoubleCoordinates((this.getMaxXD() - this.getMinXD()) / 2.0 + this.getMinXD(), (this.getMaxYD() - this.getMinYD()) / 2.0 + this.getMinYD(), (this.getMaxZD() - this.getMinZD()) / 2.0 + this.getMinZD());
    }

    public T findClosest(DoubleCoordinates posToLookFor) {
        double distance = Double.MAX_VALUE;
        DoubleCoordinates closest = null;
        for (DoubleCoordinates posToLookAt : this) {
            if (closest != null && !(posToLookFor.distanceTo(posToLookAt) < distance)) continue;
            closest = posToLookAt;
            distance = posToLookFor.distanceTo(posToLookAt);
        }
        return (T)closest;
    }
}

