/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import logisticspipes.LPConstants;
import logisticspipes.utils.tuples.Pair;
import scala.actors.threadpool.Arrays;

public class StackTraceUtil {
    private static final Map<Thread, LinkedList<Pair<StackTraceElement, String>>> informationMap = new HashMap<Thread, LinkedList<Pair<StackTraceElement, String>>>();

    private static LinkedList<Pair<StackTraceElement, String>> getList() {
        return informationMap.computeIfAbsent(Thread.currentThread(), k -> new LinkedList());
    }

    public static Info addTraceInformation(Supplier<String> informationSupplier, Info ... infos) {
        if (!LPConstants.DEBUG) {
            return new DummyInfo();
        }
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        StackTraceElement calledFrom = trace[2];
        return StackTraceUtil.addTraceInformationFor(calledFrom, informationSupplier.get(), infos);
    }

    public static Info addSuperTraceInformation(Supplier<String> informationSupplier, Info ... infos) {
        if (!LPConstants.DEBUG) {
            return new DummyInfo();
        }
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        StackTraceElement calledFrom = trace[3];
        return StackTraceUtil.addTraceInformationFor(calledFrom, informationSupplier.get(), infos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Info addTraceInformationFor(final StackTraceElement calledFrom, String information, final Info ... infos) {
        Map<Thread, LinkedList<Pair<StackTraceElement, String>>> map = informationMap;
        synchronized (map) {
            StackTraceUtil.getList().addLast(new Pair<StackTraceElement, String>(calledFrom, information));
            return new Info(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void end() {
                    Info[] infoArray = informationMap;
                    synchronized (infoArray) {
                        if (StackTraceUtil.getList().isEmpty()) {
                            throw new RuntimeException("There are to many end() calls");
                        }
                        Pair pair = (Pair)StackTraceUtil.getList().getLast();
                        if (!((StackTraceElement)pair.getValue1()).equals(calledFrom)) {
                            System.out.println("Found: " + pair.getValue1());
                            System.out.println("Looking for: " + calledFrom);
                            throw new RuntimeException("There is an end() call missing");
                        }
                        StackTraceUtil.getList().removeLast();
                    }
                    if (infos != null) {
                        for (Info info : infos) {
                            info.end();
                        }
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void printTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            Map<Thread, LinkedList<Pair<StackTraceElement, String>>> map = informationMap;
            synchronized (map) {
                LinkedList traceList = new LinkedList(Arrays.asList((Object[])Thread.currentThread().getStackTrace()));
                traceList.removeFirst();
                traceList.removeFirst();
                LinkedList<Pair<StackTraceElement, void>> paired = new LinkedList<Pair<StackTraceElement, void>>();
                Pair lastFound = null;
                StackTraceElement current = (StackTraceElement)traceList.removeLast();
                while (current != null) {
                    void var7_7;
                    Iterator iter = StackTraceUtil.getList().iterator();
                    if (lastFound != null) {
                        Pair pair;
                        while (iter.hasNext() && (pair = (Pair)iter.next()) != lastFound) {
                        }
                    }
                    Object var7_10 = null;
                    while (iter.hasNext()) {
                        Pair pair = (Pair)iter.next();
                        if (!StackTraceUtil.compare(current, (StackTraceElement)pair.getValue1())) continue;
                        lastFound = pair;
                        String string = (String)pair.getValue2();
                    }
                    paired.addFirst(new Pair<StackTraceElement, void>(current, var7_7));
                    if (traceList.isEmpty()) {
                        current = null;
                        continue;
                    }
                    current = (StackTraceElement)traceList.removeLast();
                }
                System.err.print("StackTrace");
                System.err.print(System.lineSeparator());
                for (Pair pair : paired) {
                    System.err.print("\tat " + pair.getValue1());
                    if (pair.getValue2() != null) {
                        System.err.print(" [" + (String)pair.getValue2() + "]");
                    }
                    System.err.print(System.lineSeparator());
                }
                System.err.print("StackTrace end");
                System.err.print(System.lineSeparator());
            }
        }
    }

    private static boolean compare(StackTraceElement called, StackTraceElement infoProvider) {
        return called.getClassName().equals(infoProvider.getClassName()) && called.getMethodName().equals(infoProvider.getMethodName()) && called.getFileName().equals(infoProvider.getFileName()) && called.getLineNumber() >= infoProvider.getLineNumber();
    }

    private static class DummyInfo
    extends Info {
        private DummyInfo() {
        }

        @Override
        public void end() {
        }
    }

    public static abstract class Info {
        public abstract void end();
    }
}

