/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;

public class InputBar
extends GuiTextField
implements LogisticsBaseGuiScreen.EventListener {
    public int minNumber = 0;

    public InputBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int height) {
        this(fontRenderer, screen, left, top, width, height, true);
    }

    public InputBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int height, boolean isActive) {
        this(fontRenderer, screen, left, top, width, height, isActive, false);
    }

    public InputBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int height, boolean isActive, boolean numberOnly) {
        this(fontRenderer, screen, left, top, width, height, isActive, numberOnly, Align.LEFT);
    }

    public InputBar(FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, int left, int top, int width, int height, boolean isActive, boolean numberOnly, Align align) {
        super(0, fontRenderer, left + 2, top, width - 4, height - 2);
        screen.onGuiEvents.add(this);
        if (numberOnly) {
            this.func_175205_a(s -> {
                try {
                    return Integer.parseInt(s) >= this.minNumber;
                }
                catch (NumberFormatException ignored) {
                    return false;
                }
            });
            this.func_146203_f(5);
        } else {
            this.func_146203_f(128);
        }
    }

    public void reposition(int left, int top, int width, int height) {
        this.field_146209_f = left + 2;
        this.field_146210_g = top;
        this.field_146218_h = width - 4;
        this.field_146219_i = height - 2;
    }

    @Override
    public void onUpdateScreen() {
        this.func_146178_a();
    }

    @Override
    public boolean onKeyboardInput() {
        return (this.func_146206_l() || GuiScreen.func_175283_s()) && ChatAllowedCharacters.func_71566_a((char)Keyboard.getEventCharacter());
    }

    public boolean handleClick(int x, int y, int k) {
        if (k == 1 && x >= this.field_146209_f && x < this.field_146209_f + this.field_146218_h && y >= this.field_146210_g && y < y + this.field_146219_i) {
            this.func_146180_a("");
        }
        return this.func_146192_a(x, y, k);
    }

    public boolean handleKey(char c, int i) {
        if (GuiScreen.func_175280_f((int)i) && this.func_146207_c().isEmpty()) {
            GuiScreen.func_146275_d((String)this.func_146179_b());
        }
        return this.func_146201_a(c, i);
    }

    public void setInteger(int newValue) {
        this.func_146180_a(Integer.toString(Math.max(this.minNumber, newValue)));
    }

    public int getInteger() {
        try {
            return Math.max(this.minNumber, Integer.parseInt(this.func_146179_b()));
        }
        catch (NumberFormatException ignored) {
            return this.minNumber;
        }
    }

    public boolean isEmpty() {
        return this.func_146179_b().isEmpty();
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

