/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.LinkedList;
import javax.annotation.Nonnull;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public final class ItemIdentifierStack
implements Comparable<ItemIdentifierStack>,
ILPCCTypeHolder {
    private Object ccType;
    private final ItemIdentifier _item;
    private int stackSize;

    public static ItemIdentifierStack getFromStack(ItemStack stack) {
        return new ItemIdentifierStack(ItemIdentifier.get(stack), stack.func_190916_E());
    }

    public ItemIdentifierStack(ItemIdentifier item, int stackSize) {
        this._item = item;
        this.setStackSize(stackSize);
    }

    public ItemIdentifier getItem() {
        return this._item;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(int stackSize) {
        this.stackSize = stackSize;
    }

    public void lowerStackSize(int stackSize) {
        this.stackSize -= stackSize;
    }

    public ItemStack unsafeMakeNormalStack() {
        return this._item.unsafeMakeNormalStack(this.stackSize);
    }

    @Nonnull
    public ItemStack makeNormalStack() {
        return this._item.makeNormalStack(this.stackSize);
    }

    @Nonnull
    public EntityItem makeEntityItem(World world, double x, double y, double z) {
        return this._item.makeEntityItem(this.stackSize, world, x, y, z);
    }

    public boolean equals(Object that) {
        if (that instanceof ItemIdentifierStack) {
            ItemIdentifierStack stack = (ItemIdentifierStack)that;
            return stack._item.equals(this._item) && stack.getStackSize() == this.getStackSize();
        }
        if (that instanceof ItemIdentifier) {
            throw new IllegalStateException("Comparison between ItemIdentifierStack and ItemIdentifier -- did you forget a .getItem() in your code?");
        }
        return false;
    }

    public int hashCode() {
        return this._item.hashCode() ^ 1023 * this.getStackSize();
    }

    public String toString() {
        return String.format("%dx %s", this.getStackSize(), this._item.toString());
    }

    public ItemIdentifierStack clone() {
        return new ItemIdentifierStack(this._item, this.getStackSize());
    }

    public String getFriendlyName() {
        return this.getStackSize() + " " + this._item.getFriendlyName();
    }

    public static LinkedList<ItemIdentifierStack> getListFromInventory(IInventory inv) {
        return ItemIdentifierStack.getListFromInventory(inv, false);
    }

    public static LinkedList<ItemIdentifierStack> getListFromInventory(IInventory inv, boolean removeNull) {
        LinkedList<ItemIdentifierStack> list = new LinkedList<ItemIdentifierStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) {
                if (removeNull) continue;
                list.add(null);
                continue;
            }
            list.add(ItemIdentifierStack.getFromStack(inv.func_70301_a(i)));
        }
        return list;
    }

    public static LinkedList<ItemIdentifierStack> getListSendQueue(LinkedList<Triplet<IRoutedItem, EnumFacing, CoreRoutedPipe.ItemSendMode>> _sendQueue) {
        LinkedList<ItemIdentifierStack> list = new LinkedList<ItemIdentifierStack>();
        for (Triplet triplet : _sendQueue) {
            if (triplet == null) {
                list.add(null);
                continue;
            }
            boolean added = false;
            for (ItemIdentifierStack stack : list) {
                if (!stack.getItem().equals(((IRoutedItem)triplet.getValue1()).getItemIdentifierStack().getItem())) continue;
                stack.setStackSize(stack.getStackSize() + ((IRoutedItem)triplet.getValue1()).getItemIdentifierStack().stackSize);
                added = true;
                break;
            }
            if (added) continue;
            list.add(((IRoutedItem)triplet.getValue1()).getItemIdentifierStack().clone());
        }
        return list;
    }

    @Override
    public int compareTo(ItemIdentifierStack o) {
        int c = this._item.compareTo(o._item);
        if (c == 0) {
            return this.getStackSize() - o.getStackSize();
        }
        return c;
    }

    @Override
    public void setCCType(Object type) {
        this.ccType = type;
    }

    @Override
    public Object getCCType() {
        return this.ccType;
    }
}

