/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.math;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.utils.math.Vector2f;
import logisticspipes.utils.math.Vector3d;
import logisticspipes.utils.math.Vector3f;
import logisticspipes.utils.math.Vertex;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class BoundingBox {
    public static final BoundingBox UNIT_CUBE = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;

    public BoundingBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public BoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = (float)minX;
        this.minY = (float)minY;
        this.minZ = (float)minZ;
        this.maxX = (float)maxX;
        this.maxY = (float)maxY;
        this.maxZ = (float)maxZ;
    }

    public BoundingBox(DoubleCoordinates bc) {
        this(bc.getXDouble(), bc.getYDouble(), bc.getZDouble(), bc.getXDouble() + 1.0, bc.getYDouble() + 1.0, bc.getZDouble() + 1.0);
    }

    @Nonnull
    public List<Vertex> getCornersWithUvForFace(@Nonnull EnumFacing face, float minU, float maxU, float minV, float maxV) {
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(minU, maxV)));
                break;
            }
            case SOUTH: {
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(maxU, maxV)));
                break;
            }
            case EAST: {
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.minZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.maxZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.maxZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.minZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            case WEST: {
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.minZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.maxZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.maxZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.minZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(maxU, maxV)));
                break;
            }
            case UP: {
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.maxZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.minZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.minZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.maxZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            case DOWN: {
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.minZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.minZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.maxZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.maxZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown side");
            }
        }
        return result;
    }
}

