/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.math;

import java.beans.ConstructorProperties;

public class Vector3f {
    public float x;
    public float y;
    public float z;

    public Vector3f(Vector3f vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
    }

    public static Vector3f getFromAngles(double Yaw, double Pitch) {
        Vector3f vector = new Vector3f();
        vector.x = (float)(Math.cos(Yaw) * Math.cos(Pitch));
        vector.y = (float)Math.sin(Pitch);
        vector.z = (float)(Math.sin(Yaw) * Math.cos(Pitch));
        return vector;
    }

    public Vector3f multiply(double i) {
        this.x = (float)((double)this.x * i);
        this.y = (float)((double)this.y * i);
        this.z = (float)((double)this.z * i);
        return this;
    }

    public double abs() {
        return Math.hypot(this.x, Math.hypot(this.y, this.z));
    }

    public Vector3f add(Vector3f vector, double factor) {
        Vector3f lVector = vector.clone().makeVectorLength(factor);
        this.x += lVector.x;
        this.y += lVector.y;
        this.z += lVector.z;
        return this;
    }

    public Vector3f add(Vector3f vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
        return this;
    }

    public Vector3f sub(Vector3f vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
        return this;
    }

    public Vector3f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f getOrtogonal(Float pX, Float pY, Float pZ) {
        if (pX != null && pY != null && pZ != null || pX == null && pY == null || pY == null && pZ == null || pX == null && pZ == null) {
            throw new UnsupportedOperationException("One, only one parameter needs to be null");
        }
        Vector3f answer = new Vector3f();
        if (pX == null) {
            answer.x = (-pY.floatValue() * this.y - pZ.floatValue() * this.z) / this.x;
            answer.y = pY.floatValue();
            answer.z = pZ.floatValue();
        } else if (pY == null) {
            answer.x = pX.floatValue();
            answer.y = (-pX.floatValue() * this.x - pZ.floatValue() * this.z) / this.y;
            answer.z = pZ.floatValue();
        } else if (pZ == null) {
            answer.x = pX.floatValue();
            answer.y = pY.floatValue();
            answer.z = (-pX.floatValue() * this.x - pY.floatValue() * this.y) / this.z;
        }
        return answer;
    }

    public Vector3f makeVectorLength(double length) {
        double divide = Math.sqrt(Math.pow(this.abs(), 2.0) / Math.pow(length, 2.0));
        double multiply = 1.0 / divide;
        this.x = (float)((double)this.x * multiply);
        this.y = (float)((double)this.y * multiply);
        this.z = (float)((double)this.z * multiply);
        return this;
    }

    public String toString() {
        return String.format("[%s,%s,%s](%s)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), this.abs());
    }

    public Vector3f clone() {
        Vector3f vector = new Vector3f();
        vector.x = this.x;
        vector.y = this.y;
        vector.z = this.z;
        return vector;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Vector3f vector3d) {
        this.set(vector3d.x, vector3d.y, vector3d.z);
    }

    public void cross(Vector3f v1, Vector3f v2) {
        this.x = v1.y * v2.z - v1.z * v2.y;
        this.y = v2.x * v1.z - v2.z * v1.x;
        this.z = v1.x * v2.y - v1.y * v2.x;
    }

    public void normalize() {
        this.makeVectorLength(1.0);
    }

    @ConstructorProperties(value={"x", "y", "z"})
    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f() {
    }
}

