/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.blocks;

import com.nekokittygames.thaumictinkerer.common.blocks.TTBlock;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TTTileEntity<TE extends TileEntity>
extends TTBlock {
    private final boolean preserveTileEntity;

    public TTTileEntity(String name, Material blockMaterialIn, MapColor blockMapColorIn, boolean preserveTileEntity) {
        super(name, blockMaterialIn, blockMapColorIn);
        this.preserveTileEntity = preserveTileEntity;
    }

    public TTTileEntity(String name, Material materialIn, boolean preserveTileEntity) {
        super(name, materialIn);
        this.preserveTileEntity = preserveTileEntity;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    @Nullable
    protected TE getTileEntity(IBlockAccess world, BlockPos pos) {
        return (TE)world.func_175625_s(pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return this.preserveTileEntity && willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        if (this.preserveTileEntity) {
            world.func_175698_g(pos);
        }
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }
}

