/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio;

import exnihilocreatio.ExNihiloCreatio;
import exnihilocreatio.ModBlocks;
import exnihilocreatio.blocks.ItemBlockCrucible;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.items.ItemCookedSilkworm;
import exnihilocreatio.items.ItemDoll;
import exnihilocreatio.items.ItemMesh;
import exnihilocreatio.items.ItemPebble;
import exnihilocreatio.items.ItemResource;
import exnihilocreatio.items.ore.EnumOreSubtype;
import exnihilocreatio.items.ore.ItemOre;
import exnihilocreatio.items.seeds.ItemRubberSeed;
import exnihilocreatio.items.seeds.ItemSeedBase;
import exnihilocreatio.items.tools.CrookBase;
import exnihilocreatio.items.tools.EnumCrook;
import exnihilocreatio.items.tools.HammerBase;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.util.Data;
import exnihilocreatio.util.IHasModel;
import exnihilocreatio.util.IHasSpecialRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModItems {
    public static final HammerBase hammerWood = new HammerBase("hammer_wood", 64, Item.ToolMaterial.WOOD);
    public static final HammerBase hammerStone = new HammerBase("hammer_stone", 128, Item.ToolMaterial.STONE);
    public static final HammerBase hammerIron = new HammerBase("hammer_iron", 512, Item.ToolMaterial.IRON);
    public static final HammerBase hammerDiamond = new HammerBase("hammer_diamond", 4096, Item.ToolMaterial.DIAMOND);
    public static final HammerBase hammerGold = new HammerBase("hammer_gold", 64, Item.ToolMaterial.GOLD);
    public static final ItemMesh mesh;
    public static final ItemResource resources;
    public static final ItemCookedSilkworm cookedSilkworm;
    public static final ItemPebble pebbles;
    public static final ItemDoll dolls;
    public static final ArrayList<ItemSeedBase> itemSeeds;
    public static ItemRubberSeed rubberSeed;

    public static void registerItems(IForgeRegistry<Item> registry) {
        for (Item item : Data.ITEMS) {
            if (item instanceof IHasSpecialRegistry) continue;
            registry.register((IForgeRegistryEntry)item);
        }
        for (Block block : Data.BLOCKS) {
            if (block instanceof IHasSpecialRegistry) continue;
            registry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
        }
        registry.register((IForgeRegistryEntry)new ItemBlockCrucible(ModBlocks.crucibleStone));
    }

    public static void registerItemsLowest(IForgeRegistry<Item> registry) {
        ExNihiloRegistryManager.ORE_REGISTRY.loadJson(new File(ExNihiloCreatio.configDirectory, "OreRegistry.json"));
        ExNihiloRegistryManager.ORE_REGISTRY.registerToGameRegistry(registry);
        ExNihiloRegistryManager.ORE_REGISTRY.doRecipes();
        ModItems.registerOredicts();
    }

    private static void registerOredicts() {
        OreDictionary.registerOre((String)"clayPorcelain", (ItemStack)ItemResource.getResourceStack("porcelain_clay"));
        OreDictionary.registerOre((String)"gearStone", (ItemStack)ItemResource.getResourceStack("gear_stone"));
        OreDictionary.registerOre((String)"stickStone", (ItemStack)ItemResource.getResourceStack("rod_stone"));
        OreDictionary.registerOre((String)"rodStone", (ItemStack)ItemResource.getResourceStack("rod_stone"));
        OreDictionary.registerOre((String)"dust", (Block)ModBlocks.dust);
        OreDictionary.registerOre((String)"crushedGranite", (Block)ModBlocks.crushedGranite);
        OreDictionary.registerOre((String)"crushedAndesite", (Block)ModBlocks.crushedAndesite);
        OreDictionary.registerOre((String)"crushedDiorite", (Block)ModBlocks.crushedDiorite);
        if (ModConfig.misc.oredictVanillaItems) {
            OreDictionary.registerOre((String)"flower", (ItemStack)new ItemStack((Block)Blocks.field_150328_O, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"flower", (ItemStack)new ItemStack((Block)Blocks.field_150398_cm, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"flower", (ItemStack)new ItemStack((Block)Blocks.field_150327_N, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_151083_be);
            OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_151077_bg);
            OreDictionary.registerOre((String)"listAllmeatcooked", (ItemStack)new ItemStack(Items.field_179566_aV, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_151157_am);
            OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_179557_bn);
            OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_179559_bp);
        }
        if (ModConfig.misc.oredictExNihiloSeeds) {
            for (ItemSeedBase seed : itemSeeds) {
                OreDictionary.registerOre((String)"listAllseed", (Item)seed);
            }
            if (Item.field_150901_e.func_148741_d((Object)rubberSeed.getRegistryName())) {
                OreDictionary.registerOre((String)"listAllseed", (Item)rubberSeed);
            }
            OreDictionary.registerOre((String)"listAllseed", (ItemStack)new ItemStack((Item)resources, 1, 4));
        }
        ItemOre oreYellorium = ExNihiloRegistryManager.ORE_REGISTRY.getOreItem("yellorium");
        if (ModConfig.compatibility.addYelloriteOreDict && oreYellorium != null) {
            OreDictionary.registerOre((String)"oreYellorite", (ItemStack)new ItemStack((Item)oreYellorium, 1, EnumOreSubtype.CHUNK.getMeta()));
            OreDictionary.registerOre((String)"oreUranium", (ItemStack)new ItemStack((Item)oreYellorium, 1, EnumOreSubtype.CHUNK.getMeta()));
            OreDictionary.registerOre((String)"dustUranium", (ItemStack)new ItemStack((Item)oreYellorium, 1, EnumOreSubtype.DUST.getMeta()));
            OreDictionary.registerOre((String)"pieceUranium", (ItemStack)new ItemStack((Item)oreYellorium, 1, EnumOreSubtype.PIECE.getMeta()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModels(ModelRegistryEvent e) {
        for (Item item : Data.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).initModel(e);
        }
    }

    static {
        for (EnumCrook crook : EnumCrook.values()) {
            CrookBase crookItem = new CrookBase(crook.getRegistryName(), crook.getDurability(), crook.getDefaultLevel());
            if (crook != EnumCrook.BLAZE) continue;
            crookItem.func_77656_e(3);
        }
        mesh = new ItemMesh();
        resources = new ItemResource();
        cookedSilkworm = new ItemCookedSilkworm();
        pebbles = new ItemPebble();
        dolls = new ItemDoll();
        itemSeeds = new ArrayList<ItemSeedBase>(Arrays.asList(new ItemSeedBase("oak", Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.OAK)), new ItemSeedBase("spruce", Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.SPRUCE)), new ItemSeedBase("birch", Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.BIRCH)), new ItemSeedBase("jungle", Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.JUNGLE)), new ItemSeedBase("acacia", Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.ACACIA)), new ItemSeedBase("darkoak", Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.DARK_OAK)), new ItemSeedBase("cactus", Blocks.field_150434_aF.func_176223_P()).setPlantType(EnumPlantType.Desert), new ItemSeedBase("sugarcane", Blocks.field_150436_aH.func_176223_P()).setPlantType(EnumPlantType.Beach), new ItemSeedBase("carrot", Blocks.field_150459_bM.func_176223_P()).setPlantType(EnumPlantType.Crop), new ItemSeedBase("potato", Blocks.field_150469_bN.func_176223_P()).setPlantType(EnumPlantType.Crop)));
    }
}

