/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.barrel;

import exnihilocreatio.barrel.IBarrelMode;
import exnihilocreatio.networking.MessageBarrelModeUpdate;
import exnihilocreatio.networking.PacketHandler;
import exnihilocreatio.registries.registries.BarrelModeRegistry;
import exnihilocreatio.tiles.TileBarrel;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelItemHandler
extends ItemStackHandler {
    private final TileBarrel barrel;

    public BarrelItemHandler(TileBarrel barrel) {
        super(1);
        this.barrel = barrel;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.barrel.getMode() != null && this.barrel.getMode().getHandler(this.barrel) != null) {
            return this.barrel.getMode().getHandler(this.barrel).getStackInSlot(slot);
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        ArrayList<IBarrelMode> modes;
        if (this.barrel.getMode() != null && this.barrel.getMode().isTriggerItemStack(stack)) {
            this.barrel.getMode().addItem(stack, this.barrel);
            this.barrel.func_70296_d();
            IBlockState state = this.barrel.func_145831_w().func_180495_p(this.barrel.func_174877_v());
            this.barrel.func_145831_w().func_175656_a(this.barrel.func_174877_v(), state);
        } else if (this.barrel.getMode() != null && this.barrel.getMode().getHandler(this.barrel) != null) {
            this.barrel.getMode().getHandler(this.barrel).setStackInSlot(slot, stack);
        } else if (this.barrel.getMode() == null && (modes = BarrelModeRegistry.getModes(BarrelModeRegistry.TriggerType.ITEM)) != null) {
            for (IBarrelMode possibleMode : modes) {
                if (!possibleMode.isTriggerItemStack(stack)) continue;
                this.barrel.setMode(possibleMode.getName());
                PacketHandler.sendToAllAround(new MessageBarrelModeUpdate(this.barrel.getMode().getName(), this.barrel.func_174877_v()), this.barrel);
                this.barrel.getMode().addItem(stack, this.barrel);
                this.barrel.func_70296_d();
                IBlockState state = this.barrel.func_145831_w().func_180495_p(this.barrel.func_174877_v());
                this.barrel.func_145831_w().func_175656_a(this.barrel.func_174877_v(), state);
            }
        }
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.barrel.getMode() != null && this.barrel.getMode().getHandler(this.barrel) != null) {
            return this.barrel.getMode().getHandler(this.barrel).extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.barrel.getMode() == null) {
            ArrayList<IBarrelMode> modes = BarrelModeRegistry.getModes(BarrelModeRegistry.TriggerType.ITEM);
            if (modes == null) {
                return stack;
            }
            for (IBarrelMode possibleMode : modes) {
                if (!possibleMode.isTriggerItemStack(stack)) continue;
                if (!simulate) {
                    this.barrel.setMode(possibleMode.getName());
                    PacketHandler.sendToAllAround(new MessageBarrelModeUpdate(this.barrel.getMode().getName(), this.barrel.func_174877_v()), this.barrel);
                    this.barrel.getMode().addItem(stack, this.barrel);
                    this.barrel.func_70296_d();
                    IBlockState state = this.barrel.func_145831_w().func_180495_p(this.barrel.func_174877_v());
                    this.barrel.func_145831_w().func_175656_a(this.barrel.func_174877_v(), state);
                }
                ItemStack ret = stack.func_77946_l();
                ret.func_190918_g(1);
                return ret;
            }
            return stack;
        }
        if (this.barrel.getMode().getHandler(this.barrel) != null) {
            return this.barrel.getMode().getHandler(this.barrel).insertItem(slot, stack, simulate);
        }
        return stack;
    }
}

