/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.barrel.modes.block;

import exnihilocreatio.barrel.IBarrelMode;
import exnihilocreatio.barrel.modes.block.BarrelItemHandlerBlock;
import exnihilocreatio.networking.MessageBarrelModeUpdate;
import exnihilocreatio.networking.PacketHandler;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.tiles.TileBarrel;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelModeBlock
implements IBarrelMode {
    private final BarrelItemHandlerBlock handler = new BarrelItemHandlerBlock(null);
    private ItemInfo block;

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        if (this.block != null) {
            tag.func_74778_a("block", this.block.toString());
        }
        if (!this.handler.getStackInSlot(0).func_190926_b()) {
            this.handler.getStackInSlot(0).func_77955_b(tag);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("block")) {
            this.block = new ItemInfo(tag.func_74779_i("block"));
        }
        this.handler.setStackInSlot(0, new ItemStack(tag));
    }

    @Override
    public boolean isTriggerItemStack(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isTriggerFluidStack(FluidStack stack) {
        return false;
    }

    @Override
    public String getName() {
        return "block";
    }

    @Override
    public List<String> getWailaTooltip(TileBarrel barrel, List<String> currenttip) {
        if (!this.handler.getStackInSlot(0).func_190926_b()) {
            currenttip.add(this.handler.getStackInSlot(0).func_82833_r());
        }
        return currenttip;
    }

    @Override
    public void onBlockActivated(World world, TileBarrel barrel, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.handler.getStackInSlot(0).func_190926_b()) {
            Util.dropItemInWorld(barrel, player, this.handler.getStackInSlot(0), 0.02);
            this.handler.setBarrel(barrel);
            this.handler.setStackInSlot(0, ItemStack.field_190927_a);
            barrel.setMode("null");
            PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("null", barrel.func_174877_v()), barrel);
            barrel.func_70296_d();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForRender(TileBarrel barrel) {
        this.handler.setBarrel(barrel);
        ItemStack stack = this.handler.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return Util.getTextureFromBlockState(Blocks.field_150350_a.func_176223_P());
        }
        return Util.getTextureFromBlockState(Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77952_i()));
    }

    @Override
    public Color getColorForRender(TileBarrel barrel) {
        return Util.whiteColor;
    }

    @Override
    public float getFilledLevelForRender(TileBarrel barrel) {
        return 0.9375f;
    }

    @Override
    public void update(TileBarrel barrel) {
    }

    @Override
    public void addItem(ItemStack stack, TileBarrel barrel) {
        this.handler.setBarrel(barrel);
        if (this.handler.getStackInSlot(0).func_190926_b()) {
            this.handler.insertItem(0, stack, false);
        }
    }

    @Override
    public ItemStackHandler getHandler(TileBarrel barrel) {
        this.handler.setBarrel(barrel);
        return this.handler;
    }

    @Override
    public FluidTank getFluidHandler(TileBarrel barrel) {
        return null;
    }

    @Override
    public boolean canFillWithFluid(TileBarrel barrel) {
        return false;
    }

    public ItemInfo getBlock() {
        return this.block;
    }

    public void setBlock(ItemInfo block) {
        this.block = block;
    }
}

