/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.client.renderers;

import exnihilocreatio.blocks.BlockInfestingLeaves;
import exnihilocreatio.client.models.ModelVertex;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.tiles.TileInfestingLeaves;
import exnihilocreatio.util.Util;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.animation.FastTESR;

public class RenderInfestingLeaves
extends FastTESR<TileInfestingLeaves> {
    private static final ModelVertex[] model = new ModelVertex[24];

    public void renderTileEntityFast(@Nullable TileInfestingLeaves te, double x, double y, double z, float partialTicks, int destroyStage, float partial, @Nullable BufferBuilder buffer) {
        if (te == null || buffer == null) {
            return;
        }
        BlockPos pos = te.func_174877_v();
        Block block = this.func_178459_a().func_180495_p(pos).func_177230_c();
        int mixedBrightness = this.func_178459_a().func_180495_p(pos).func_185889_a((IBlockAccess)te.func_145831_w(), pos);
        int skyLight = mixedBrightness >> 16 & 0xFFFF;
        int blockLight = mixedBrightness & 0xFFFF;
        IBlockState state = te.getLeafBlock();
        Color color = block instanceof BlockInfestingLeaves ? Color.average(new Color(BiomeColorHelper.func_180287_b((IBlockAccess)this.func_178459_a(), (BlockPos)pos)), Util.whiteColor, (float)Math.pow((float)te.getProgress() / 100.0f, 2.0)) : Util.whiteColor;
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        buffer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)skyLight * 16.0f), (float)((float)blockLight * 16.0f));
        Vec3d view = Minecraft.func_71410_x().func_175606_aa().func_174824_e(partialTicks);
        for (ModelVertex vert : model) {
            EnumFacing face = vert.face;
            double dot = 0.0;
            switch (face) {
                case DOWN: {
                    dot = -(view.field_72448_b - (double)pos.func_177956_o());
                    break;
                }
                case UP: {
                    dot = view.field_72448_b - (double)(pos.func_177956_o() + 1);
                    break;
                }
                case NORTH: {
                    dot = -(view.field_72449_c - (double)pos.func_177952_p());
                    break;
                }
                case SOUTH: {
                    dot = view.field_72449_c - (double)(pos.func_177952_p() + 1);
                    break;
                }
                case WEST: {
                    dot = -(view.field_72450_a - (double)pos.func_177958_n());
                    break;
                }
                case EAST: {
                    dot = view.field_72450_a - (double)(pos.func_177958_n() + 1);
                }
            }
            if (!(dot > 0.0) || !state.func_185894_c((IBlockAccess)this.func_178459_a(), pos, vert.face)) continue;
            for (VertexFormatElement e : buffer.func_178973_g().func_177343_g()) {
                switch (e.func_177375_c()) {
                    case COLOR: {
                        buffer.func_181666_a(color.r, color.g, color.b, color.a);
                        break;
                    }
                    case NORMAL: {
                        buffer.func_181663_c((float)face.func_82601_c(), (float)face.func_96559_d(), (float)face.func_82599_e());
                        break;
                    }
                    case POSITION: {
                        double vertX = (double)pos.func_177958_n() + vert.x;
                        double vertY = (double)pos.func_177956_o() + vert.y;
                        double vertZ = (double)pos.func_177952_p() + vert.z;
                        buffer.func_181662_b(vertX, vertY, vertZ);
                        break;
                    }
                    case UV: {
                        if (e.func_177369_e() == 1) {
                            buffer.func_187314_a(skyLight, blockLight);
                            break;
                        }
                        buffer.func_187315_a((double)sprite.func_94214_a(vert.u), (double)sprite.func_94207_b(16.0 - vert.v));
                        break;
                    }
                }
            }
            buffer.func_181675_d();
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
    }

    static {
        RenderInfestingLeaves.model[0] = new ModelVertex(EnumFacing.UP, 0.0, 1.0, 0.0, 0.0, 1.0);
        RenderInfestingLeaves.model[1] = new ModelVertex(EnumFacing.UP, 1.0, 1.0, 0.0, 1.0, 1.0);
        RenderInfestingLeaves.model[2] = new ModelVertex(EnumFacing.UP, 1.0, 1.0, 1.0, 1.0, 0.0);
        RenderInfestingLeaves.model[3] = new ModelVertex(EnumFacing.UP, 0.0, 1.0, 1.0, 0.0, 0.0);
        RenderInfestingLeaves.model[4] = new ModelVertex(EnumFacing.DOWN, 0.0, 0.0, 0.0, 0.0, 0.0);
        RenderInfestingLeaves.model[5] = new ModelVertex(EnumFacing.DOWN, 1.0, 0.0, 0.0, 1.0, 0.0);
        RenderInfestingLeaves.model[6] = new ModelVertex(EnumFacing.DOWN, 1.0, 0.0, 1.0, 1.0, 1.0);
        RenderInfestingLeaves.model[7] = new ModelVertex(EnumFacing.DOWN, 0.0, 0.0, 1.0, 0.0, 1.0);
        RenderInfestingLeaves.model[8] = new ModelVertex(EnumFacing.NORTH, 0.0, 0.0, 0.0, 1.0, 0.0);
        RenderInfestingLeaves.model[9] = new ModelVertex(EnumFacing.NORTH, 1.0, 0.0, 0.0, 0.0, 0.0);
        RenderInfestingLeaves.model[10] = new ModelVertex(EnumFacing.NORTH, 1.0, 1.0, 0.0, 0.0, 1.0);
        RenderInfestingLeaves.model[11] = new ModelVertex(EnumFacing.NORTH, 0.0, 1.0, 0.0, 1.0, 1.0);
        RenderInfestingLeaves.model[12] = new ModelVertex(EnumFacing.SOUTH, 0.0, 0.0, 1.0, 0.0, 0.0);
        RenderInfestingLeaves.model[13] = new ModelVertex(EnumFacing.SOUTH, 1.0, 0.0, 1.0, 1.0, 0.0);
        RenderInfestingLeaves.model[14] = new ModelVertex(EnumFacing.SOUTH, 1.0, 1.0, 1.0, 1.0, 1.0);
        RenderInfestingLeaves.model[15] = new ModelVertex(EnumFacing.SOUTH, 0.0, 1.0, 1.0, 0.0, 1.0);
        RenderInfestingLeaves.model[16] = new ModelVertex(EnumFacing.EAST, 1.0, 0.0, 0.0, 1.0, 0.0);
        RenderInfestingLeaves.model[17] = new ModelVertex(EnumFacing.EAST, 1.0, 0.0, 1.0, 0.0, 0.0);
        RenderInfestingLeaves.model[18] = new ModelVertex(EnumFacing.EAST, 1.0, 1.0, 1.0, 0.0, 1.0);
        RenderInfestingLeaves.model[19] = new ModelVertex(EnumFacing.EAST, 1.0, 1.0, 0.0, 1.0, 1.0);
        RenderInfestingLeaves.model[20] = new ModelVertex(EnumFacing.WEST, 0.0, 0.0, 0.0, 0.0, 0.0);
        RenderInfestingLeaves.model[21] = new ModelVertex(EnumFacing.WEST, 0.0, 0.0, 1.0, 1.0, 0.0);
        RenderInfestingLeaves.model[22] = new ModelVertex(EnumFacing.WEST, 0.0, 1.0, 1.0, 1.0, 1.0);
        RenderInfestingLeaves.model[23] = new ModelVertex(EnumFacing.WEST, 0.0, 1.0, 0.0, 0.0, 1.0);
    }
}

